/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.jboss.tools.vpe.editor.VpeIncludeInfo;
import org.jboss.tools.vpe.editor.VpeVisualDomBuilder;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.VpeElementMapping;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.template.VpeCreatorUtil;
import org.jboss.tools.vpe.editor.template.VpeTemplate;
import org.jboss.tools.vpe.editor.template.VpeTemplateManager;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNamedNodeMap;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class VpeDefineContainerTemplate
extends VpeAbstractTemplate {
    private static Set<Node> defineContainer = new HashSet<Node>();
    private static final Pattern CURLY_BRACKET_PATTERN = Pattern.compile("(" + Pattern.quote("#") + "\\{(.+?)\\})+?");
    private static final Pattern WORD_PATTERN = Pattern.compile("((\\w+)([\\.\\[\\]]*))");

    @Override
    protected void init(Element templateElement) {
        this.children = true;
        this.modify = false;
        this.initTemplateSections(templateElement, false, true, false, false, false);
    }

    public VpeCreationData createTemplate(String includedFileName, VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        IFile file;
        VpeCreationData creationData = null;
        if (includedFileName != null && includedFileName.trim().length() > 0 && (file = VpeCreatorUtil.getFile(includedFileName, pageContext)) != null && !pageContext.getVisualBuilder().isFileInIncludeStack((IStorage)file)) {
            Document document = pageContext.getVisualBuilder().getIncludeDocuments().get(file);
            if (document == null) {
                document = VpeCreatorUtil.getDocumentForRead(file);
            }
            if (document != null) {
                pageContext.getVisualBuilder().getIncludeDocuments().put((IStorage)file, document);
                creationData = this.createInclude(document, visualDocument);
                creationData.setData(new TemplateFileInfo(file));
                pageContext.getVisualBuilder().pushIncludeStack(new VpeIncludeInfo((Element)sourceNode, (IStorage)file, document));
                this.registerDefine(pageContext, sourceNode);
                if (sourceNode.getFirstChild() != null) {
                    defineContainer.add(sourceNode.getFirstChild().getParentNode());
                } else {
                    defineContainer.add(sourceNode);
                }
                return creationData;
            }
        }
        creationData = this.createStub(includedFileName, (Element)sourceNode, visualDocument);
        creationData.setData(null);
        return creationData;
    }

    private String replacePattern(String origStr, String target, String replacement) {
        if (origStr == null || target == null) {
            return origStr;
        }
        StringBuilder sb = new StringBuilder();
        Matcher m = WORD_PATTERN.matcher(origStr);
        int endIndex = 0;
        int startIndex = 0;
        while (m.find()) {
            String variable = m.group(2);
            String signs = m.group(3);
            startIndex = m.start(2);
            if (startIndex != 0 && endIndex != 0 && endIndex != startIndex) {
                sb.append(origStr.substring(endIndex, startIndex));
            }
            if (target.equals(variable)) {
                sb.append(replacement);
            } else {
                sb.append(variable);
            }
            sb.append(signs);
            endIndex = m.end(3);
        }
        if (endIndex != origStr.length()) {
            sb.append(origStr.substring(endIndex, origStr.length()));
        }
        if (!"".equals(sb.toString())) {
            return sb.toString();
        }
        return origStr;
    }

    private void updateNodeValue(nsIDOMNode node, Map<String, String> paramsMap) {
        Set<String> keys = paramsMap.keySet();
        if (node != null) {
            String nodeValue = node.getNodeValue();
            int matcherGroupWithVariable = 2;
            if (nodeValue != null && !"".equals(nodeValue)) {
                for (String key : keys) {
                    Matcher curlyBracketMatcher = CURLY_BRACKET_PATTERN.matcher(nodeValue);
                    String replacement = paramsMap.get(key);
                    if (replacement.startsWith("#{") && replacement.endsWith("}")) {
                        replacement = replacement.substring(2);
                        replacement = replacement.substring(0, replacement.length() - 1);
                    }
                    int lastPos = 0;
                    StringBuilder sb = new StringBuilder();
                    curlyBracketMatcher.reset(nodeValue);
                    boolean firstFind = false;
                    boolean find = curlyBracketMatcher.find();
                    while (find) {
                        if (!firstFind) {
                            firstFind = true;
                        }
                        int start = curlyBracketMatcher.start(matcherGroupWithVariable);
                        int end = curlyBracketMatcher.end(matcherGroupWithVariable);
                        String group = this.replacePattern(curlyBracketMatcher.group(matcherGroupWithVariable), key, replacement);
                        sb.append(nodeValue.substring(lastPos, start));
                        sb.append(group);
                        lastPos = end;
                        find = curlyBracketMatcher.find();
                    }
                    if (!firstFind) continue;
                    sb.append(nodeValue.substring(lastPos, nodeValue.length()));
                    nodeValue = sb.toString();
                    node.setNodeValue(nodeValue);
                }
            }
        }
    }

    private void insertParam(nsIDOMNode node, Map<String, String> paramsMap) {
        nsIDOMNodeList children;
        this.updateNodeValue(node, paramsMap);
        nsIDOMNamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            long len = attributes.getLength();
            int i = 0;
            while ((long)i < len) {
                nsIDOMNode item = attributes.item((long)i);
                this.updateNodeValue(item, paramsMap);
                ++i;
            }
        }
        if ((children = node.getChildNodes()) != null) {
            long len = children.getLength();
            int i = 0;
            while ((long)i < len) {
                nsIDOMNode child = children.item((long)i);
                this.insertParam(child, paramsMap);
                ++i;
            }
        }
    }

    @Override
    public void validate(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, VpeCreationData creationData) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        NodeList sourceChildren = sourceNode.getChildNodes();
        int len = sourceChildren.getLength();
        int i = 0;
        while (i < len) {
            Node sourceChild = sourceChildren.item(i);
            if (sourceChild.getNodeType() == 1 && "param".equals(sourceChild.getLocalName())) {
                String name = ((Element)sourceChild).getAttribute("name");
                String value = ((Element)sourceChild).getAttribute("value");
                paramsMap.put(name, value);
            }
            ++i;
        }
        nsIDOMNode node = creationData.getNode();
        this.insertParam(node, paramsMap);
        TemplateFileInfo templateFileInfo = (TemplateFileInfo)creationData.getData();
        if (templateFileInfo != null) {
            pageContext.getVisualBuilder().popIncludeStack();
        }
        defineContainer.remove(sourceNode);
    }

    @Override
    public void beforeRemove(VpePageContext pageContext, Node sourceNode, nsIDOMNode visualNode, Object data) {
        TemplateFileInfo templateFileInfo = (TemplateFileInfo)data;
        if (templateFileInfo != null && templateFileInfo.templateFile != null) {
            pageContext.getEditPart().getController().getIncludeList().removeIncludeModel(templateFileInfo.templateFile);
        }
    }

    private void registerDefine(VpePageContext pageContext, Node defineContainer) {
        VpeTemplate template = null;
        NodeList sourceChildren = defineContainer.getChildNodes();
        int len = sourceChildren.getLength();
        int i = 0;
        while (i < len) {
            Node sourceChild = sourceChildren.item(i);
            if (sourceChild.getNodeType() == 1 && "define".equals(sourceChild.getLocalName())) {
                VpeTemplateManager templateManager;
                if (template == null && (template = (templateManager = pageContext.getVisualBuilder().getTemplateManager()).getTemplate(pageContext, (Element)sourceChild, null)) == null) break;
                pageContext.getVisualBuilder().registerNodes(new VpeElementMapping(sourceChild, null, template, null, null, null));
            }
            ++i;
        }
    }

    private VpeCreationData createInclude(Document sourceDocument, nsIDOMDocument visualDocument) {
        nsIDOMElement visualNewElement = visualDocument.createElement("div");
        VpeVisualDomBuilder.markIncludeElement(visualNewElement);
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)visualNewElement);
        VpeChildrenInfo childrenInfo = new VpeChildrenInfo(visualNewElement);
        NodeList sourceChildren = sourceDocument.getChildNodes();
        int len = sourceChildren.getLength();
        int i = 0;
        while (i < len) {
            childrenInfo.addSourceChild(sourceChildren.item(i));
            ++i;
        }
        creationData.addChildrenInfo(childrenInfo);
        return creationData;
    }

    @Override
    public boolean containsText() {
        return false;
    }

    public static boolean isDefineContainer(Node sourceNode) {
        while (sourceNode != null) {
            if (defineContainer.contains(sourceNode)) {
                return true;
            }
            sourceNode = sourceNode.getParentNode();
        }
        return false;
    }

    protected VpeCreationData createStub(String fileName, Node sourceElement, nsIDOMDocument visualDocument) {
        nsIDOMElement container = visualDocument.createElement("div");
        container.setAttribute("style", "border: 1px dashed #2A7F00");
        VpeVisualDomBuilder.markIncludeElement(container);
        nsIDOMElement title = visualDocument.createElement("div");
        nsIDOMElement tag = visualDocument.createElement("span");
        tag.setAttribute("class", "__any__tag__caption");
        tag.appendChild((nsIDOMNode)visualDocument.createTextNode(sourceElement.getNodeName()));
        title.appendChild((nsIDOMNode)tag);
        if (fileName != null) {
            title.appendChild((nsIDOMNode)visualDocument.createTextNode(fileName));
        }
        container.appendChild((nsIDOMNode)title);
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)container);
        VpeChildrenInfo childrenInfo = new VpeChildrenInfo(container);
        NodeList sourceChildren = sourceElement.getChildNodes();
        int len = sourceChildren.getLength();
        int i = 0;
        while (i < len) {
            Node sourceChild = sourceChildren.item(i);
            if (sourceChild.getNodeType() == 1 && "define".equals(sourceChild.getLocalName())) {
                childrenInfo.addSourceChild(sourceChild);
            }
            ++i;
        }
        creationData.addChildrenInfo(childrenInfo);
        return creationData;
    }

    static class TemplateFileInfo {
        private IFile templateFile;

        TemplateFileInfo(IFile templateFile) {
            this.templateFile = templateFile;
        }

        public IFile getTemplateFile() {
            return this.templateFile;
        }

        public void setTemplateFile(IFile templateFile) {
            this.templateFile = templateFile;
        }
    }
}

