/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.pv;

import java.util.ArrayList;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.core.resources.IResource;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.struts.model.pv.StrutsProjectFolder;
import org.jboss.tools.struts.webprj.model.helpers.WebModulesHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StrutsProjectPlugin
extends StrutsProjectFolder {
    public void invalidate() {
        if (!this.valid || this.isLoading) {
            return;
        }
        this.valid = false;
        this.fireStructureChanged(3, (Object)this);
    }

    public XModelObject[] getTreeChildren() {
        if (this.isLoading || this.valid) {
            return this.treeChildren;
        }
        this.isLoading = true;
        this.valid = true;
        try {
            WebModulesHelper h = WebModulesHelper.getInstance(this.getModel());
            XModelObject[] cs = h.getAllConfigs();
            TreeSet<String> uris = new TreeSet<String>();
            this.collect(cs, uris);
            ArrayList<XModelObject> list = new ArrayList<XModelObject>();
            String[] us = uris.toArray(new String[0]);
            int i = 0;
            while (i < us.length) {
                XModelObject o = XModelImpl.getByRelativePath((XModel)this.getModel(), (String)us[i]);
                if (o != null) {
                    list.add(o);
                }
                ++i;
            }
            this.treeChildren = list.toArray(new XModelObject[0]);
        }
        finally {
            this.isLoading = false;
        }
        return this.treeChildren;
    }

    protected void collect(XModelObject[] cgs, Set<String> uris) {
        int i = 0;
        while (i < cgs.length) {
            this.collect(cgs[i], uris);
            ++i;
        }
    }

    protected void collect(XModelObject c, Set<String> uris) {
        String pathnames = this.getPathnames(c);
        if (pathnames == null || pathnames.length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(pathnames, ",");
        while (st.hasMoreTokens()) {
            uris.add(st.nextToken().trim());
        }
    }

    protected abstract String getPathnames(XModelObject var1);

    public Object getAdapter(Class adapter) {
        if (adapter == IResource.class) {
            XModelObject o = FileSystemsHelper.getWebInf((XModel)this.getModel());
            return o != null ? o.getAdapter(adapter) : null;
        }
        return super.getAdapter(adapter);
    }

    private XModelObject findPlugin(XModelObject c, String className) {
        XModelObject plugins = c.getChildByPath("plug-ins");
        if (plugins == null) {
            return null;
        }
        XModelObject[] cs = plugins.getChildren();
        int i = 0;
        while (i < cs.length) {
            if (className.equals(cs[i].getAttributeValue("className"))) {
                return cs[i];
            }
            ++i;
        }
        return null;
    }

    protected String getPathnames(XModelObject c, String pluginClassName, String propertyName) {
        XModelObject plugin = this.findPlugin(c, pluginClassName);
        if (plugin == null) {
            return null;
        }
        XModelObject[] cs = plugin.getChildren();
        int i = 0;
        while (i < cs.length) {
            if (propertyName.equals(cs[i].getAttributeValue("property"))) {
                return cs[i].getAttributeValue("value");
            }
            ++i;
        }
        return null;
    }
}

