/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.project.dependencies;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyFilter;
import org.jboss.forge.project.dependencies.DependencyMetadata;
import org.jboss.forge.project.dependencies.DependencyQuery;
import org.jboss.forge.project.dependencies.DependencyRepository;
import org.jboss.forge.project.dependencies.DependencyResolverProvider;
import org.jboss.forge.resources.DependencyResource;

@Singleton
public class DependencyResolver {
    private final Instance<DependencyResolverProvider> providers;

    @Inject
    public DependencyResolver(Instance<DependencyResolverProvider> providers) {
        this.providers = providers;
    }

    public List<DependencyResource> resolveArtifacts(Dependency query) {
        for (DependencyResolverProvider p : this.providers) {
            List<DependencyResource> artifacts = p.resolveArtifacts(query);
            if (artifacts == null || artifacts.isEmpty()) continue;
            return artifacts;
        }
        return new ArrayList<DependencyResource>();
    }

    public List<DependencyResource> resolveArtifacts(Dependency query, DependencyRepository repository) {
        for (DependencyResolverProvider p : this.providers) {
            List<DependencyResource> artifacts = p.resolveArtifacts(query, repository);
            if (artifacts == null || artifacts.isEmpty()) continue;
            return artifacts;
        }
        return new ArrayList<DependencyResource>();
    }

    public List<DependencyResource> resolveArtifacts(Dependency query, List<DependencyRepository> repositories) {
        for (DependencyResolverProvider p : this.providers) {
            List<DependencyResource> artifacts = p.resolveArtifacts(query, repositories);
            if (artifacts == null || artifacts.isEmpty()) continue;
            return artifacts;
        }
        return new ArrayList<DependencyResource>();
    }

    public List<DependencyResource> resolveDependencies(Dependency query) {
        for (DependencyResolverProvider p : this.providers) {
            List<DependencyResource> artifacts = p.resolveDependencies(query);
            if (artifacts == null || artifacts.isEmpty()) continue;
            return artifacts;
        }
        return new ArrayList<DependencyResource>();
    }

    public List<DependencyResource> resolveDependencies(Dependency query, DependencyRepository repository) {
        for (DependencyResolverProvider p : this.providers) {
            List<DependencyResource> artifacts = p.resolveDependencies(query, repository);
            if (artifacts == null || artifacts.isEmpty()) continue;
            return artifacts;
        }
        return new ArrayList<DependencyResource>();
    }

    public List<DependencyResource> resolveDependencies(Dependency query, List<DependencyRepository> repositories) {
        for (DependencyResolverProvider p : this.providers) {
            List<DependencyResource> artifacts = p.resolveDependencies(query, repositories);
            if (artifacts == null || artifacts.isEmpty()) continue;
            return artifacts;
        }
        return new ArrayList<DependencyResource>();
    }

    public DependencyMetadata resolveDependencyMetadata(Dependency query) {
        for (DependencyResolverProvider p : this.providers) {
            DependencyMetadata meta = p.resolveDependencyMetadata(query);
            if (meta == null) continue;
            return meta;
        }
        return null;
    }

    public DependencyMetadata resolveDependencyMetadata(Dependency query, DependencyRepository repository) {
        for (DependencyResolverProvider p : this.providers) {
            DependencyMetadata meta = p.resolveDependencyMetadata(query, repository);
            if (meta == null) continue;
            return meta;
        }
        return null;
    }

    public DependencyMetadata resolveDependencyMetadata(Dependency query, List<DependencyRepository> repositories) {
        for (DependencyResolverProvider p : this.providers) {
            DependencyMetadata meta = p.resolveDependencyMetadata(query, repositories);
            if (meta == null) continue;
            return meta;
        }
        return null;
    }

    @Deprecated
    public List<Dependency> resolveVersions(Dependency query) {
        for (DependencyResolverProvider p : this.providers) {
            List<Dependency> artifacts = p.resolveVersions(query);
            if (artifacts == null || artifacts.isEmpty()) continue;
            return artifacts;
        }
        return new ArrayList<Dependency>();
    }

    @Deprecated
    public List<Dependency> resolveVersions(Dependency query, DependencyRepository repository) {
        for (DependencyResolverProvider p : this.providers) {
            List<Dependency> artifacts = p.resolveVersions(query, repository);
            if (artifacts == null || artifacts.isEmpty()) continue;
            return artifacts;
        }
        return new ArrayList<Dependency>();
    }

    @Deprecated
    public List<Dependency> resolveVersions(Dependency query, List<DependencyRepository> repositories) {
        for (DependencyResolverProvider p : this.providers) {
            List<Dependency> artifacts = p.resolveVersions(query, repositories);
            if (artifacts == null || artifacts.isEmpty()) continue;
            return artifacts;
        }
        return new ArrayList<Dependency>();
    }

    public List<Dependency> resolveVersions(DependencyQuery query) {
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        DependencyFilter dependencyFilter = query.getDependencyFilter();
        Dependency dependency = query.getDependency();
        List<DependencyRepository> dependencyRepositories = query.getDependencyRepositories();
        for (DependencyResolverProvider p : this.providers) {
            List<Dependency> artifacts = p.resolveVersions(dependency, dependencyRepositories);
            if (artifacts == null) continue;
            for (Dependency artifact : artifacts) {
                if (dependencyFilter != null && !dependencyFilter.accept(artifact)) continue;
                deps.add(artifact);
            }
        }
        return deps;
    }
}

