/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.resources;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.jboss.forge.project.services.ResourceFactory;
import org.jboss.forge.resources.AbstractResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.ResourceFlag;

public class URLResource
extends AbstractResource<URL> {
    private URL url;

    public URLResource(ResourceFactory factory, URL url) {
        super(factory, null);
        this.url = url;
        this.setFlag(ResourceFlag.Leaf);
    }

    @Override
    public boolean delete() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean delete(boolean recursive) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.url.toString();
    }

    @Override
    public Resource<URL> createFrom(URL url) {
        return new URLResource(this.resourceFactory, url);
    }

    @Override
    public URL getUnderlyingResourceObject() {
        return this.url;
    }

    @Override
    public InputStream getResourceInputStream() {
        try {
            return this.url.openStream();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not open stream", e);
        }
    }

    @Override
    public Resource<?> getChild(String name) {
        return null;
    }

    @Override
    public boolean exists() {
        try {
            HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
            connection.setRequestMethod("HEAD");
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    protected List<Resource<?>> doListResources() {
        return Collections.emptyList();
    }
}

