/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.loaders.impl;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.meta.action.impl.XEntityDataImpl;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.XModelObjectConstants;
import org.jboss.tools.common.model.filesystems.impl.AbstractXMLFileImpl;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.filesystems.impl.FolderLoader;
import org.jboss.tools.common.model.loaders.impl.SerializingLoader;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.EntityXMLRegistration;
import org.jboss.tools.common.model.util.XMLUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimpleWebFileLoader
implements SerializingLoader,
XModelObjectConstants {
    protected XModelObjectLoaderUtil util = this.createUtil();

    public SimpleWebFileLoader() {
        this.util.setSaveEntity(false);
    }

    public XModelObjectLoaderUtil getUtil() {
        return this.util;
    }

    protected XModelObjectLoaderUtil createUtil() {
        return new XModelObjectLoaderUtil();
    }

    protected boolean isCheckingDTD() {
        return true;
    }

    protected boolean isCheckingSchema() {
        return !this.isCheckingDTD();
    }

    @Override
    public void load(XModelObject object) {
        String body = XModelObjectLoaderUtil.getTempBody(object);
        Document doc = this.loadDocument(object, body);
        if (doc == null) {
            XModelObjectLoaderUtil.addRequiredChildren(object);
            return;
        }
        Element element = doc.getDocumentElement();
        this.loadNamespace(element, object);
        String postfix = "";
        element.setAttribute("NAME" + postfix, object.getAttributeValue("name"));
        element.setAttribute("EXTENSION" + postfix, object.getAttributeValue("extension"));
        this.util.load(element, object);
        String loadingError = this.util.getError();
        this.setEncoding(object, body);
        this.loadPublicId(object, doc);
        object.set("actualBodyTimeStamp", "" + object.getTimeStamp());
        ((AbstractXMLFileImpl)object).setLoaderError(loadingError);
        if (!((AbstractXMLFileImpl)object).isIncorrect() && loadingError != null) {
            object.setAttributeValue("isIncorrect", "yes");
            object.setAttributeValue("incorrectBody", body);
            object.set("actualBodyTimeStamp", "" + object.getTimeStamp());
        }
    }

    protected Document loadDocument(XModelObject object, String body) {
        String[] errors;
        int resolution = EntityXMLRegistration.getInstance().resolve(object.getModelEntity());
        if (EntityXMLRegistration.isSystemId(body)) {
            resolution = EntityXMLRegistration.UNRESOLVED;
        }
        if ((errors = XMLUtil.getXMLErrors(new StringReader(body), resolution == EntityXMLRegistration.DTD && this.isCheckingDTD(), resolution == EntityXMLRegistration.SCHEMA)) != null && errors.length > 0) {
            object.setAttributeValue("isIncorrect", "yes");
            object.set("correctBody", "");
            object.setAttributeValue("incorrectBody", body);
            object.set("actualBodyTimeStamp", "-1");
        } else {
            object.setAttributeValue("isIncorrect", "no");
            object.set("correctBody", body);
            object.set("actualBodyTimeStamp", "0");
            object.setAttributeValue("incorrectBody", "");
        }
        return XMLUtil.getDocument(new StringReader(body));
    }

    protected String loadNamespace(Element element, XModelObject object) {
        String rootName = element.getNodeName();
        String namespace = null;
        if (rootName.indexOf(58) > 0) {
            namespace = rootName.substring(0, rootName.indexOf(58));
        }
        if (namespace != null) {
            this.util.setNamespace(namespace);
            object.setAttributeValue("namespace", namespace);
        } else {
            this.util.setNamespace(null);
            object.setAttributeValue("namespace", "");
        }
        return namespace;
    }

    protected void loadPublicId(XModelObject object, Document doc) {
        XModelEntity entity = object.getModelEntity();
        if (entity.getAttribute("publicId") != null) {
            NodeList nl = doc.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node n = nl.item(i);
                if (n instanceof DocumentType) {
                    DocumentType dt = (DocumentType)n;
                    String s = dt.getSystemId();
                    if (s == null) {
                        s = "";
                    }
                    object.setAttributeValue("systemId", s);
                    s = dt.getPublicId();
                    if (s == null) {
                        s = "";
                    }
                    object.setAttributeValue("publicId", s);
                }
                ++i;
            }
        }
    }

    protected void setEncoding(XModelObject object, String body) {
        String encoding = XModelObjectLoaderUtil.getEncoding(body);
        if (encoding == null) {
            encoding = "";
        }
        object.setAttributeValue("encoding", encoding);
    }

    @Override
    public boolean update(XModelObject object) throws XModelException {
        XModelObject p = object.getParent();
        if (p == null) {
            return true;
        }
        FolderLoader fl = (FolderLoader)((Object)p);
        String body = fl.getBodySource(FileAnyImpl.toFileName(object)).get();
        FileAnyImpl f = (FileAnyImpl)object;
        f.setUpdateLock();
        try {
            f.edit(body);
        }
        finally {
            f.releaseUpdateLock();
        }
        object.setModified(false);
        XModelObjectLoaderUtil.updateModifiedOnSave(object);
        return true;
    }

    @Override
    public boolean save(XModelObject object) {
        if (!object.isModified()) {
            return true;
        }
        if ("yes".equals(object.get("isIncorrect"))) {
            XModelObjectLoaderUtil.setTempBody(object, object.get("incorrectBody"));
            return true;
        }
        String main = object.get("body");
        if (main == null) {
            return false;
        }
        XModelObjectLoaderUtil.setTempBody(object, main);
        return true;
    }

    @Override
    public String serializeObject(XModelObject object) {
        Element element = this.createRootElement(object);
        return this.serializeToElement(element, object);
    }

    public Element createRootElement(XModelObject object) {
        String systemId = object.getAttributeValue("systemId");
        String publicId = object.getAttributeValue("publicId");
        String rootName = this.getRootName(object);
        return this.createRootElement(rootName, publicId, systemId);
    }

    protected String getRootName(XModelObject object) {
        String namespace = object.getAttributeValue("namespace");
        String rootName = object.getModelEntity().getXMLSubPath();
        if (namespace != null && namespace.length() > 0) {
            this.util.setNamespace(namespace);
            rootName = String.valueOf(namespace) + ":" + rootName;
        } else {
            this.util.setNamespace(null);
        }
        return rootName;
    }

    protected Element createRootElement(String rootName, String publicId, String systemId) {
        return systemId == null || publicId == null ? XMLUtil.createDocumentElement(rootName) : (publicId.length() == 0 ? XMLUtil.createDocumentElement(rootName, this.getDocName(), null, systemId, null) : XMLUtil.createDocumentElement(rootName, this.getDocName(), publicId, systemId, null));
    }

    protected String serializeToElement(Element element, XModelObject object) {
        try {
            this.util.saveAttributes(element, object);
            this.util.saveChildren(element, object);
            this.util.saveFinalComment(element, object);
            element.removeAttribute("NAME");
            element.removeAttribute("EXTENSION");
            return SimpleWebFileLoader.serialize(element, object);
        }
        catch (IOException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (XModelException e) {
            ModelPlugin.getPluginLog().logError((Throwable)((Object)e));
        }
        return null;
    }

    protected String getDocName() {
        return "taglib";
    }

    public static String serialize(Element element, XModelObject object) throws XModelException, IOException {
        String encoding = object.getAttributeValue("encoding");
        StringWriter sw = new StringWriter();
        try {
            XModelObjectLoaderUtil.serialize(element.getOwnerDocument(), sw, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if ("UTF-8".equals(encoding)) {
                return null;
            }
            ServiceDialog d = object.getModel().getService();
            XEntityDataImpl data = XEntityDataImpl.create(new String[][]{{object.getModelEntity().getName(), "yes"}, {"encoding", "no"}});
            data.setValue("encoding", "UTF-8");
            String message = MessageFormat.format("Encoding {0} is not supported. Please enter correct value.", encoding);
            int q = d.showDialog("Error", message, new String[]{"OK"}, data, 1);
            encoding = q != 0 ? "UTF-8" : data.getValue("encoding");
            object.setAttributeValue("encoding", encoding);
            return SimpleWebFileLoader.serialize(element, object);
        }
        return sw.toString();
    }

    @Override
    public void loadFragment(XModelObject object, Element element) {
        this.util.load(element, object);
    }
}

