/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.init;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import org.dom4j.Attribute;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Namespace;
import org.jboss.seam.annotations.Role;
import org.jboss.seam.annotations.Roles;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.Jbpm;
import org.jboss.seam.core.PojoCache;
import org.jboss.seam.debug.Introspector;
import org.jboss.seam.deployment.ComponentScanner;
import org.jboss.seam.deployment.NamespaceScanner;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.servlet.AbstractResource;
import org.jboss.seam.util.Conversions;
import org.jboss.seam.util.Naming;
import org.jboss.seam.util.Reflections;
import org.jboss.seam.util.Resources;
import org.jboss.seam.util.Strings;
import org.jboss.seam.util.XML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Initialization {
    public static final String COMPONENT_SUFFIX = ".component";
    private static final LogProvider log = Logging.getLogProvider(Initialization.class);
    private ServletContext servletContext;
    private Map<String, Conversions.PropertyValue> properties = new HashMap<String, Conversions.PropertyValue>();
    private Map<String, SortedSet<ComponentDescriptor>> componentDescriptors = new HashMap<String, SortedSet<ComponentDescriptor>>();
    private List<FactoryDescriptor> factoryDescriptors = new ArrayList<FactoryDescriptor>();
    private Set<Class> installedComponents = new HashSet<Class>();
    private Set<String> importedPackages = new HashSet<String>();
    private Map<String, NamespaceDescriptor> namespaceMap = new HashMap<String, NamespaceDescriptor>();
    private final Map<String, EventListenerDescriptor> eventListenerDescriptors = new HashMap<String, EventListenerDescriptor>();

    public Initialization(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.addNamespaces();
        this.initComponentsFromXmlDocument("/WEB-INF/components.xml");
        this.initComponentsFromXmlDocument("/WEB-INF/events.xml");
        this.initComponentsFromXmlDocuments();
        this.initPropertiesFromServletContext();
        this.initPropertiesFromResource();
        this.initJndiProperties();
    }

    private void initComponentsFromXmlDocuments() {
        Enumeration<URL> resources;
        try {
            resources = Thread.currentThread().getContextClassLoader().getResources("META-INF/components.xml");
        }
        catch (IOException ioe) {
            throw new RuntimeException("error scanning META-INF/components.xml files", ioe);
        }
        Properties replacements = this.getReplacements();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            try {
                log.info("reading " + url);
                this.installComponentsFromXmlElements(XML.getRootElement(url.openStream()), replacements);
            }
            catch (Exception e) {
                throw new RuntimeException("error while reading " + url, e);
            }
        }
    }

    private void initComponentsFromXmlDocument(String resource) {
        InputStream stream = Resources.getResourceAsStream(resource, this.servletContext);
        if (stream != null) {
            log.info("reading " + resource);
            try {
                this.installComponentsFromXmlElements(XML.getRootElement(stream), this.getReplacements());
            }
            catch (Exception e) {
                throw new RuntimeException("error while reading /WEB-INF/components.xml", e);
            }
        }
    }

    private Properties getReplacements() {
        try {
            Properties replacements = new Properties();
            InputStream replaceStream = Resources.getResourceAsStream("components.properties");
            if (replaceStream != null) {
                replacements.load(replaceStream);
            }
            return replacements;
        }
        catch (IOException ioe) {
            throw new RuntimeException("error reading components.properties", ioe);
        }
    }

    private void installComponentsFromXmlElements(Element rootElement, Properties replacements) throws DocumentException, ClassNotFoundException {
        List importElements = rootElement.elements("import-java-package");
        for (Element importElement : importElements) {
            String pkgName = importElement.getTextTrim();
            this.importedPackages.add(pkgName);
            this.addNamespace(Package.getPackage(pkgName));
        }
        List componentElements = rootElement.elements("component");
        for (Element component : componentElements) {
            this.installComponentFromXmlElement(component, component.attributeValue("name"), component.attributeValue("class"), replacements);
        }
        List factoryElements = rootElement.elements("factory");
        for (Element factory : factoryElements) {
            this.installFactoryFromXmlElement(factory);
        }
        List elements = rootElement.elements("event");
        for (Element event : elements) {
            this.installEventListenerFromXmlElement(event);
        }
        for (Element elem : rootElement.elements()) {
            String ns = elem.getNamespace().getURI();
            NamespaceDescriptor nsInfo = this.namespaceMap.get(ns);
            if (nsInfo == null) continue;
            String name = elem.attributeValue("name");
            String elemName = Initialization.toCamelCase(elem.getName(), true);
            String className = nsInfo.getPackage().getName() + '.' + elemName;
            try {
                Install install;
                Class clazz = Reflections.classForName(className);
                Name nameAnnotation = clazz.getAnnotation(Name.class);
                if (name == null && nameAnnotation != null) {
                    name = nameAnnotation.value();
                }
                if (nameAnnotation != null && nameAnnotation.value().equals(name) && (install = clazz.getAnnotation(Install.class)).value()) {
                    className = null;
                }
            }
            catch (ClassNotFoundException cnfe) {
                className = null;
            }
            if (name == null) {
                String prefix = nsInfo.getNamespace().prefix();
                name = Strings.isEmpty(prefix) ? elemName : prefix + '.' + elemName;
            }
            this.installComponentFromXmlElement(elem, name, className, replacements);
        }
    }

    private void installEventListenerFromXmlElement(Element event) {
        String type = event.attributeValue("type");
        if (type == null) {
            throw new IllegalArgumentException("must specify type for <event/> declaration");
        }
        EventListenerDescriptor eventListener = this.eventListenerDescriptors.get(type);
        if (eventListener == null) {
            eventListener = new EventListenerDescriptor(type);
            this.eventListenerDescriptors.put(type, eventListener);
        }
        List actions = event.elements("action");
        for (Element action : actions) {
            String actionExpression = action.attributeValue("expression");
            if (actionExpression == null) {
                throw new IllegalArgumentException("must specify expression for <action/> declaration");
            }
            eventListener.getListenerMethodBindings().add(actionExpression);
        }
    }

    private void installFactoryFromXmlElement(Element factory) {
        String scopeName = factory.attributeValue("scope");
        String name = factory.attributeValue("name");
        if (name == null) {
            throw new IllegalArgumentException("must specify name in <factory/> declaration");
        }
        String method = factory.attributeValue("method");
        String value = factory.attributeValue("value");
        if (method == null && value == null) {
            throw new IllegalArgumentException("must specify either method or value in <factory/> declaration for variable: " + name);
        }
        ScopeType scope = scopeName == null ? ScopeType.UNSPECIFIED : ScopeType.valueOf(scopeName.toUpperCase());
        boolean autoCreate = "true".equals(factory.attributeValue("auto-create"));
        this.factoryDescriptors.add(new FactoryDescriptor(name, scope, method, value, autoCreate));
    }

    private String replace(String value, Properties replacements) {
        if (value.startsWith("@")) {
            value = replacements.getProperty(value.substring(1, value.length() - 1));
        }
        return value;
    }

    private void installComponentFromXmlElement(Element component, String name, String className, Properties replacements) throws ClassNotFoundException {
        String installText = component.attributeValue("installed");
        boolean installed = false;
        if (installText == null || "true".equals(this.replace(installText, replacements))) {
            installed = true;
        }
        String scopeName = component.attributeValue("scope");
        String jndiName = component.attributeValue("jndi-name");
        String precedenceString = component.attributeValue("precedence");
        int precedence = precedenceString == null ? 20 : Integer.valueOf(precedenceString);
        ScopeType scope = scopeName == null ? null : ScopeType.valueOf(scopeName.toUpperCase());
        boolean autoCreate = "true".equals(component.attributeValue("auto-create"));
        if (className != null) {
            Class clazz;
            block14: {
                clazz = null;
                try {
                    clazz = Reflections.classForName(className);
                }
                catch (ClassNotFoundException cnfe) {
                    for (String pkg : this.importedPackages) {
                        try {
                            clazz = Reflections.classForName(pkg + '.' + className);
                            break;
                        }
                        catch (Exception e) {
                        }
                    }
                    if (clazz != null) break block14;
                    throw cnfe;
                }
            }
            if (name == null) {
                if (!clazz.isAnnotationPresent(Name.class)) {
                    throw new IllegalArgumentException("Component class must have @Name annotation or name must be specified in components.xml: " + clazz.getName());
                }
                name = clazz.getAnnotation(Name.class).value();
            }
            ComponentDescriptor descriptor = new ComponentDescriptor(name, clazz, scope, autoCreate, jndiName, installed, precedence);
            this.addComponentDescriptor(descriptor);
            this.installedComponents.add(clazz);
        } else if (name == null) {
            throw new IllegalArgumentException("must specify either class or name in <component/> declaration");
        }
        for (Element prop : component.elements()) {
            String propName = prop.attributeValue("name");
            if (propName == null) {
                propName = prop.getQName().getName();
            }
            String qualifiedPropName = name + '.' + Initialization.toCamelCase(propName, false);
            this.properties.put(qualifiedPropName, this.getPropertyValue(prop, qualifiedPropName, replacements));
        }
        for (Element prop : component.attributes()) {
            String attributeName = prop.getName();
            boolean isProperty = !"name".equals(attributeName) && !"installed".equals(attributeName) && !"scope".equals(attributeName) && !"class".equals(attributeName) && !"jndi-name".equals(attributeName) && !"precedence".equals(attributeName) && !"auto-create".equals(attributeName);
            if (!isProperty) continue;
            String qualifiedPropName = name + '.' + Initialization.toCamelCase(prop.getQName().getName(), false);
            this.properties.put(qualifiedPropName, this.getPropertyValue((Attribute)prop, replacements));
        }
    }

    private void addComponentDescriptor(ComponentDescriptor descriptor) {
        String name = descriptor.getName();
        SortedSet<ComponentDescriptor> set = this.componentDescriptors.get(name);
        if (set == null) {
            set = new TreeSet<ComponentDescriptor>();
            this.componentDescriptors.put(name, set);
        }
        if (!set.isEmpty()) {
            log.info("two components with same name, higher precedence wins: " + name);
        }
        if (!set.add(descriptor)) {
            throw new IllegalStateException("Two components with the same name and precedence: " + name);
        }
    }

    private Conversions.PropertyValue getPropertyValue(Attribute prop, Properties replacements) {
        return new Conversions.FlatPropertyValue(this.trimmedText(prop, replacements));
    }

    private Conversions.PropertyValue getPropertyValue(Element prop, String propName, Properties replacements) {
        List keyElements = prop.elements("key");
        List valueElements = prop.elements("value");
        if (valueElements.isEmpty() && keyElements.isEmpty()) {
            return new Conversions.FlatPropertyValue(this.trimmedText(prop, propName, replacements));
        }
        if (keyElements.isEmpty()) {
            int len = valueElements.size();
            String[] values = new String[len];
            for (int i = 0; i < len; ++i) {
                values[i] = this.trimmedText((Element)valueElements.get(i), propName, replacements);
            }
            return new Conversions.MultiPropertyValue(values);
        }
        if (valueElements.size() != keyElements.size()) {
            throw new IllegalArgumentException("value elements must match key elements: " + propName);
        }
        HashMap<String, String> keyedValues = new HashMap<String, String>();
        for (int i = 0; i < keyElements.size(); ++i) {
            String key = this.trimmedText((Element)keyElements.get(i), propName, replacements);
            String value = this.trimmedText((Element)valueElements.get(i), propName, replacements);
            keyedValues.put(key, value);
        }
        return new Conversions.AssociativePropertyValue(keyedValues);
    }

    private String trimmedText(Element element, String propName, Properties replacements) {
        String text = element.getTextTrim();
        if (text == null) {
            throw new IllegalArgumentException("property value must be specified in element body: " + propName);
        }
        return this.replace(text, replacements);
    }

    private String trimmedText(Attribute attribute, Properties replacements) {
        return this.replace(attribute.getText(), replacements);
    }

    public Initialization setProperty(String name, Conversions.PropertyValue value) {
        this.properties.put(name, value);
        return this;
    }

    public Initialization init() {
        log.info("initializing Seam");
        this.scanForComponents();
        Lifecycle.beginInitialization(this.servletContext);
        Contexts.getApplicationContext().set("org.jboss.seam.properties", this.properties);
        this.addComponents();
        Lifecycle.endInitialization();
        log.info("done initializing Seam");
        return this;
    }

    private void scanForComponents() {
        HashSet<Package> scannedPackages = new HashSet<Package>();
        HashSet<Class<Object>> scannedClasses = new HashSet<Class<Object>>();
        scannedClasses.addAll(new ComponentScanner("seam.properties").getClasses());
        scannedClasses.addAll(new ComponentScanner("META-INF/seam.properties").getClasses());
        scannedClasses.addAll(new ComponentScanner("META-INF/components.xml").getClasses());
        for (Class clazz : scannedClasses) {
            this.installScannedClass(scannedPackages, clazz);
        }
    }

    private void installScannedClass(Set<Package> scannedPackages, Class<Object> scannedClass) {
        this.installScannedComponentAndRoles(scannedClass);
        this.installComponentsFromDescriptor(Initialization.classDescriptorFilename(scannedClass), scannedClass);
        Package pkg = scannedClass.getPackage();
        if (pkg != null && scannedPackages.add(pkg)) {
            this.installComponentsFromDescriptor(Initialization.packageDescriptorFilename(pkg), scannedClass);
        }
    }

    private static String classDescriptorFilename(Class<Object> scannedClass) {
        return scannedClass.getName().replace('.', '/') + ".component.xml";
    }

    private static String packageDescriptorFilename(Package pkg) {
        return pkg.getName().replace('.', '/') + "/components.xml";
    }

    private void installComponentsFromDescriptor(String fileName, Class clazz) {
        InputStream stream = clazz.getClassLoader().getResourceAsStream(fileName);
        if (stream != null) {
            try {
                Properties replacements = this.getReplacements();
                Element root = XML.getRootElement(stream);
                if (root.getName().equals("components")) {
                    this.installComponentsFromXmlElements(root, replacements);
                } else {
                    this.installComponentFromXmlElement(root, root.attributeValue("name"), clazz.getName(), replacements);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("error while reading " + fileName, e);
            }
        }
    }

    private void installScannedComponentAndRoles(Class<Object> scannedClass) {
        if (scannedClass.isAnnotationPresent(Name.class)) {
            this.addComponentDescriptor(new ComponentDescriptor(scannedClass));
        }
        if (scannedClass.isAnnotationPresent(Role.class)) {
            this.installRole(scannedClass, scannedClass.getAnnotation(Role.class));
        }
        if (scannedClass.isAnnotationPresent(Roles.class)) {
            Role[] roles;
            for (Role role : roles = scannedClass.getAnnotation(Roles.class).value()) {
                this.installRole(scannedClass, role);
            }
        }
    }

    private void installRole(Class<Object> scannedClass, Role role) {
        ScopeType scope = Seam.getComponentRoleScope(scannedClass, role);
        this.addComponentDescriptor(new ComponentDescriptor(role.name(), scannedClass, scope));
    }

    private void addNamespace(Package pkg) {
        Namespace ns;
        if (pkg != null && (ns = pkg.getAnnotation(Namespace.class)) != null) {
            log.info("Namespace: " + ns.value() + ", package: " + pkg.getName() + ", prefix: " + ns.prefix());
            this.namespaceMap.put(ns.value(), new NamespaceDescriptor(ns, pkg));
        }
    }

    private void addNamespaces() {
        for (Package pkg : new NamespaceScanner("META-INF/components.xml").getPackages()) {
            this.addNamespace(pkg);
        }
        for (Package pkg : new NamespaceScanner("seam.properties").getPackages()) {
            this.addNamespace(pkg);
        }
        for (Package pkg : new NamespaceScanner("META-INF/seam.properties").getPackages()) {
            this.addNamespace(pkg);
        }
    }

    private void initPropertiesFromServletContext() {
        Enumeration params = this.servletContext.getInitParameterNames();
        while (params.hasMoreElements()) {
            String name = (String)params.nextElement();
            this.properties.put(name, new Conversions.FlatPropertyValue(this.servletContext.getInitParameter(name)));
        }
    }

    private void initPropertiesFromResource() {
        Properties props = this.loadFromResource("/seam.properties");
        for (Map.Entry<Object, Object> me : props.entrySet()) {
            this.properties.put((String)me.getKey(), new Conversions.FlatPropertyValue((String)me.getValue()));
        }
    }

    private void initJndiProperties() {
        Properties jndiProperties = new Properties();
        jndiProperties.putAll((Map<?, ?>)this.loadFromResource("/jndi.properties"));
        jndiProperties.putAll((Map<?, ?>)this.loadFromResource("/seam-jndi.properties"));
        Naming.setInitialContextProperties(jndiProperties);
    }

    private Properties loadFromResource(String resource) {
        Properties props = new Properties();
        InputStream stream = Resources.getResourceAsStream(resource, this.servletContext);
        if (stream != null) {
            log.info("reading properties from: " + resource);
            try {
                props.load(stream);
            }
            catch (IOException ioe) {
                log.error("could not read " + resource, ioe);
            }
        } else {
            log.debug("not found: " + resource);
        }
        return props;
    }

    protected ComponentDescriptor findDescriptor(Class<?> componentClass) {
        for (SortedSet<ComponentDescriptor> components : this.componentDescriptors.values()) {
            for (ComponentDescriptor component : components) {
                if (!component.getComponentClass().equals(componentClass)) continue;
                return component;
            }
        }
        return null;
    }

    protected void addComponents() {
        Context context = Contexts.getApplicationContext();
        this.addComponent(new ComponentDescriptor(Init.class), context);
        Init init = (Init)Component.getInstance(Init.class, ScopeType.APPLICATION);
        ComponentDescriptor desc = this.findDescriptor(Jbpm.class);
        if (desc != null && desc.isInstalled()) {
            init.setJbpmInstalled(true);
        }
        try {
            Reflections.classForName("org.jboss.cache.aop.PojoCache");
            this.addComponentDescriptor(new ComponentDescriptor(PojoCache.class, true));
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoClassDefFoundError e) {
            log.warn("Did not install PojoCache due to NoClassDefFoundError: " + e.getMessage());
        }
        if (init.isDebug()) {
            this.addComponentDescriptor(new ComponentDescriptor(Introspector.class, true));
            this.addComponentDescriptor(new ComponentDescriptor(org.jboss.seam.debug.Contexts.class, true));
        }
        log.info("Installing components...");
        boolean installedSomething = false;
        do {
            installedSomething = false;
            block4: for (SortedSet<ComponentDescriptor> descriptors : this.componentDescriptors.values()) {
                for (ComponentDescriptor componentDescriptor : descriptors) {
                    String compName = componentDescriptor.getName() + COMPONENT_SUFFIX;
                    if (context.isSet(compName) || !this.dependenciesMet(context, componentDescriptor)) continue;
                    this.addComponent(componentDescriptor, context);
                    installedSomething = true;
                    if (componentDescriptor.isAutoCreate()) {
                        init.addAutocreateVariable(componentDescriptor.getName());
                    }
                    if (componentDescriptor.isFilter()) {
                        init.addInstalledFilter(componentDescriptor.getName());
                    }
                    if (!componentDescriptor.isResourceProvider()) continue block4;
                    init.addResourceProvider(componentDescriptor.getName());
                    continue block4;
                }
            }
        } while (installedSomething);
        for (FactoryDescriptor factoryDescriptor : this.factoryDescriptors) {
            if (factoryDescriptor.isValueBinding()) {
                init.addFactoryValueBinding(factoryDescriptor.getName(), factoryDescriptor.getValue(), factoryDescriptor.getScope());
            } else {
                init.addFactoryMethodBinding(factoryDescriptor.getName(), factoryDescriptor.getMethod(), factoryDescriptor.getScope());
            }
            if (!factoryDescriptor.isAutoCreate()) continue;
            init.addAutocreateVariable(factoryDescriptor.getName());
        }
        for (EventListenerDescriptor listenerDescriptor : this.eventListenerDescriptors.values()) {
            for (String expression : listenerDescriptor.getListenerMethodBindings()) {
                init.addObserverMethodBinding(listenerDescriptor.getType(), Expressions.instance().createMethodBinding(expression));
            }
        }
    }

    protected boolean dependenciesMet(Context context, ComponentDescriptor descriptor) {
        String[] classDependencies;
        Class[] genericDependencies;
        if (!descriptor.isInstalled()) {
            return false;
        }
        String[] dependencies = descriptor.getDependencies();
        if (dependencies != null) {
            for (String dependency : dependencies) {
                if (context.isSet(dependency + COMPONENT_SUFFIX)) continue;
                return false;
            }
        }
        if ((genericDependencies = descriptor.getGenericDependencies()) != null) {
            for (Class genericDependency : genericDependencies) {
                if (this.installedComponents.contains(genericDependency)) continue;
                return false;
            }
        }
        if ((classDependencies = descriptor.getClassDependencies()) != null) {
            for (String className : classDependencies) {
                try {
                    descriptor.getComponentClass().getClassLoader().loadClass(className);
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return true;
    }

    protected void addComponent(ComponentDescriptor descriptor, Context context) {
        String name = descriptor.getName();
        String componentName = name + COMPONENT_SUFFIX;
        try {
            Component component = new Component(descriptor.getComponentClass(), name, descriptor.getScope(), descriptor.getJndiName());
            context.set(componentName, component);
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not create Component: " + name, e);
        }
    }

    private static String toCamelCase(String hyphenated, boolean initialUpper) {
        StringTokenizer tokens = new StringTokenizer(hyphenated, "-");
        StringBuilder result = new StringBuilder(hyphenated.length());
        String firstToken = tokens.nextToken();
        if (initialUpper) {
            result.append(Character.toUpperCase(firstToken.charAt(0))).append(firstToken.substring(1));
        } else {
            result.append(firstToken);
        }
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            result.append(Character.toUpperCase(token.charAt(0))).append(token.substring(1));
        }
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComponentDescriptor
    implements Comparable<ComponentDescriptor> {
        private String name;
        private Class<?> componentClass;
        private ScopeType scope;
        private String jndiName;
        private Boolean installed;
        private boolean autoCreate;
        private Integer precedence;

        ComponentDescriptor(String name, Class<?> componentClass, ScopeType scope, boolean autoCreate, String jndiName, Boolean installed, Integer precedence) {
            this.name = name;
            this.componentClass = componentClass;
            this.scope = scope;
            this.jndiName = jndiName;
            this.installed = installed;
            this.autoCreate = autoCreate;
            this.precedence = precedence;
        }

        public ComponentDescriptor(String name, Class<?> componentClass, ScopeType scope) {
            this.name = name;
            this.componentClass = componentClass;
            this.scope = scope;
        }

        public ComponentDescriptor(Class componentClass) {
            this.componentClass = componentClass;
        }

        public ComponentDescriptor(Class componentClass, Boolean installed) {
            this.componentClass = componentClass;
            this.installed = installed;
        }

        public String getName() {
            return this.name == null ? Seam.getComponentName(this.componentClass) : this.name;
        }

        public ScopeType getScope() {
            return this.scope == null ? Seam.getComponentScope(this.componentClass) : this.scope;
        }

        public Class getComponentClass() {
            return this.componentClass;
        }

        public String getJndiName() {
            return this.jndiName;
        }

        public boolean isAutoCreate() {
            return this.autoCreate || this.componentClass.isAnnotationPresent(AutoCreate.class);
        }

        public String[] getDependencies() {
            Install install = this.componentClass.getAnnotation(Install.class);
            if (install == null) {
                return null;
            }
            return install.dependencies();
        }

        public Class[] getGenericDependencies() {
            Install install = this.componentClass.getAnnotation(Install.class);
            if (install == null) {
                return null;
            }
            return install.genericDependencies();
        }

        public String[] getClassDependencies() {
            Install install = this.componentClass.getAnnotation(Install.class);
            if (install == null) {
                return null;
            }
            return install.classDependencies();
        }

        public boolean isInstalled() {
            if (this.installed != null) {
                return this.installed;
            }
            Install install = this.componentClass.getAnnotation(Install.class);
            if (install == null) {
                return true;
            }
            return install.value();
        }

        public int getPrecedence() {
            if (this.precedence != null) {
                return this.precedence;
            }
            Install install = this.componentClass.getAnnotation(Install.class);
            if (install == null) {
                return 20;
            }
            return install.precedence();
        }

        @Override
        public int compareTo(ComponentDescriptor other) {
            return other.getPrecedence() - this.getPrecedence();
        }

        public boolean equals(Object other) {
            return this.getPrecedence() == ((ComponentDescriptor)other).getPrecedence();
        }

        public int hashCode() {
            return this.getPrecedence();
        }

        public boolean isFilter() {
            return Filter.class.isAssignableFrom(this.componentClass);
        }

        public boolean isResourceProvider() {
            return AbstractResource.class.isAssignableFrom(this.componentClass);
        }

        public String toString() {
            return "ComponentDescriptor(" + this.getName() + ')';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EventListenerDescriptor {
        private String type;
        private List<String> listenerMethodBindings = new ArrayList<String>();

        EventListenerDescriptor(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public List<String> getListenerMethodBindings() {
            return this.listenerMethodBindings;
        }

        public String toString() {
            return "EventListenerDescriptor(" + this.type + ')';
        }
    }

    private static class NamespaceDescriptor {
        private Namespace namespace;
        private Package pkg;

        NamespaceDescriptor(Namespace namespace, Package pkg) {
            this.namespace = namespace;
            this.pkg = pkg;
        }

        public Namespace getNamespace() {
            return this.namespace;
        }

        public Package getPackage() {
            return this.pkg;
        }

        public String toString() {
            return "EventListenerDescriptor(" + this.namespace + ')';
        }
    }

    private static class FactoryDescriptor {
        private String name;
        private ScopeType scope;
        private String method;
        private String value;
        private boolean autoCreate;

        FactoryDescriptor(String name, ScopeType scope, String method, String value, boolean autoCreate) {
            this.name = name;
            this.scope = scope;
            this.method = method;
            this.value = value;
            this.autoCreate = autoCreate;
        }

        public String getMethod() {
            return this.method;
        }

        public String getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public ScopeType getScope() {
            return this.scope;
        }

        public boolean isValueBinding() {
            return this.method == null;
        }

        public boolean isAutoCreate() {
            return this.autoCreate;
        }

        public String toString() {
            return "FactoryDescriptor(" + this.name + ')';
        }
    }
}

