/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.stylesheet;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.custom.stylesheet.Stylesheet;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;

public class StylesheetRenderer
extends HtmlRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        Stylesheet stylesheet = (Stylesheet)component;
        ResponseWriter writer = context.getResponseWriter();
        if (stylesheet.isInline()) {
            Object text;
            writer.startElement("style", component);
            writer.writeAttribute("type", (Object)"text/css", null);
            if (stylesheet.getMedia() != null) {
                writer.writeAttribute("media", (Object)stylesheet.getMedia(), null);
            }
            if ((text = RendererUtils.loadResourceFile(context, stylesheet.getPath())) != null) {
                writer.writeText(text, null);
            }
            writer.endElement("style");
        } else {
            writer.startElement("link", component);
            writer.writeAttribute("rel", (Object)"stylesheet", null);
            writer.writeAttribute("type", (Object)"text/css", null);
            if (stylesheet.getMedia() != null) {
                writer.writeAttribute("media", (Object)stylesheet.getMedia(), null);
            }
            writer.writeURIAttribute("href", (Object)context.getApplication().getViewHandler().getResourceURL(context, stylesheet.getPath()), "path");
            writer.endElement("link");
        }
    }
}

