/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.tabbedpane;

import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UINamingContainer;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import org.apache.myfaces.custom.tabbedpane.TabChangeEvent;
import org.apache.myfaces.custom.tabbedpane.TabChangeListener;
import org.apache.myfaces.shared_tomahawk.util._ComponentUtils;

public class HtmlPanelTabbedPane
extends HtmlPanelGroup {
    private MethodBinding _tabChangeListener = null;
    public static final String COMPONENT_TYPE = "org.apache.myfaces.HtmlPanelTabbedPane";
    public static final String COMPONENT_FAMILY = "javax.faces.Panel";
    private static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.TabbedPane";
    private static final int DEFAULT_SELECTEDINDEX = 0;
    private static final boolean DEFAULT_SERVER_SIDE_TAB_SWITCH = false;
    private Integer _selectedIndex = null;
    private String _bgcolor = null;
    private String _activeTabStyleClass = null;
    private String _inactiveTabStyleClass = null;
    private String _disabledTabStyleClass = null;
    private String _activeSubStyleClass = null;
    private String _inactiveSubStyleClass = null;
    private String _tabContentStyleClass = null;
    private Boolean _serverSideTabSwitch = null;
    private String _activePanelTabVar;

    public void decode(FacesContext context) {
        super.decode(context);
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.decode(context);
        Iterator it = this.getFacetsAndChildren();
        while (it.hasNext()) {
            UIComponent childOrFacet = this.getUIComponent((UIComponent)it.next());
            childOrFacet.processDecodes(context);
        }
    }

    private UIComponent getUIComponent(UIComponent uiComponent) {
        if (uiComponent instanceof UINamingContainer || uiComponent instanceof UIForm) {
            List children = uiComponent.getChildren();
            int len = children.size();
            for (int i = 0; i < len; ++i) {
                uiComponent = this.getUIComponent((UIComponent)children.get(i));
            }
        }
        return uiComponent;
    }

    public void addTabChangeListener(TabChangeListener listener) {
        this.addFacesListener(listener);
    }

    public void removeTabChangeListener(TabChangeListener listener) {
        this.removeFacesListener(listener);
    }

    public MethodBinding getTabChangeListener() {
        return this._tabChangeListener;
    }

    public void setTabChangeListener(MethodBinding tabChangeListener) {
        this._tabChangeListener = tabChangeListener;
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        TabChangeEvent tabChangeEvent;
        if (event instanceof TabChangeEvent && (tabChangeEvent = (TabChangeEvent)event).getComponent() == this) {
            this.setSelectedIndex(tabChangeEvent.getNewTabIndex());
            this.getFacesContext().renderResponse();
        }
        super.broadcast(event);
        MethodBinding tabChangeListenerBinding = this.getTabChangeListener();
        if (tabChangeListenerBinding != null) {
            try {
                tabChangeListenerBinding.invoke(this.getFacesContext(), new Object[]{event});
            }
            catch (EvaluationException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof AbortProcessingException) {
                    throw (AbortProcessingException)cause;
                }
                throw e;
            }
        }
    }

    public boolean isClientSide() {
        return !this.getServerSideTabSwitch();
    }

    public HtmlPanelTabbedPane() {
        this.setRendererType(DEFAULT_RENDERER_TYPE);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getActiveTabVar() {
        if (this._activePanelTabVar != null) {
            return this._activePanelTabVar;
        }
        ValueBinding vb = this.getValueBinding("activeTabVar");
        return vb != null ? _ComponentUtils.getStringValue(this.getFacesContext(), vb) : null;
    }

    public void setActiveTabVar(String activeTabVar) {
        this._activePanelTabVar = activeTabVar;
    }

    public void setSelectedIndex(int selectedIndex) {
        this._selectedIndex = new Integer(selectedIndex);
    }

    public int getSelectedIndex() {
        if (this._selectedIndex != null) {
            return this._selectedIndex;
        }
        ValueBinding vb = this.getValueBinding("selectedIndex");
        Number v = vb != null ? (Number)((Number)vb.getValue(this.getFacesContext())) : (Number)null;
        return v != null ? v.intValue() : 0;
    }

    public void setBgcolor(String bgcolor) {
        this._bgcolor = bgcolor;
    }

    public String getBgcolor() {
        if (this._bgcolor != null) {
            return this._bgcolor;
        }
        ValueBinding vb = this.getValueBinding("bgcolor");
        return vb != null ? _ComponentUtils.getStringValue(this.getFacesContext(), vb) : null;
    }

    public void setActiveTabStyleClass(String activeTabStyleClass) {
        this._activeTabStyleClass = activeTabStyleClass;
    }

    public String getActiveTabStyleClass() {
        if (this._activeTabStyleClass != null) {
            return this._activeTabStyleClass;
        }
        ValueBinding vb = this.getValueBinding("activeTabStyleClass");
        return vb != null ? _ComponentUtils.getStringValue(this.getFacesContext(), vb) : null;
    }

    public void setInactiveTabStyleClass(String inactiveTabStyleClass) {
        this._inactiveTabStyleClass = inactiveTabStyleClass;
    }

    public String getInactiveTabStyleClass() {
        if (this._inactiveTabStyleClass != null) {
            return this._inactiveTabStyleClass;
        }
        ValueBinding vb = this.getValueBinding("inactiveTabStyleClass");
        return vb != null ? _ComponentUtils.getStringValue(this.getFacesContext(), vb) : null;
    }

    public void setActiveSubStyleClass(String activeSubStyleClass) {
        this._activeSubStyleClass = activeSubStyleClass;
    }

    public String getActiveSubStyleClass() {
        if (this._activeSubStyleClass != null) {
            return this._activeSubStyleClass;
        }
        ValueBinding vb = this.getValueBinding("activeSubStyleClass");
        return vb != null ? _ComponentUtils.getStringValue(this.getFacesContext(), vb) : null;
    }

    public void setInactiveSubStyleClass(String inactiveSubStyleClass) {
        this._inactiveSubStyleClass = inactiveSubStyleClass;
    }

    public String getInactiveSubStyleClass() {
        if (this._inactiveSubStyleClass != null) {
            return this._inactiveSubStyleClass;
        }
        ValueBinding vb = this.getValueBinding("inactiveSubStyleClass");
        return vb != null ? _ComponentUtils.getStringValue(this.getFacesContext(), vb) : null;
    }

    public void setTabContentStyleClass(String tabContentStyleClass) {
        this._tabContentStyleClass = tabContentStyleClass;
    }

    public String getTabContentStyleClass() {
        if (this._tabContentStyleClass != null) {
            return this._tabContentStyleClass;
        }
        ValueBinding vb = this.getValueBinding("tabContentStyleClass");
        return vb != null ? _ComponentUtils.getStringValue(this.getFacesContext(), vb) : null;
    }

    public String getDisabledTabStyleClass() {
        return this._disabledTabStyleClass;
    }

    public void setDisabledTabStyleClass(String disabledTabStyleClass) {
        this._disabledTabStyleClass = disabledTabStyleClass;
    }

    public boolean getServerSideTabSwitch() {
        if (this._serverSideTabSwitch != null) {
            return this._serverSideTabSwitch;
        }
        ValueBinding vb = this.getValueBinding("serverSideTabSwitch");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : false;
    }

    public void setServerSideTabSwitch(boolean serverSideTabSwitch) {
        this._serverSideTabSwitch = new Boolean(serverSideTabSwitch);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._selectedIndex, this._bgcolor, HtmlPanelTabbedPane.saveAttachedState((FacesContext)context, (Object)this._tabChangeListener), this._activeTabStyleClass, this._inactiveTabStyleClass, this._activeSubStyleClass, this._inactiveSubStyleClass, this._tabContentStyleClass, this._disabledTabStyleClass, this._serverSideTabSwitch, this._activePanelTabVar};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._selectedIndex = (Integer)values[1];
        this._bgcolor = (String)values[2];
        this._tabChangeListener = (MethodBinding)HtmlPanelTabbedPane.restoreAttachedState((FacesContext)context, (Object)values[3]);
        this._activeTabStyleClass = (String)values[4];
        this._inactiveTabStyleClass = (String)values[5];
        this._activeSubStyleClass = (String)values[6];
        this._inactiveSubStyleClass = (String)values[7];
        this._tabContentStyleClass = (String)values[8];
        this._disabledTabStyleClass = (String)values[9];
        this._serverSideTabSwitch = (Boolean)values[10];
        this._activePanelTabVar = (String)values[11];
    }
}

