/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.tree2;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.custom.tree2.ToggleExpandedEvent;
import org.apache.myfaces.custom.tree2.Tree;
import org.apache.myfaces.custom.tree2.TreeModel;
import org.apache.myfaces.custom.tree2.TreeModelBase;
import org.apache.myfaces.custom.tree2.TreeNode;
import org.apache.myfaces.custom.tree2.TreeState;
import org.apache.myfaces.custom.tree2.TreeStateBase;
import org.apache.myfaces.custom.tree2.TreeWalker;
import org.apache.myfaces.shared_tomahawk.util.MessageUtils;

public class UITreeData
extends UIComponentBase
implements NamingContainer,
Tree {
    private Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$custom$tree2$UITreeData == null ? (class$org$apache$myfaces$custom$tree2$UITreeData = UITreeData.class$("org.apache.myfaces.custom.tree2.UITreeData")) : class$org$apache$myfaces$custom$tree2$UITreeData));
    public static final String COMPONENT_TYPE = "org.apache.myfaces.Tree2";
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.HtmlTree2";
    private static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.Tree2";
    private static final String MISSING_NODE = "org.apache.myfaces.tree2.MISSING_NODE";
    private static final int PROCESS_DECODES = 1;
    private static final int PROCESS_VALIDATORS = 2;
    private static final int PROCESS_UPDATES = 3;
    private TreeModel _cachedModel;
    private String _nodeId;
    private TreeNode _node;
    private Object _value;
    private String _var;
    private Map _saved = new HashMap();
    private TreeState _restoredState = null;
    static /* synthetic */ Class class$org$apache$myfaces$custom$tree2$UITreeData;

    public UITreeData() {
        this.setRendererType("org.apache.myfaces.Tree2");
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._var, this._restoredState};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._var = (String)values[1];
        this._restoredState = (TreeState)values[2];
    }

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
        TreeState state = this.getDataModel().getTreeState();
        if (state == null) {
            state = new TreeStateBase();
        }
        this._restoredState = state.isTransient() ? null : state;
    }

    public void queueEvent(FacesEvent event) {
        super.queueEvent((FacesEvent)new FacesEventWrapper(event, this.getNodeId(), (UIComponent)this));
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof FacesEventWrapper) {
            FacesEventWrapper childEvent = (FacesEventWrapper)event;
            String currNodeId = this.getNodeId();
            this.setNodeId(childEvent.getNodeId());
            FacesEvent nodeEvent = childEvent.getFacesEvent();
            nodeEvent.getComponent().broadcast(nodeEvent);
            this.setNodeId(currNodeId);
            return;
        }
        if (!(event instanceof ToggleExpandedEvent)) {
            super.broadcast(event);
            return;
        }
        ToggleExpandedEvent toggleEvent = (ToggleExpandedEvent)event;
        String currentNodeId = this.getNodeId();
        this.setNodeId(toggleEvent.getNodeId());
        this.toggleExpanded();
        this.setNodeId(currentNodeId);
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        this._cachedModel = null;
        this._saved = new HashMap();
        this.setNodeId(null);
        this.decode(context);
        this.processNodes(context, 1);
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        this.processNodes(context, 2);
        this.setNodeId(null);
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        this.processNodes(context, 3);
        this.setNodeId(null);
    }

    public String getClientId(FacesContext context) {
        String ownClientId = super.getClientId(context);
        if (this._nodeId != null) {
            return ownClientId + ':' + this._nodeId;
        }
        return ownClientId;
    }

    public void setValueBinding(String name, ValueBinding binding) {
        if ("value".equals(name)) {
            this._cachedModel = null;
        } else if ("nodeVar".equals(name) || "nodeId".equals(name) || "treeVar".equals(name)) {
            throw new IllegalArgumentException("name " + name);
        }
        super.setValueBinding(name, binding);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.keepSaved(context)) {
            this._saved = new HashMap();
        }
        this._cachedModel = null;
        super.encodeBegin(context);
    }

    public void setValue(Object value) {
        this._cachedModel = null;
        this._value = value;
    }

    public Object getModel() {
        return this.getValue();
    }

    public void setModel(Object model) {
        this.setValue(model);
    }

    public Object getValue() {
        if (this._value != null) {
            return this._value;
        }
        ValueBinding vb = this.getValueBinding("value");
        return vb != null ? vb.getValue(this.getFacesContext()) : null;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public String getVar() {
        return this._var;
    }

    public TreeNode getNode() {
        return this._node;
    }

    public String getNodeId() {
        return this._nodeId;
    }

    public void setNodeId(String nodeId) {
        this.saveDescendantState();
        this._nodeId = nodeId;
        TreeModel model = this.getDataModel();
        if (model == null) {
            return;
        }
        try {
            this._node = model.getNodeById(nodeId);
        }
        catch (IndexOutOfBoundsException aob) {
            FacesMessage message = MessageUtils.getMessage(MISSING_NODE, new String[]{nodeId});
            message.setSeverity(FacesMessage.SEVERITY_WARN);
            FacesContext.getCurrentInstance().addMessage(this.getId(), message);
        }
        this.restoreDescendantState();
        if (this._var != null) {
            Map requestMap = this.getFacesContext().getExternalContext().getRequestMap();
            if (nodeId == null) {
                requestMap.remove(this._var);
            } else {
                requestMap.put(this._var, this.getNode());
            }
        }
    }

    public String[] getPathInformation(String nodeId) {
        return this.getDataModel().getPathInformation(nodeId);
    }

    public boolean isLastChild(String nodeId) {
        return this.getDataModel().isLastChild(nodeId);
    }

    public TreeModel getDataModel() {
        if (this._cachedModel != null) {
            return this._cachedModel;
        }
        Object value = this.getValue();
        if (value != null) {
            if (value instanceof TreeModel) {
                this._cachedModel = (TreeModel)value;
            } else if (value instanceof TreeNode) {
                this._cachedModel = new TreeModelBase((TreeNode)value);
            } else {
                throw new IllegalArgumentException("Value must be a TreeModel or TreeNode");
            }
        }
        if (this._restoredState != null) {
            this._cachedModel.setTreeState(this._restoredState);
        }
        return this._cachedModel;
    }

    public void expandAll() {
        this.toggleAll(true);
    }

    public void collapseAll() {
        this.toggleAll(false);
    }

    private void toggleAll(boolean expanded) {
        TreeWalker walker = this.getDataModel().getTreeWalker();
        walker.reset();
        TreeState state = this.getDataModel().getTreeState();
        walker.setCheckState(false);
        walker.setTree(this);
        while (walker.next()) {
            String id = this.getNodeId();
            if ((!expanded || state.isNodeExpanded(id)) && (expanded || !state.isNodeExpanded(id))) continue;
            state.toggleExpanded(id);
        }
    }

    public void expandPath(String[] nodePath) {
        this.getDataModel().getTreeState().expandPath(nodePath);
    }

    public void collapsePath(String[] nodePath) {
        this.getDataModel().getTreeState().collapsePath(nodePath);
    }

    protected void processNodes(FacesContext context, int processAction) {
        UIComponent facet = null;
        TreeWalker walker = this.getDataModel().getTreeWalker();
        walker.reset();
        walker.setTree(this);
        while (walker.next()) {
            TreeNode node = this.getNode();
            facet = this.getFacet(node.getType());
            if (facet == null) {
                this.log.warn((Object)("Unable to locate facet with the name: " + node.getType()));
                continue;
            }
            switch (processAction) {
                case 1: {
                    facet.processDecodes(context);
                    break;
                }
                case 2: {
                    facet.processValidators(context);
                    break;
                }
                case 3: {
                    facet.processUpdates(context);
                }
            }
        }
    }

    private void saveDescendantState() {
        FacesContext context = this.getFacesContext();
        Iterator i = this.getFacets().values().iterator();
        while (i.hasNext()) {
            UIComponent facet = (UIComponent)i.next();
            this.saveDescendantState(facet, context);
        }
    }

    private void saveDescendantState(UIComponent component, FacesContext context) {
        if (component instanceof EditableValueHolder) {
            EditableValueHolder input = (EditableValueHolder)component;
            String clientId = component.getClientId(context);
            SavedState state = (SavedState)this._saved.get(clientId);
            if (state == null) {
                state = new SavedState();
                this._saved.put(clientId, state);
            }
            state.setValue(input.getLocalValue());
            state.setValid(input.isValid());
            state.setSubmittedValue(input.getSubmittedValue());
            state.setLocalValueSet(input.isLocalValueSet());
        }
        List kids = component.getChildren();
        for (int i = 0; i < kids.size(); ++i) {
            this.saveDescendantState((UIComponent)kids.get(i), context);
        }
    }

    private void restoreDescendantState() {
        FacesContext context = this.getFacesContext();
        Iterator i = this.getFacets().values().iterator();
        while (i.hasNext()) {
            UIComponent facet = (UIComponent)i.next();
            this.restoreDescendantState(facet, context);
        }
    }

    private void restoreDescendantState(UIComponent component, FacesContext context) {
        String id = component.getId();
        component.setId(id);
        if (component instanceof EditableValueHolder) {
            EditableValueHolder input = (EditableValueHolder)component;
            String clientId = component.getClientId(context);
            SavedState state = (SavedState)this._saved.get(clientId);
            if (state == null) {
                state = new SavedState();
            }
            input.setValue(state.getValue());
            input.setValid(state.isValid());
            input.setSubmittedValue(state.getSubmittedValue());
            input.setLocalValueSet(state.isLocalValueSet());
        }
        List kids = component.getChildren();
        for (int i = 0; i < kids.size(); ++i) {
            this.restoreDescendantState((UIComponent)kids.get(i), context);
        }
        Map facets = component.getFacets();
        Iterator i = facets.values().iterator();
        while (i.hasNext()) {
            this.restoreDescendantState((UIComponent)i.next(), context);
        }
    }

    private boolean keepSaved(FacesContext context) {
        Iterator clientIds = this._saved.keySet().iterator();
        while (clientIds.hasNext()) {
            String clientId = (String)clientIds.next();
            Iterator messages = context.getMessages(clientId);
            while (messages.hasNext()) {
                FacesMessage message = (FacesMessage)messages.next();
                if (message.getSeverity().compareTo((Object)FacesMessage.SEVERITY_ERROR) < 0) continue;
                return true;
            }
        }
        return false;
    }

    public void toggleExpanded() {
        this.getDataModel().getTreeState().toggleExpanded(this.getNodeId());
    }

    public boolean isNodeExpanded() {
        return this.getDataModel().getTreeState().isNodeExpanded(this.getNodeId());
    }

    public void setNodeSelected(ActionEvent event) {
        this.getDataModel().getTreeState().setSelected(this.getNodeId());
    }

    public boolean isNodeSelected() {
        return this.getNodeId() != null ? this.getDataModel().getTreeState().isSelected(this.getNodeId()) : false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class FacesEventWrapper
    extends FacesEvent {
        private static final long serialVersionUID = -3056153249469828447L;
        private FacesEvent _wrappedFacesEvent;
        private String _nodeId;

        public FacesEventWrapper(FacesEvent facesEvent, String nodeId, UIComponent component) {
            super(component);
            this._wrappedFacesEvent = facesEvent;
            this._nodeId = nodeId;
        }

        public PhaseId getPhaseId() {
            return this._wrappedFacesEvent.getPhaseId();
        }

        public void setPhaseId(PhaseId phaseId) {
            this._wrappedFacesEvent.setPhaseId(phaseId);
        }

        public void queue() {
            this._wrappedFacesEvent.queue();
        }

        public String toString() {
            return this._wrappedFacesEvent.toString();
        }

        public boolean isAppropriateListener(FacesListener faceslistener) {
            return false;
        }

        public void processListener(FacesListener faceslistener) {
            throw new UnsupportedOperationException("This event type is only intended for wrapping a real event");
        }

        public FacesEvent getFacesEvent() {
            return this._wrappedFacesEvent;
        }

        public String getNodeId() {
            return this._nodeId;
        }
    }

    private static class SavedState
    implements Serializable {
        private static final long serialVersionUID = 273343276957070557L;
        private Object submittedValue;
        private boolean valid = true;
        private Object value;
        private boolean localValueSet;

        private SavedState() {
        }

        Object getSubmittedValue() {
            return this.submittedValue;
        }

        void setSubmittedValue(Object submittedValue) {
            this.submittedValue = submittedValue;
        }

        boolean isValid() {
            return this.valid;
        }

        void setValid(boolean valid) {
            this.valid = valid;
        }

        Object getValue() {
            return this.value;
        }

        void setValue(Object value) {
            this.value = value;
        }

        boolean isLocalValueSet() {
            return this.localValueSet;
        }

        void setLocalValueSet(boolean localValueSet) {
            this.localValueSet = localValueSet;
        }
    }
}

