/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ioc.spring;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.servlet.ServletContext;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.EL;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.ioc.spring.springELResolver")
@Install(precedence=10, classDependencies={"org.springframework.beans.factory.BeanFactory"})
@Startup
@Intercept(value=InterceptionType.NEVER)
public class SpringELResolver
extends ELResolver {
    private static final LogProvider log = Logging.getLogProvider(SpringELResolver.class);

    @Create
    public void initialize() {
        ELResolver resolver = EL.EL_CONTEXT.getELResolver();
        if (resolver == null || !(resolver instanceof CompositeELResolver)) {
            throw new IllegalStateException("Could not add Spring ELResolver to Resolver Chain.  Seam resolver was not an instance of CompositeELResolver.");
        }
        ((CompositeELResolver)resolver).add((ELResolver)this);
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        return null;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        if (base != null) {
            return null;
        }
        ServletContext servletContext = Lifecycle.getServletContext();
        if (servletContext == null) {
            log.debug((Object)"Could not locate seam stored servletContext.  Skipping.");
            return null;
        }
        BeanFactory bf = this.getBeanFactory(servletContext);
        if (bf == null) {
            log.debug((Object)"No Spring BeanFactory found.  Skipping.");
            return null;
        }
        if (!(property instanceof String)) {
            log.debug((Object)"Property not a string.  Skipping");
            return null;
        }
        if (bf.containsBean((String)property)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successfully resolved property '" + property + "' in root WebApplicationContext"));
            }
            context.setPropertyResolved(true);
            return bf.getBean((String)property);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Could not resolve property of name '" + property + "'"));
        }
        return null;
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        return true;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
    }

    protected BeanFactory getBeanFactory(ServletContext servletContext) {
        return WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
    }
}

