/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.resource;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.ajax4jsf.framework.resource.InternetResource;
import org.ajax4jsf.framework.resource.InternetResourceBuilder;
import org.ajax4jsf.framework.resource.JarResource;
import org.ajax4jsf.framework.resource.PrototypeScript;
import org.ajax4jsf.framework.resource.ResourceContext;
import org.ajax4jsf.framework.resource.ResourceNotFoundException;
import org.ajax4jsf.framework.resource.ScriptRenderer;
import org.ajax4jsf.framework.util.message.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ClientScript
extends JarResource {
    private static final Log log = LogFactory.getLog((Class)ClientScript.class);
    protected boolean usePrototype = false;

    public ClientScript() {
        this.setRenderer(new ScriptRenderer());
        InternetResourceBuilder resourceBuilder = InternetResourceBuilder.getInstance();
        String key = this.getClass().getName();
        try {
            InternetResource resource = resourceBuilder.getResource(key);
            this.setKey(resource.getKey());
        }
        catch (ResourceNotFoundException ex) {
            this.setLastModified(new Date(resourceBuilder.getStartTime()));
            resourceBuilder.addResource(key, this);
        }
        String script = this.getJavaScript().startsWith("/") ? this.getJavaScript().substring(1) : this.getClass().getPackage().getName().replace('.', '/') + "/" + this.getJavaScript();
        this.setPath(script);
    }

    public Date getLastModified(ResourceContext resourceContext) {
        if (this.isCacheable(null)) {
            return super.getLastModified(resourceContext);
        }
        return new Date(System.currentTimeMillis() + 1000L);
    }

    public boolean isCacheable(ResourceContext resourceContext) {
        return true;
    }

    public abstract String getJavaScript();

    public void encode(FacesContext context, Object data, Map attributes) throws IOException {
        if (this.isNotAjaxRequest(context)) {
            this.encodePrototype(context);
            super.encode(context, data, attributes);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage(Messages.SKIP_ENCODING_HTML_INFO, this.getKey()));
        }
    }

    public void encodeBegin(FacesContext context, Object component, Map attrs) throws IOException {
        if (this.isNotAjaxRequest(context)) {
            this.encodePrototype(context);
            super.encodeBegin(context, component, attrs);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage(Messages.SKIP_ENCODE_BEGIN_HTML_INFO, this.getKey()));
        }
    }

    public void encodeEnd(FacesContext context, Object component) throws IOException {
        if (this.isNotAjaxRequest(context)) {
            super.encodeEnd(context, component);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage(Messages.SKIP_ENCODE_END_HTML_INFO, this.getKey()));
        }
    }

    public void encode(FacesContext context, Object data) throws IOException {
        if (this.isNotAjaxRequest(context)) {
            this.encodePrototype(context);
            super.encode(context, data);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage(Messages.SKIP_ENCODING_HTML_INFO, this.getKey()));
        }
    }

    protected boolean isUsePrototype() {
        return this.usePrototype;
    }

    private boolean isNotAjaxRequest(FacesContext context) {
        return true;
    }

    private void encodePrototype(FacesContext context) throws IOException {
        if (this.isUsePrototype()) {
            InternetResourceBuilder.getInstance().createResource(null, PrototypeScript.class.getName()).encode(context, null);
        }
    }

    public void setUsePrototype(boolean usePrototype) {
        this.usePrototype = usePrototype;
    }
}

