/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.persistence.Id;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import org.jboss.seam.Model;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entity
extends Model {
    private Method preRemoveMethod;
    private Method prePersistMethod;
    private Method preUpdateMethod;
    private Method postLoadMethod;
    private Method identifierGetter;
    private Field identifierField;

    public Entity(Class<?> beanClass) {
        super(beanClass);
        for (Class<?> clazz = beanClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Method method : this.getBeanClass().getDeclaredMethods()) {
                if (method.isAnnotationPresent(PreRemove.class)) {
                    this.preRemoveMethod = method;
                }
                if (method.isAnnotationPresent(PrePersist.class)) {
                    this.prePersistMethod = method;
                }
                if (method.isAnnotationPresent(PreUpdate.class)) {
                    this.preUpdateMethod = method;
                }
                if (method.isAnnotationPresent(PostLoad.class)) {
                    this.postLoadMethod = method;
                }
                if (!method.isAnnotationPresent(Id.class)) continue;
                this.identifierGetter = method;
            }
            if (this.identifierGetter != null) continue;
            for (AccessibleObject accessibleObject : this.getBeanClass().getDeclaredFields()) {
                if (!accessibleObject.isAnnotationPresent(Id.class)) continue;
                this.identifierField = accessibleObject;
            }
        }
    }

    public Method getPostLoadMethod() {
        return this.postLoadMethod;
    }

    public Method getPrePersistMethod() {
        return this.prePersistMethod;
    }

    public Method getPreRemoveMethod() {
        return this.preRemoveMethod;
    }

    public Method getPreUpdateMethod() {
        return this.preUpdateMethod;
    }

    public Field getIdentifierField() {
        return this.identifierField;
    }

    public Method getIdentifierGetter() {
        return this.identifierGetter;
    }

    public Object getIdentifier(Object entity) {
        if (this.identifierGetter != null) {
            return Reflections.invokeAndWrap((Method)this.identifierGetter, (Object)entity, (Object[])new Object[0]);
        }
        if (this.identifierField != null) {
            return Reflections.getAndWrap((Field)this.identifierField, (Object)entity);
        }
        throw new IllegalStateException("@Id attribute not found for entity class: " + this.getBeanClass().getName());
    }

    public static Entity forClass(Class clazz) {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No application context active");
        }
        String name = Entity.getModelName(clazz);
        Model model = (Model)Contexts.getApplicationContext().get(name);
        if (model == null || !(model instanceof Entity)) {
            Entity entity = new Entity(clazz);
            Contexts.getApplicationContext().set(name, (Object)model);
            return entity;
        }
        return (Entity)model;
    }
}

