/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.deployment;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javassist.bytecode.ClassFile;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.deployment.Scanner;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentScanner
extends Scanner {
    private static final LogProvider log = Logging.getLogProvider(ComponentScanner.class);
    private Set<Class<Object>> classes;

    public ComponentScanner(String resourceName) {
        super(resourceName);
    }

    public ComponentScanner(String resourceName, ClassLoader classLoader) {
        super(resourceName, classLoader);
    }

    public Set<Class<Object>> getClasses() {
        if (this.classes == null) {
            this.classes = new HashSet<Class<Object>>();
            this.scan();
        }
        return this.classes;
    }

    @Override
    protected void handleItem(String name) {
        if (name.endsWith(".class")) {
            String classname = ComponentScanner.filenameToClassname(name);
            String filename = Scanner.componentFilename(name);
            try {
                boolean installable;
                ClassFile classFile = this.getClassFile(name);
                boolean bl = installable = (this.hasAnnotation(classFile, Name.class) || this.classLoader.getResources(filename).hasMoreElements()) && !"false".equals(this.getAnnotationValue(classFile, Install.class, "value"));
                if (installable) {
                    log.debug("found component class: " + name);
                    this.classes.add(this.classLoader.loadClass(classname));
                }
            }
            catch (ClassNotFoundException cnfe) {
                log.debug("could not load class: " + classname, cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                log.debug("could not load class (missing dependency): " + classname, ncdfe);
            }
            catch (IOException ioe) {
                log.debug("could not load classfile: " + classname, ioe);
            }
        }
    }
}

