/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence;

import javax.persistence.EntityManager;
import org.jboss.seam.Component;
import org.jboss.seam.Entity;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.FlushModeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Filter;
import org.jboss.seam.core.ManagedPersistenceContext;

@Name(value="org.jboss.seam.persistence.persistenceProvider")
@Scope(value=ScopeType.STATELESS)
@Intercept(value=InterceptionType.NEVER)
@Install(precedence=0, genericDependencies={ManagedPersistenceContext.class})
public class PersistenceProvider {
    public void setFlushModeManual(EntityManager entityManager) {
        throw new UnsupportedOperationException("For use of FlushMode.MANUAL, please use Hibernate as the persistence provider or use a custom PersistenceProvider");
    }

    public boolean isDirty(EntityManager entityManager) {
        return true;
    }

    public Object getId(Object bean, EntityManager entityManager) {
        return Entity.forClass(bean.getClass()).getIdentifier(bean);
    }

    public void enableFilter(Filter f, EntityManager entityManager) {
        throw new UnsupportedOperationException("For filters, please use Hibernate as the persistence provider");
    }

    public static PersistenceProvider instance() {
        return (PersistenceProvider)Component.getInstance(PersistenceProvider.class, ScopeType.STATELESS);
    }

    public FlushModeType getRenderFlushMode() {
        return FlushModeType.COMMIT;
    }
}

