/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.cache;

import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.ajax4jsf.cache.Cache;
import org.ajax4jsf.cache.CacheFactory;
import org.ajax4jsf.cache.OSCacheCache;
import org.ajax4jsf.resource.util.URLToStreamHelper;
import org.richfaces.log.RichfacesLogger;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSCacheCacheFactory
implements CacheFactory {
    private static final Logger log = RichfacesLogger.CACHE.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(URL url) throws IOException {
        Properties properties = new Properties();
        URL resource = OSCacheCache.class.getResource("oscache.properties");
        if (resource != null) {
            InputStream stream = URLToStreamHelper.urlToStream((URL)resource);
            try {
                properties.load(stream);
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
        return properties;
    }

    private ClassLoader findClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public Cache createCache(Map<?, ?> env) {
        Properties cacheProperties = new Properties();
        try {
            cacheProperties.putAll((Map<?, ?>)this.loadProperties(OSCacheCache.class.getResource("oscache.properties")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            cacheProperties.putAll((Map<?, ?>)this.loadProperties(this.findClassLoader().getResource("oscache.properties")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        cacheProperties.putAll(env);
        log.info("Creating OSCache cache instance using parameters: " + cacheProperties);
        GeneralCacheAdministrator cacheAdministrator = new GeneralCacheAdministrator(cacheProperties);
        return new OSCacheCache(cacheAdministrator.getCache());
    }
}

