/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.ajax4jsf.Messages;
import org.ajax4jsf.renderkit.RendererUtils;
import org.ajax4jsf.resource.InternetResource;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RendererBase
extends Renderer {
    protected static final String JAVASCRIPT_NAMESPACE = "Exadel";
    private static final Logger log = RichfacesLogger.RENDERKIT.getLogger();
    private static final RendererUtils utils = RendererUtils.getInstance();
    private SkinFactory skinFactory = null;

    public void decode(FacesContext context, UIComponent component) {
        if (context == null) {
            throw new NullPointerException(Messages.getMessage((String)"CONTEXT_NULL_ERROR", (Object)"decode"));
        }
        if (component == null) {
            throw new NullPointerException(Messages.getMessage((String)"COMPONENT_NULL_ERROR", (Object)"decode"));
        }
        if (!this.getComponentClass().isInstance(component)) {
            throw new IllegalArgumentException(Messages.getMessage((String)"COMPONENT_CLASS_ERROR", (Object)"", (Object)this.getComponentClass().getName()));
        }
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage((String)"START_DECODING_COMPONENT_INFO", (Object)component.getClientId(context), (Object)component.getClass().getName()));
        }
        this.preDecode(context, component);
        if (component.isRendered()) {
            this.decodeBehaviors(context, component);
            this.doDecode(context, component);
        }
    }

    protected void decodeBehaviors(FacesContext context, UIComponent component) {
        ExternalContext external;
        Map params;
        String behaviorEvent;
        ClientBehaviorHolder holder;
        Map behaviors;
        if (component instanceof ClientBehaviorHolder && !(behaviors = (holder = (ClientBehaviorHolder)component).getClientBehaviors()).isEmpty() && null != (behaviorEvent = (String)(params = (external = context.getExternalContext()).getRequestParameterMap()).get("javax.faces.behavior.event"))) {
            List behaviorsForEvent = (List)behaviors.get(behaviorEvent);
            if (behaviors != null && behaviors.size() > 0) {
                String behaviorSource = (String)params.get("javax.faces.source");
                String clientId = component.getClientId();
                if (null != behaviorSource && behaviorSource.equals(clientId)) {
                    for (ClientBehavior behavior : behaviorsForEvent) {
                        behavior.decode(context, component);
                    }
                }
            }
        }
    }

    protected void preDecode(FacesContext context, UIComponent component) {
    }

    protected void preEncodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException(Messages.getMessage((String)"CONTEXT_NULL_ERROR", (Object)"encodeBegin"));
        }
        if (component == null) {
            throw new NullPointerException(Messages.getMessage((String)"COMPONENT_NULL_ERROR", (Object)"encodeBegin"));
        }
        if (!this.getComponentClass().isInstance(component)) {
            throw new IllegalArgumentException(Messages.getMessage((String)"COMPONENT_CLASS_ERROR", (Object)component.getClientId(context), (Object)this.getComponentClass().getName()));
        }
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage((String)"START_ENCODING_COMPONENT_INFO", (Object)component.getClientId(context), (Object)component.getClass().getName()));
        }
        this.preEncodeBegin(context, component);
        if (component.isRendered()) {
            ResponseWriter writer = context.getResponseWriter();
            this.doEncodeBegin(writer, context, component);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException(Messages.getMessage((String)"CONTEXT_NULL_ERROR", (Object)"encodeBegin"));
        }
        if (component == null) {
            throw new NullPointerException(Messages.getMessage((String)"COMPONENT_NULL_ERROR", (Object)"encodeBegin"));
        }
        if (!this.getComponentClass().isInstance(component)) {
            throw new IllegalArgumentException(Messages.getMessage((String)"COMPONENT_CLASS_ERROR", (Object)component.getClientId(context), (Object)this.getComponentClass().getName()));
        }
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage((String)"CHILDREN_ENCODING_COMPONENT_INFO", (Object)component.getClientId(context), (Object)component.getClass().getName()));
        }
        this.preEncodeBegin(context, component);
        if (component.isRendered()) {
            ResponseWriter writer = context.getResponseWriter();
            this.doEncodeChildren(writer, context, component);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException(Messages.getMessage((String)"CONTEXT_NULL_ERROR", (Object)"encodeEnd"));
        }
        if (component == null) {
            throw new NullPointerException(Messages.getMessage((String)"COMPONENT_NULL_ERROR", (Object)"encodeEnd"));
        }
        if (!this.getComponentClass().isInstance(component)) {
            throw new IllegalArgumentException(Messages.getMessage((String)"COMPONENT_CLASS_ERROR", (Object)component.getClientId(context), (Object)this.getComponentClass().getName()));
        }
        if (component.isRendered()) {
            ResponseWriter writer = context.getResponseWriter();
            this.doEncodeEnd(writer, context, component);
        }
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage((String)"FINISH_ENCODING_COMPONENT_INFO", (Object)component.getClientId(context), (Object)component.getClass().getName()));
        }
    }

    protected Skin getSkin(FacesContext context) {
        if (this.skinFactory == null) {
            this.skinFactory = SkinFactory.getInstance();
        }
        return this.skinFactory.getSkin(context);
    }

    public RendererUtils getUtils() {
        return utils;
    }

    protected abstract Class<? extends UIComponent> getComponentClass();

    protected void doDecode(FacesContext context, UIComponent component) {
    }

    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
    }

    protected void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
    }

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
    }

    public void renderChildren(FacesContext facesContext, UIComponent component) throws IOException {
        for (UIComponent child : component.getChildren()) {
            this.renderChild(facesContext, child);
        }
    }

    public void renderChild(FacesContext facesContext, UIComponent child) throws IOException {
        if (!child.isRendered()) {
            return;
        }
        child.encodeBegin(facesContext);
        if (child.getRendersChildren()) {
            child.encodeChildren(facesContext);
        } else {
            this.renderChildren(facesContext, child);
        }
        child.encodeEnd(facesContext);
    }

    public InternetResource getResource(String name) {
        return null;
    }
}

