/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import org.richfaces.context.SingletonsContext;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.resource.AbstractCacheableResource;
import org.richfaces.resource.ResourceCodec;
import org.richfaces.resource.ResourceHandlerImpl;
import org.richfaces.resource.ResourceUtils;
import org.richfaces.resource.VersionedResource;
import org.richfaces.util.Util;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBaseResource
extends AbstractCacheableResource
implements VersionedResource {
    private static final Logger LOGGER = RichfacesLogger.RESOURCE.getLogger();
    public static final String URL_PROTOCOL = "jsfresource";
    private boolean cacheable = true;
    private String version;
    private Date lastModified = null;

    public AbstractBaseResource() {
        this.setResourceName(((Object)((Object)this)).getClass().getName());
    }

    protected int getContentLength(FacesContext context) {
        return -1;
    }

    protected Date getExpires(FacesContext context) {
        return null;
    }

    protected int getTimeToLive(FacesContext context) {
        return 0;
    }

    @Override
    protected Date getLastModified(FacesContext context) {
        block12: {
            if (this.lastModified == null) {
                Class<?> thisClass = ((Object)((Object)this)).getClass();
                ClassLoader classLoader = thisClass.getClassLoader();
                if (classLoader == null) {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
                if (classLoader != null) {
                    URL classResource = classLoader.getResource(thisClass.getName().replace('.', '/') + ".class");
                    if (classResource != null) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(MessageFormat.format("Located source for the resource class: {0}", classResource));
                        }
                        try {
                            URLConnection connection = classResource.openConnection();
                            connection.setUseCaches(false);
                            long classLastModifiedDate = connection.getLastModified();
                            if (classLastModifiedDate <= 0L) break block12;
                            this.lastModified = new Date(classLastModifiedDate);
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug(MessageFormat.format("Last source modification date is: {0,date}", this.lastModified));
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    } else if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Source for the resource class has not been located");
                    }
                }
            }
        }
        if (this.lastModified == null) {
            this.lastModified = (Date)SingletonsContext.APPLICATION.get(context).getAttribute(ResourceHandlerImpl.HANDLER_START_TIME_ATTRIBUTE);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(MessageFormat.format("Using resource handler start time as last modified date: {0,date,dd MMM yyyy HH:mm:ss zzz}", this.lastModified));
            }
        }
        return this.lastModified;
    }

    @Override
    public boolean isCacheable(FacesContext context) {
        return this.cacheable;
    }

    protected void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    @Override
    protected String getEntityTag(FacesContext context) {
        int contentLength = this.getContentLength(context);
        Date lastModified = this.getLastModified(context);
        if (contentLength >= 0 && lastModified != null) {
            return ResourceUtils.formatWeakTag(contentLength + "-" + lastModified.getTime());
        }
        return null;
    }

    public abstract InputStream getInputStream();

    public String getRequestPath() {
        StateHolder stateHolder;
        FacesContext context = FacesContext.getCurrentInstance();
        ResourceCodec resourceCodec = ResourceHandlerImpl.getResourceCodec(context);
        String resourceName = this.getResourceName();
        Object resourceData = null;
        if (this instanceof StateHolder && !(stateHolder = (StateHolder)this).isTransient()) {
            resourceData = stateHolder.saveState(context);
        }
        String resourceVersion = this.getVersion();
        String resourceUri = "/rfRes/" + resourceCodec.encodeResource(resourceName, resourceData, resourceVersion);
        resourceUri = Util.encodeResourceURL(context, resourceUri);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(MessageFormat.format("Request path for {0} resource is: {1}", String.valueOf(resourceName), String.valueOf(resourceUri)));
        }
        return resourceUri;
    }

    public String getVersion() {
        return this.version;
    }

    protected void setVersion(String version) {
        this.version = version;
    }

    boolean isResourceRequest() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return facesContext.getApplication().getResourceHandler().isResourceRequest(facesContext);
    }

    long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public Map<String, String> getResponseHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (this.isResourceRequest()) {
            boolean cacheable;
            Date lastModified;
            String contentType;
            int contentLength = this.getContentLength(facesContext);
            if (contentLength >= 0) {
                headers.put("Content-Length", String.valueOf(contentLength));
            }
            if ((contentType = this.getContentType()) != null) {
                headers.put("Content-Type", contentType);
            }
            if ((lastModified = this.getLastModified(facesContext)) != null) {
                headers.put("Last-Modified", Util.formatHttpDate(lastModified));
            }
            if (cacheable = this.isCacheable(facesContext)) {
                String entityTag;
                long currentTime = this.getCurrentTime();
                String formattedExpireDate = null;
                long maxAge = this.getTimeToLive(facesContext);
                if (maxAge > 0L) {
                    formattedExpireDate = Util.formatHttpDate(currentTime + maxAge * 1000L);
                } else {
                    Date expired = this.getExpires(facesContext);
                    if (expired != null) {
                        formattedExpireDate = Util.formatHttpDate(expired);
                        maxAge = (expired.getTime() - currentTime) / 1000L;
                    } else {
                        maxAge = 86400L;
                        formattedExpireDate = Util.formatHttpDate(currentTime + maxAge * 1000L);
                    }
                }
                if (formattedExpireDate != null) {
                    headers.put("Expires", formattedExpireDate);
                }
                if (maxAge > 0L) {
                    headers.put("Cache-Control", "max-age=" + maxAge);
                }
                if ((entityTag = this.getEntityTag(facesContext)) != null) {
                    headers.put("ETag", entityTag);
                }
            } else {
                headers.put("Expires", "0");
                headers.put("Cache-Control", "max-age=0, no-store, no-cache");
                headers.put("Pragma", "no-cache");
            }
            headers.put("Date", Util.formatHttpDate(this.getCurrentTime()));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Created set of response headers");
                for (Map.Entry entry : headers.entrySet()) {
                    LOGGER.debug(MessageFormat.format("\t{0}={1}", entry.getKey(), entry.getValue()));
                }
            }
        }
        return headers;
    }

    public URL getURL() {
        try {
            return new URL(URL_PROTOCOL, null, -1, this.getResourceName(), new URLStreamHandler(){

                protected URLConnection openConnection(URL u) throws IOException {
                    return new URLConnection(u){

                        public void connect() throws IOException {
                        }

                        public int getContentLength() {
                            FacesContext facesContext = FacesContext.getCurrentInstance();
                            return AbstractBaseResource.this.getContentLength(facesContext);
                        }

                        public String getContentType() {
                            return AbstractBaseResource.this.getContentType();
                        }

                        public long getExpiration() {
                            FacesContext facesContext = FacesContext.getCurrentInstance();
                            long ttl = AbstractBaseResource.this.getTimeToLive(facesContext);
                            if (ttl > 0L) {
                                return System.currentTimeMillis() + ttl * 1000L;
                            }
                            Date date = AbstractBaseResource.this.getExpires(facesContext);
                            if (date != null) {
                                return date.getTime();
                            }
                            return System.currentTimeMillis() + 86400000L;
                        }

                        public long getLastModified() {
                            FacesContext facesContext = FacesContext.getCurrentInstance();
                            Date date = AbstractBaseResource.this.getLastModified(facesContext);
                            if (date != null) {
                                return date.getTime();
                            }
                            return 0L;
                        }

                        public InputStream getInputStream() throws IOException {
                            return AbstractBaseResource.this.getInputStream();
                        }
                    };
                }
            });
        }
        catch (MalformedURLException e) {
            throw new FacesException(e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

