/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.actionparam;

import java.io.Serializable;
import javax.faces.el.EvaluationException;

public class MethodExpressionParser
implements Serializable {
    private static final long serialVersionUID = 7145647492529261758L;
    private String unparsedExpression;
    private String baseExpression = "";
    private String methodName = "";
    private String[] params;
    private String combinedExpression;
    private boolean hasParamsInExpression;

    public MethodExpressionParser(String expression) {
        this.unparsedExpression = expression;
        try {
            String noBrackets = MethodExpressionParser.stripBrackets(expression);
            noBrackets = MethodExpressionParser.convertSquareBrackets(noBrackets);
            this.hasParamsInExpression = MethodExpressionParser.hasParams(noBrackets);
            if (MethodExpressionParser.isStringLiteral(expression)) {
                this.params = new String[0];
                this.baseExpression = expression.trim();
                this.methodName = "";
                this.combinedExpression = this.baseExpression;
                return;
            }
            if (MethodExpressionParser.hasNoMethod(noBrackets)) {
                this.params = new String[0];
                this.baseExpression = noBrackets;
                this.methodName = "";
                this.combinedExpression = "#{" + this.baseExpression + "}";
                return;
            }
            this.params = MethodExpressionParser.getParams(noBrackets);
            String beforeParams = MethodExpressionParser.beforeParams(noBrackets);
            this.baseExpression = MethodExpressionParser.extractBaseExpression(beforeParams).trim();
            this.methodName = MethodExpressionParser.extractMethod(beforeParams).trim();
            this.combinedExpression = "#{" + this.baseExpression + "." + this.methodName + "}";
        }
        catch (Exception e) {
            throw new EvaluationException("Unable to parse method expression: " + expression, (Throwable)e);
        }
    }

    public String getUnparsedExpression() {
        return this.unparsedExpression;
    }

    public boolean hasParamsInExpression() {
        return this.hasParamsInExpression;
    }

    public String getBaseExpression() {
        return this.baseExpression;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String[] getParams() {
        return this.params;
    }

    public String getCombinedExpression() {
        return this.combinedExpression;
    }

    public boolean isParamExpression() {
        return !MethodExpressionParser.isStringLiteral(this.unparsedExpression) && (this.hasParamsInExpression() || MethodExpressionParser.hasNoArgParens(this.unparsedExpression));
    }

    public static boolean isQuotedString(String str) {
        if ((str = str.trim()).charAt(0) == '\"' && str.charAt(str.length() - 1) == '\"') {
            return true;
        }
        return str.charAt(0) == '\'' && str.charAt(str.length() - 1) == '\'';
    }

    public static boolean isStringLiteral(String expression) {
        String trimmed = expression.trim();
        return !trimmed.startsWith("${") && !trimmed.startsWith("#{") || !trimmed.endsWith("}");
    }

    private static boolean hasNoMethod(String expression) {
        String beforeParams = MethodExpressionParser.beforeParams(expression);
        return beforeParams.lastIndexOf(46) == -1;
    }

    private static String extractBaseExpression(String expression) {
        return expression.substring(0, expression.lastIndexOf(46));
    }

    private static String extractMethod(String expression) {
        return expression.substring(expression.lastIndexOf(46) + 1, expression.length());
    }

    private static String beforeParams(String expression) {
        if (!MethodExpressionParser.hasParams(expression) && MethodExpressionParser.noOpenParen(expression)) {
            return expression;
        }
        return expression.substring(0, expression.indexOf(40));
    }

    private static boolean noOpenParen(String expression) {
        return expression.indexOf(40) == -1;
    }

    private static String stripBrackets(String expression) {
        String trimmed = expression.trim();
        if (trimmed.length() < 3) {
            return trimmed;
        }
        return trimmed.substring(2, trimmed.length() - 1);
    }

    private static boolean hasParams(String expression) {
        int openParen = expression.indexOf(40);
        int closeParen = expression.lastIndexOf(41);
        if (openParen == -1 || closeParen == -1) {
            return false;
        }
        return !expression.substring(openParen + 1, closeParen).trim().equals("");
    }

    private static boolean hasNoArgParens(String expression) {
        int openParen = expression.indexOf(40);
        int closeParen = expression.lastIndexOf(41);
        if (openParen == -1 || closeParen == -1) {
            return false;
        }
        return expression.substring(openParen + 1, closeParen).trim().equals("");
    }

    private static String[] getParams(String exp) {
        if (!MethodExpressionParser.hasParams(exp)) {
            return new String[0];
        }
        String params = MethodExpressionParser.paramsOnly(exp);
        String[] split = params.split(",");
        for (int i = 0; i < split.length; ++i) {
            split[i] = split[i].trim();
        }
        return split;
    }

    private static String paramsOnly(String exp) {
        int start = exp.indexOf(40) + 1;
        int end = exp.lastIndexOf(41);
        return exp.substring(start, end);
    }

    private static String convertSquareBrackets(String exp) {
        String trimmed = exp.trim();
        if (!trimmed.endsWith("]")) {
            return exp;
        }
        int openBracket = (trimmed = trimmed.substring(0, trimmed.lastIndexOf(93))).lastIndexOf(91);
        if (openBracket == -1) {
            return exp;
        }
        StringBuilder builder = new StringBuilder(trimmed.substring(0, openBracket));
        builder.append('.');
        builder.append(trimmed.substring(openBracket + 1, trimmed.length()));
        return builder.toString();
    }
}

