/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.node;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.jpdl.xml.Parsable;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.jbpm.taskmgmt.exe.TaskMgmtInstance;

public class TaskNode
extends Node
implements Parsable {
    private static final long serialVersionUID = 1L;
    public static final int SIGNAL_UNSYNCHRONIZED = 0;
    public static final int SIGNAL_NEVER = 1;
    public static final int SIGNAL_FIRST = 2;
    public static final int SIGNAL_FIRST_WAIT = 3;
    public static final int SIGNAL_LAST = 4;
    public static final int SIGNAL_LAST_WAIT = 5;
    long id = 0L;
    Set tasks = null;
    int signal = 4;
    boolean createTasks = true;
    boolean endTasks = false;

    public static int parseSignal(String text) {
        if ("unsynchronized".equalsIgnoreCase(text)) {
            return 0;
        }
        if ("never".equalsIgnoreCase(text)) {
            return 1;
        }
        if ("first".equalsIgnoreCase(text)) {
            return 2;
        }
        if ("first-wait".equalsIgnoreCase(text)) {
            return 3;
        }
        if ("last-wait".equalsIgnoreCase(text)) {
            return 5;
        }
        return 4;
    }

    public static String signalToString(int signal) {
        if (signal == 0) {
            return "unsynchronized";
        }
        if (signal == 1) {
            return "never";
        }
        if (signal == 2) {
            return "first";
        }
        if (signal == 3) {
            return "first-wait";
        }
        if (signal == 4) {
            return "last";
        }
        if (signal == 5) {
            return "last-wait";
        }
        return null;
    }

    public TaskNode() {
    }

    public TaskNode(String name) {
        super(name);
    }

    public void read(Element element, JpdlXmlReader jpdlReader) {
        String removeTasksText;
        String createTasksText;
        String signalText = element.attributeValue("signal");
        if (signalText != null) {
            this.signal = TaskNode.parseSignal(signalText);
        }
        if ((createTasksText = element.attributeValue("create-tasks")) != null && ("no".equalsIgnoreCase(createTasksText) || "false".equalsIgnoreCase(createTasksText))) {
            this.createTasks = false;
        }
        if ((removeTasksText = element.attributeValue("end-tasks")) != null && ("yes".equalsIgnoreCase(removeTasksText) || "true".equalsIgnoreCase(removeTasksText))) {
            this.endTasks = true;
        }
        jpdlReader.readTasks(element, this);
    }

    public void addTask(Task task) {
        if (this.tasks == null) {
            this.tasks = new HashSet();
        }
        this.tasks.add(task);
        task.setTaskNode(this);
    }

    public void execute(ExecutionContext executionContext) {
        TaskMgmtInstance tmi = this.getTaskMgmtInstance(executionContext.getToken());
        if (this.createTasks && this.tasks != null) {
            Iterator iter = this.tasks.iterator();
            while (iter.hasNext()) {
                Task task = (Task)iter.next();
                executionContext.setTask(task);
                tmi.createTaskInstance(task, executionContext);
            }
        }
        boolean continueExecution = false;
        switch (this.signal) {
            case 0: {
                continueExecution = true;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                continueExecution = false;
                break;
            }
            case 2: 
            case 4: {
                continueExecution = tmi.getSignallingTasks(executionContext).isEmpty();
            }
        }
        if (continueExecution) {
            this.leave(executionContext);
        }
    }

    public void leave(ExecutionContext executionContext, Transition transition) {
        TaskMgmtInstance tmi = this.getTaskMgmtInstance(executionContext.getToken());
        if (tmi.hasBlockingTaskInstances(executionContext.getToken())) {
            throw new IllegalStateException("task-node '" + this.name + "' still has blocking tasks");
        }
        this.removeTaskInstanceSynchronization(executionContext.getToken());
        super.leave(executionContext, transition);
    }

    public boolean completionTriggersSignal(TaskInstance taskInstance) {
        boolean completionTriggersSignal = false;
        if (this.signal == 2 || this.signal == 3) {
            completionTriggersSignal = true;
        } else if ((this.signal == 4 || this.signal == 5) && this.isLastToComplete(taskInstance)) {
            completionTriggersSignal = true;
        }
        return completionTriggersSignal;
    }

    boolean isLastToComplete(TaskInstance taskInstance) {
        Token token = taskInstance.getToken();
        TaskMgmtInstance tmi = this.getTaskMgmtInstance(token);
        boolean isLastToComplete = true;
        Iterator iter = tmi.getTaskInstances().iterator();
        while (iter.hasNext() && isLastToComplete) {
            TaskInstance other = (TaskInstance)iter.next();
            if (token == null || !token.equals(other.getToken()) || other.equals(taskInstance) || !other.isSignalling() || other.hasEnded()) continue;
            isLastToComplete = false;
        }
        return isLastToComplete;
    }

    public void removeTaskInstanceSynchronization(Token token) {
        TaskMgmtInstance tmi = this.getTaskMgmtInstance(token);
        Collection taskInstances = tmi.getTaskInstances();
        if (taskInstances != null) {
            Iterator iter = taskInstances.iterator();
            while (iter.hasNext()) {
                TaskInstance taskInstance = (TaskInstance)iter.next();
                if (!token.equals(taskInstance.getToken())) continue;
                if (taskInstance.isSignalling()) {
                    taskInstance.setSignalling(false);
                }
                if (taskInstance.isBlocking()) {
                    taskInstance.setBlocking(false);
                }
                if (taskInstance.hasEnded() || !this.endTasks || !this.tasks.contains(taskInstance.getTask())) continue;
                taskInstance.end();
            }
        }
    }

    TaskMgmtInstance getTaskMgmtInstance(Token token) {
        return (TaskMgmtInstance)token.getProcessInstance().getInstance(TaskMgmtInstance.class);
    }

    public Map getTasksMap() {
        HashMap<String, Task> tasksMap = new HashMap<String, Task>();
        if (this.tasks != null) {
            Iterator iter = this.tasks.iterator();
            while (iter.hasNext()) {
                Task task = (Task)iter.next();
                tasksMap.put(task.getName(), task);
            }
        }
        return tasksMap;
    }

    public Task getTask(String taskName) {
        return (Task)this.getTasksMap().get(taskName);
    }

    public long getId() {
        return this.id;
    }

    public Set getTasks() {
        return this.tasks;
    }

    public int getSignal() {
        return this.signal;
    }

    public boolean getCreateTasks() {
        return this.createTasks;
    }

    public boolean isEndTasks() {
        return this.endTasks;
    }
}

