/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ioc.microcontainer;

import java.io.Serializable;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.ioc.microcontainer.ControllerNotificationComponent;
import org.jboss.seam.ioc.microcontainer.JMXNotificationComponentMBean;
import org.jboss.system.ServiceControllerMBean;

@Intercept(value=InterceptionType.NEVER)
@Startup
@Install(value=false, precedence=10)
public class JMXNotificationComponent
extends ControllerNotificationComponent
implements JMXNotificationComponentMBean,
Serializable {
    private static final long serialVersionUID = 1L;
    private ObjectName objectName;

    protected ObjectName createObjectName(Component component) throws Exception {
        return new ObjectName("seam:service=" + this.getClass().getSimpleName() + "." + component.getName());
    }

    protected void notifyController(Component component) throws Throwable {
        this.objectName = this.createObjectName(component);
        this.handleJMXRegistration(true);
    }

    protected void clearNotification() throws Throwable {
        this.handleJMXRegistration(false);
        this.objectName = null;
    }

    public void removeComponents() throws Throwable {
        this.clearNotification();
    }

    protected void handleJMXRegistration(boolean register) throws Exception {
        MBeanServer server = MBeanServerLocator.locateJBoss();
        if (server == null) {
            throw new IllegalArgumentException("Not running in JBoss app. server [currently only supporting]");
        }
        ServiceControllerMBean serviceController = (ServiceControllerMBean)MBeanProxyExt.create(ServiceControllerMBean.class, (ObjectName)ServiceControllerMBean.OBJECT_NAME);
        if (register) {
            server.registerMBean(this, this.objectName);
            serviceController.start(this.objectName);
        } else if (this.objectName != null) {
            serviceController.destroy(this.objectName);
            serviceController.remove(this.objectName);
        }
    }
}

