/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.column.Column;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.model.BeanPropertyComparator;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.renderkit.PartialRenderer;
import org.primefaces.util.ComponentUtils;

public class DataTableRenderer
extends CoreRenderer
implements PartialRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        DataTable dataTable = (DataTable)component;
        if (dataTable.getSelectionMode() != null || dataTable.getColumnSelectionMode() != null) {
            Map params = facesContext.getExternalContext().getRequestParameterMap();
            String rowSelectParam = dataTable.getClientId(facesContext) + "_selectedRows";
            String firstRowParam = dataTable.getClientId(facesContext) + "_firstRow";
            if (params.containsKey(rowSelectParam) && params.containsKey(firstRowParam)) {
                String rowSelectParamValue = (String)params.get(rowSelectParam);
                String firstRowParamValue = (String)params.get(firstRowParam);
                if (ComponentUtils.isValueBlank(rowSelectParamValue)) {
                    dataTable.setSelection(null);
                    return;
                }
                String[] rowSelectValues = rowSelectParamValue.split(",");
                Object[] data = new Object[rowSelectValues.length];
                for (int i = 0; i < rowSelectValues.length; ++i) {
                    String rowELIndex = rowSelectValues[i].trim().substring(7);
                    String firstRowELIndex = firstRowParamValue.trim().substring(7);
                    int rowIndex = Integer.parseInt(rowELIndex) - Integer.parseInt(firstRowELIndex);
                    dataTable.setRowIndex(rowIndex);
                    data[i] = dataTable.getRowData();
                }
                dataTable.setSelection(data);
            }
            dataTable.setRowIndex(-1);
        }
    }

    public void encodePartially(FacesContext facesContext, UIComponent component) throws IOException {
        DataTable dataTable = (DataTable)component;
        String first = (String)facesContext.getExternalContext().getRequestParameterMap().get("first");
        String sortKey = (String)facesContext.getExternalContext().getRequestParameterMap().get("sortKey");
        String sortDir = (String)facesContext.getExternalContext().getRequestParameterMap().get("sortDir");
        if (first != null) {
            dataTable.setFirst(Integer.parseInt(first));
        }
        if (sortKey != null && sortDir != null) {
            List value = (List)dataTable.getValue();
            Collections.sort(value, new BeanPropertyComparator(this.findSortByExpression(dataTable, sortKey), dataTable.getVar(), sortDir));
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("div", null);
        this.encodeTable(facesContext, dataTable);
        StateManager stateManager = facesContext.getApplication().getStateManager();
        stateManager.writeState(facesContext, stateManager.saveView(facesContext));
        writer.endElement("div");
    }

    private ValueExpression findSortByExpression(DataTable dataTable, String sortKey) {
        for (UIComponent kid : dataTable.getChildren()) {
            if (!kid.isRendered() || !(kid instanceof Column) || !kid.getId().equals(sortKey)) continue;
            return kid.getValueExpression("sortBy");
        }
        return null;
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        DataTable table = (DataTable)component;
        this.encodeScript(facesContext, table);
        this.encodeMarkup(facesContext, table);
    }

    private void encodeScript(FacesContext facesContext, DataTable dataTable) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = dataTable.getClientId(facesContext);
        String widgetVar = this.createUniqueWidgetVar(facesContext, (UIComponent)dataTable);
        writer.startElement("script", (UIComponent)dataTable);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady('" + clientId + "', function() {\n");
        String columnDefVar = this.encodeColumnDefinition(facesContext, dataTable, widgetVar);
        String datasourceVar = this.encodeDatasource(facesContext, dataTable, widgetVar);
        writer.write(widgetVar + " = new PrimeFaces.widget.DataTable('" + clientId + "'," + columnDefVar + "," + datasourceVar + ", {");
        this.encodeConfig(facesContext, dataTable);
        writer.write("});\n});\n");
        writer.endElement("script");
    }

    private String encodeDatasource(FacesContext facesContext, DataTable dataTable, String var) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = dataTable.getClientId(facesContext);
        String datasourceVar = var + "_datasource";
        boolean dynamic = dataTable.isDynamic();
        if (dynamic) {
            writer.write("var " + datasourceVar + " = new YAHOO.util.DataSource('" + this.getActionURL(facesContext) + "');\n");
            writer.write(datasourceVar + ".connMethodPost = true;\n");
        } else {
            writer.write("var " + datasourceVar + " = new YAHOO.util.DataSource(YAHOO.util.Dom.get('" + clientId + "_table'));\n");
        }
        writer.write(datasourceVar + ".responseType = YAHOO.util.DataSource.TYPE_HTMLTABLE;\n");
        writer.write(datasourceVar + ".responseSchema = {fields:[");
        Iterator children = dataTable.getChildren().iterator();
        while (children.hasNext()) {
            Column column;
            UIComponent kid = (UIComponent)children.next();
            if (!kid.isRendered() || !(kid instanceof Column) || (column = (Column)kid).getSelectionMode() != null) continue;
            writer.write("{key:'" + kid.getId() + "'");
            if (column.getParser() != null) {
                writer.write(",parser:'" + column.getParser() + "'");
            }
            writer.write("}");
            if (!children.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]");
        writer.write("};\n");
        return datasourceVar;
    }

    private String encodeColumnDefinition(FacesContext facesContext, DataTable dataTable, String datatableVar) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String columnDefVar = datatableVar + "_columnDef";
        writer.write("var " + columnDefVar + " = [");
        Iterator children = dataTable.getChildren().iterator();
        while (children.hasNext()) {
            UIComponent kid = (UIComponent)children.next();
            if (!kid.isRendered() || !(kid instanceof Column)) continue;
            Column column = (Column)kid;
            UIComponent header = column.getFacet("header");
            writer.write("{key:'" + column.getId() + "'");
            if (header != null) {
                writer.write(",label:'");
                if (header.getClass().getName().equals("com.sun.faces.facelets.compiler.UIInstructions")) {
                    String instructionsValue = header.toString();
                    if (instructionsValue != null) {
                        writer.write(instructionsValue.trim());
                    }
                } else {
                    this.renderChild(facesContext, column.getFacet("header"));
                }
                writer.write("'");
            } else {
                writer.write(",label:''");
            }
            if (column.getValueExpression("sortBy") != null) {
                writer.write(",sortable:true");
            }
            if (column.isResizable()) {
                writer.write(",resizeable:true");
            }
            if (column.isFilter()) {
                writer.write(",filter:true");
            }
            if (column.getWidth() != Integer.MIN_VALUE) {
                writer.write(",width:" + column.getWidth());
            }
            if (column.getSelectionMode() != null) {
                String selector = column.getSelectionMode().equals("single") ? "radio" : "checkbox";
                writer.write(",formatter:'" + selector + "'");
            }
            writer.write("}");
            if (!children.hasNext()) continue;
            writer.write(",");
        }
        writer.write("];\n");
        return columnDefVar;
    }

    private void encodeConfig(FacesContext facesContext, DataTable dataTable) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = dataTable.getClientId(facesContext);
        if (dataTable.isScrollable()) {
            writer.write("scrollable:true");
        } else {
            writer.write("scrollable:false");
        }
        if (dataTable.getWidth() != null) {
            writer.write(",width:'" + dataTable.getWidth() + "'");
        }
        if (dataTable.getHeight() != null) {
            writer.write(",height:'" + dataTable.getHeight() + "'");
        }
        if (dataTable.isPaginator()) {
            writer.write(",paginator:new YAHOO.widget.Paginator({\n");
            writer.write("rowsPerPage:" + dataTable.getRows());
            writer.write(",totalRecords:" + dataTable.getRowCount());
            if (dataTable.getPaginatorTemplate() != null) {
                writer.write(",template:'" + dataTable.getPaginatorTemplate() + "'");
            }
            if (dataTable.getRowsPerPageTemplate() != null) {
                writer.write(",rowsPerPageOptions : [" + dataTable.getRowsPerPageTemplate() + "]");
            }
            if (dataTable.getFirstPageLinkLabel() != null) {
                writer.write(",firstPageLinkLabel:'" + dataTable.getFirstPageLinkLabel() + "'");
            }
            if (dataTable.getPreviousPageLinkLabel() != null) {
                writer.write(",previousPageLinkLabel:'" + dataTable.getPreviousPageLinkLabel() + "'");
            }
            if (dataTable.getNextPageLinkLabel() != null) {
                writer.write(",nextPageLinkLabel:'" + dataTable.getNextPageLinkLabel() + "'");
            }
            if (dataTable.getLastPageLinkLabel() != null) {
                writer.write(",lastPageLinkLabel:'" + dataTable.getLastPageLinkLabel() + "'");
            }
            String paginatorPosition = dataTable.getPaginatorPosition();
            String paginatorContainer = null;
            if (paginatorPosition.equals("top")) {
                paginatorContainer = clientId + "_paginatorTop";
            } else if (paginatorPosition.equals("bottom")) {
                paginatorContainer = clientId + "_paginatorBottom";
            }
            if (paginatorContainer != null) {
                writer.write(",containers:['" + paginatorContainer + "']");
            }
            writer.write("})\n");
        }
        if (dataTable.getEmptyMessage() != null) {
            writer.write(",MSG_EMPTY : '" + dataTable.getEmptyMessage() + "'");
        }
        if (dataTable.getErrorMessage() != null) {
            writer.write(",MSG_ERROR : '" + dataTable.getErrorMessage() + "'");
        }
        if (dataTable.getLoadingMessage() != null) {
            writer.write(",MSG_LOADING : '" + dataTable.getLoadingMessage() + "'");
        }
        if (dataTable.getSortAscMessage() != null) {
            writer.write(",MSG_SORTASC : '" + dataTable.getSortAscMessage() + "'");
        }
        if (dataTable.getSortDescMessage() != null) {
            writer.write(",MSG_SORTDESC : '" + dataTable.getSortDescMessage() + "'");
        }
        if (dataTable.getSelectionMode() != null) {
            String mode = dataTable.getSelectionMode().equals("multiple") ? "standard" : "single";
            writer.write(",selectionMode:'" + mode + "'");
            if (dataTable.getUpdate() != null) {
                String formClientId = ComponentUtils.findParentForm(facesContext, (UIComponent)dataTable).getClientId(facesContext);
                writer.write(",update:'" + dataTable.getUpdate() + "'");
                writer.write(",formId:'" + formClientId + "'");
                writer.write(",url:'" + this.getActionURL(facesContext) + "'");
                if (dataTable.getOnselectStart() != null) {
                    writer.write(",onselectStart:function(){" + dataTable.getOnselectStart() + ";}");
                }
                if (dataTable.getOnselectComplete() != null) {
                    writer.write(",onselectComplete:function(){" + dataTable.getOnselectComplete() + ";}");
                }
            }
        }
        if (dataTable.getColumnSelectionMode() != null) {
            writer.write(",columnSelectionMode:'" + dataTable.getColumnSelectionMode() + "'");
        }
        if (dataTable.isDynamic()) {
            String formClientId = ComponentUtils.findParentForm(facesContext, (UIComponent)dataTable).getClientId(facesContext);
            writer.write(",formId:'" + formClientId + "'");
            writer.write(",dynamicData:true");
            writer.write(",generateRequest:PrimeFaces.widget.DataTableUtils.loadDynamicData");
            writer.write(",initialRequest:PrimeFaces.widget.DataTableUtils.loadInitialData('" + clientId + "','" + formClientId + "')");
        }
    }

    private void encodeMarkup(FacesContext facesContext, DataTable dataTable) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = dataTable.getClientId(facesContext);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        if (dataTable.getStyle() != null) {
            writer.writeAttribute("style", (Object)dataTable.getStyle(), "style");
        }
        if (dataTable.getPaginatorPosition().equals("top")) {
            this.encodePaginatorContainer(facesContext, clientId + "_paginatorTop");
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_container"), null);
        if (!dataTable.isDynamic()) {
            this.encodeTable(facesContext, dataTable);
        }
        writer.endElement("div");
        if (dataTable.getPaginatorPosition().equals("bottom")) {
            this.encodePaginatorContainer(facesContext, clientId + "_paginatorBottom");
        }
        this.encodeHiddenInput(facesContext, clientId + "_selectedRows");
        this.encodeHiddenInput(facesContext, clientId + "_firstRow");
        writer.endElement("div");
    }

    private void encodeHiddenInput(FacesContext facesContext, String id) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.endElement("input");
    }

    private void encodeTable(FacesContext facesContext, DataTable dataTable) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = dataTable.getClientId(facesContext);
        writer.startElement("table", null);
        writer.writeAttribute("id", (Object)(clientId + "_table"), null);
        this.encodeHeaders(facesContext, dataTable);
        this.encodeRows(facesContext, dataTable);
        writer.endElement("table");
    }

    private void encodePaginatorContainer(FacesContext facesContext, String id) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.endElement("div");
    }

    private void encodeHeaders(FacesContext facesContext, DataTable dataTable) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("thead", null);
        writer.startElement("tr", null);
        for (UIComponent kid : dataTable.getChildren()) {
            Column column;
            if (!kid.isRendered() || !(kid instanceof Column) || (column = (Column)kid).getSelectionMode() != null) continue;
            writer.startElement("th", (UIComponent)column);
            if (column.getFacet("header") != null) {
                this.renderChild(facesContext, column.getFacet("header"));
            }
            writer.endElement("th");
        }
        writer.endElement("tr");
        writer.endElement("thead");
    }

    private void encodeRows(FacesContext facesContext, DataTable dataTable) throws IOException {
        int first;
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("tbody", null);
        if (dataTable.isLazy()) {
            dataTable.loadLazyData();
        }
        int rowCountToRender = this.getNumberOfRowsToRender(dataTable);
        for (int i = first = dataTable.getFirst(); i < first + rowCountToRender; ++i) {
            dataTable.setRowIndex(i);
            if (!dataTable.isRowAvailable()) continue;
            if (dataTable.getRowIndexVar() != null) {
                facesContext.getExternalContext().getRequestMap().put(dataTable.getRowIndexVar(), i);
            }
            writer.startElement("tr", null);
            for (UIComponent kid : dataTable.getChildren()) {
                Column column;
                if (!kid.isRendered() || !(kid instanceof Column) || (column = (Column)kid).getSelectionMode() != null) continue;
                writer.startElement("td", null);
                this.renderChildren(facesContext, (UIComponent)column);
                writer.endElement("td");
            }
            writer.endElement("tr");
        }
        dataTable.setRowIndex(-1);
        if (dataTable.getRowIndexVar() != null) {
            facesContext.getExternalContext().getRequestMap().remove(dataTable.getRowIndexVar());
        }
        writer.endElement("tbody");
    }

    private int getNumberOfRowsToRender(DataTable dataTable) {
        if (dataTable.isDynamic()) {
            return dataTable.getRows() == 0 ? dataTable.getRowCount() : dataTable.getRows();
        }
        return dataTable.getRowCount();
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

