/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.dnd;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.dnd.Droppable;
import org.primefaces.event.DragDropEvent;
import org.primefaces.renderkit.CoreRenderer;

public class DroppableRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        Droppable droppable;
        String dropId;
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (params.containsKey(dropId = (droppable = (Droppable)component).getParent().getClientId(facesContext))) {
            String dragId = (String)params.get("dragId");
            droppable.queueEvent(new DragDropEvent((UIComponent)droppable, dragId, dropId));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Droppable droppable = (Droppable)component;
        String draggableVar = this.createUniqueWidgetVar(facesContext, (UIComponent)droppable);
        String parentClientId = droppable.getParent().getClientId(facesContext);
        writer.startElement("script", (UIComponent)droppable);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady('" + parentClientId + "', function() {\n");
        writer.write(draggableVar + " = new PrimeFaces.widget.Droppable('" + parentClientId + "');\n");
        writer.write("});\n");
        writer.endElement("script");
    }
}

