/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.inputmask;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.inputmask.InputMask;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;

public class InputMaskRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        InputMask inputMask = (InputMask)component;
        String clientId = inputMask.getClientId(facesContext);
        String submittedValue = (String)facesContext.getExternalContext().getRequestParameterMap().get(clientId);
        inputMask.setSubmittedValue(submittedValue);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        InputMask inputMask = (InputMask)component;
        this.encodeScript(facesContext, inputMask);
        this.encodeMarkup(facesContext, inputMask);
    }

    private void encodeScript(FacesContext facesContext, InputMask inputMask) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = inputMask.getClientId(facesContext);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady('" + clientId + "', function() {\n");
        writer.write("jQuery(PrimeFaces.escapeClientId('" + clientId + "')).mask('" + inputMask.getMask() + "'");
        if (inputMask.getPlaceHolder() != null) {
            writer.write(",{placeholder:'" + inputMask.getPlaceHolder() + "'}");
        }
        writer.write(")});\n");
        writer.endElement("script");
    }

    private void encodeMarkup(FacesContext facesContext, InputMask inputMask) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = inputMask.getClientId(facesContext);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("type", (Object)"text", null);
        String valueToRender = ComponentUtils.getStringValueToRender(facesContext, (UIComponent)inputMask);
        if (valueToRender != null) {
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        this.renderPassThruAttributes(facesContext, (UIComponent)inputMask, HTML.INPUT_TEXT_ATTRS);
        writer.endElement("input");
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent component, Object submittedValue) throws ConverterException {
        InputMask inputMask = (InputMask)component;
        String value = (String)submittedValue;
        Converter converter = inputMask.getConverter();
        if (converter != null) {
            return converter.getAsObject(facesContext, (UIComponent)inputMask, value);
        }
        Class valueType = inputMask.getValueExpression("value").getType(facesContext.getELContext());
        Converter converterForType = facesContext.getApplication().createConverter(valueType);
        if (converterForType != null) {
            return converterForType.getAsObject(facesContext, (UIComponent)inputMask, value);
        }
        return value;
    }
}

