/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.uiajax;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.uiajax.UIAjax;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class UIAjaxRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        UIAjax ajax = (UIAjax)component;
        String clientId = ajax.getClientId(facesContext);
        if (facesContext.getExternalContext().getRequestParameterMap().containsKey(clientId)) {
            ajax.queueEvent((FacesEvent)new ActionEvent((UIComponent)ajax));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UIAjax uiajax = (UIAjax)component;
        UIComponent parent = uiajax.getParent();
        String formClientId = null;
        String clientId = uiajax.getClientId(facesContext);
        UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)uiajax);
        if (form == null) {
            throw new FacesException("UIAjax:" + clientId + " needs to be enclosed in a form");
        }
        formClientId = ComponentUtils.findParentForm(facesContext, (UIComponent)uiajax).getClientId(facesContext);
        String ajaxRequest = this.getAjaxRequest(facesContext, uiajax, formClientId);
        ComponentUtils.decorateAttribute(parent, "on" + uiajax.getEvent(), ajaxRequest);
    }

    private String getAjaxRequest(FacesContext facesContext, UIAjax uiajax, String formClientId) {
        String clientId = uiajax.getClientId(facesContext);
        StringBuilder req = new StringBuilder();
        req.append("PrimeFaces.ajax.AjaxRequest('");
        req.append(this.getActionURL(facesContext));
        req.append("',{");
        req.append("formClientId:'");
        req.append(formClientId);
        req.append("', ajaxifiedComponent:this");
        if (uiajax.getOnstart() != null) {
            req.append(",onstart:function(){" + uiajax.getOnstart() + ";}");
        }
        if (uiajax.getOncomplete() != null) {
            req.append(",oncomplete:function(){" + uiajax.getOncomplete() + ";}");
        }
        if (uiajax.isPartialSubmit()) {
            req.append(",partialSubmit:true");
        }
        req.append("},");
        req.append("'update=");
        if (uiajax.getUpdate() != null) {
            req.append(uiajax.getUpdate());
        } else {
            req.append(formClientId);
        }
        req.append("&");
        req.append(clientId);
        req.append("=");
        req.append(clientId);
        req.append("');");
        return req.toString();
    }
}

