/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.util.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.ajax4jsf.framework.util.config.FilterBean;
import org.ajax4jsf.framework.util.config.ServletBean;
import org.ajax4jsf.framework.util.message.Messages;
import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.LocatorImpl;

public class WebXml {
    private static final Log _log = LogFactory.getLog((Class)WebXml.class);
    static final String WEB_XML = "/WEB-INF/web.xml";
    public static final String RESOURCE_URI_PREFIX = "a4j.res/";
    static final String RESOURCE_URI_PREFIX_WITH_SLASH = "/a4j.res/";
    private String _facesFilterPrefix = null;
    private String _facesFilterSuffix = null;
    private boolean _prefixMapping = false;
    private String _filterName;
    private Map _servlets = new HashMap();
    private Map _filters = new HashMap();
    private String _resourcePrefix = "/a4j.res/";

    public WebXml(ServletContext context, String filterName) throws ServletException {
        InputStream webXml = context.getResourceAsStream(WEB_XML);
        if (null == webXml) {
            throw new ServletException(Messages.getMessage(Messages.GET_RESOURCE_AS_STREAM_ERROR, WEB_XML));
        }
        Digester dig = new Digester();
        dig.setDocumentLocator((Locator)new LocatorImpl());
        dig.setValidating(false);
        dig.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        });
        dig.setNamespaceAware(false);
        dig.setClassLoader(this.getClass().getClassLoader());
        String path = "web-app/servlet";
        dig.addObjectCreate(path, ServletBean.class);
        dig.addBeanPropertySetter(path + "/servlet-name", "servletName");
        dig.addBeanPropertySetter(path + "/servlet-class", "servletClass");
        dig.addBeanPropertySetter(path + "/display-name", "displayName");
        dig.addBeanPropertySetter(path + "/description");
        dig.addSetNext(path, "addServlet");
        path = "web-app/filter";
        dig.addObjectCreate(path, FilterBean.class);
        dig.addBeanPropertySetter(path + "/filter-name", "filterName");
        dig.addBeanPropertySetter(path + "/filter-class", "filterClass");
        dig.addBeanPropertySetter(path + "/display-name", "displayName");
        dig.addBeanPropertySetter(path + "/description");
        dig.addSetNext(path, "addFilter");
        path = "web-app/servlet-mapping";
        dig.addCallMethod(path, "addServletMapping", 2);
        dig.addCallParam(path + "/servlet-name", 0);
        dig.addCallParam(path + "/url-pattern", 1);
        path = "web-app/filter-mapping";
        dig.addCallMethod(path, "addFilterMapping", 3);
        dig.addCallParam(path + "/filter-name", 0);
        dig.addCallParam(path + "/url-pattern", 1);
        dig.addCallParam(path + "/servlet-name", 2);
        dig.push((Object)this);
        try {
            dig.parse(webXml);
            this.setFilterName(filterName);
        }
        catch (IOException e) {
            String message = Messages.getMessage(Messages.PARSING_WEB_XML_IO_ERROR);
            _log.error((Object)message, (Throwable)e);
            throw new ServletException(message, (Throwable)e);
        }
        catch (SAXException e) {
            String message = Messages.getMessage(Messages.PARSING_WEB_XML_SAX_ERROR);
            _log.error((Object)message, (Throwable)e);
            throw new ServletException(message, (Throwable)e);
        }
        finally {
            try {
                webXml.close();
            }
            catch (IOException e) {}
        }
    }

    public void addServlet(ServletBean bean) {
        String name = bean.getServletName();
        if (null != name) {
            this._servlets.put(name, bean);
        }
    }

    public void addFilter(FilterBean bean) {
        String name = bean.getFilterName();
        if (null != name) {
            this._filters.put(name, bean);
        }
    }

    public void addServletMapping(String servletName, String mapping) {
        ServletBean servletBean = (ServletBean)this._servlets.get(servletName);
        if (null != servletBean) {
            servletBean.addMapping(mapping);
        }
    }

    public void addFilterMapping(String filterName, String mapping, String servlet) {
        FilterBean filterBean = (FilterBean)this._filters.get(filterName);
        if (null != filterBean) {
            if (null != mapping) {
                filterBean.addMapping(mapping);
            }
            if (null != servlet) {
                filterBean.addServlet(servlet);
            }
        }
    }

    public String getFacesResourceURL(FacesContext context, String Url) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getResourcePrefix()).append(Url);
        if (this.isPrefixMapping()) {
            buf.insert(0, this.getFacesFilterPrefix());
        } else {
            int index = buf.indexOf("?");
            if (index >= 0) {
                buf.insert(index, this.getFacesFilterSuffix());
            } else {
                buf.append(this.getFacesFilterSuffix());
            }
        }
        String resourceURL = context.getApplication().getViewHandler().getResourceURL(context, buf.toString());
        return resourceURL;
    }

    public String getFacesResourceKey(HttpServletRequest request) {
        String resourcePath = request.getRequestURI().substring(request.getContextPath().length());
        int jsesionidStart = resourcePath.lastIndexOf(";jsessionid");
        if (jsesionidStart >= 0) {
            resourcePath = resourcePath.substring(0, jsesionidStart);
        }
        if (this.isPrefixMapping()) {
            if (resourcePath.startsWith(this.getFacesFilterPrefix() + this.getResourcePrefix())) {
                return resourcePath.substring(this.getFacesFilterPrefix().length() + this.getResourcePrefix().length());
            }
        } else if (resourcePath.startsWith(this.getResourcePrefix())) {
            return resourcePath.substring(this.getResourcePrefix().length(), resourcePath.length() - this.getFacesFilterSuffix().length());
        }
        return null;
    }

    public boolean isFacesRequest(HttpServletRequest request) {
        return true;
    }

    String getFacesFilterPrefix() {
        return this._facesFilterPrefix;
    }

    void setFacesFilterPrefix(String facesFilterPrefix) {
        this._facesFilterPrefix = facesFilterPrefix;
    }

    String getFacesFilterSuffix() {
        return this._facesFilterSuffix;
    }

    void setFacesFilterSuffix(String facesFilterSuffix) {
        this._facesFilterSuffix = facesFilterSuffix;
    }

    String getResourcePrefix() {
        return this._resourcePrefix;
    }

    void setResourcePrefix(String resourcePrefix) {
        this._resourcePrefix = resourcePrefix;
    }

    String getFilterName() {
        return this._filterName;
    }

    void setFilterName(String filterName) {
        if (null == filterName) {
            _log.warn((Object)Messages.getMessage(Messages.NULL_FILTER_NAME_WARNING));
            return;
        }
        this._filterName = filterName.trim();
        FilterBean filter = (FilterBean)this._filters.get(this._filterName);
        if (null == filter) {
            _log.warn((Object)Messages.getMessage(Messages.FILTER_NOT_FOUND_ERROR, this._filterName));
            throw new IllegalStateException(Messages.getMessage(Messages.FILTER_NOT_CONFIGURED_ERROR, filterName));
        }
        this.checkMapping(filter.getMappings());
        if (this._facesFilterPrefix == null && this._facesFilterSuffix == null) {
            Iterator sevlets = filter.getServlets().iterator();
            while (sevlets.hasNext() && this._facesFilterPrefix == null && this._facesFilterSuffix == null) {
                String servletname = (String)sevlets.next();
                ServletBean servlet = (ServletBean)this._servlets.get(servletname);
                if (null == servlet) continue;
                this.checkMapping(servlet.getMappings());
            }
        }
        if (null != this._facesFilterPrefix) {
            this._prefixMapping = true;
            if (this._facesFilterPrefix.endsWith("/")) {
                this.setResourcePrefix(RESOURCE_URI_PREFIX);
            } else {
                this.setResourcePrefix(RESOURCE_URI_PREFIX_WITH_SLASH);
            }
        } else if (null != this._facesFilterSuffix) {
            this._prefixMapping = false;
            this.setResourcePrefix(RESOURCE_URI_PREFIX_WITH_SLASH);
        } else {
            throw new IllegalStateException(Messages.getMessage(Messages.NO_PREFIX_OR_SUFFIX_IN_FILTER_MAPPING_ERROR, filterName));
        }
    }

    private void checkMapping(Set mappings) {
        if (null != mappings) {
            Iterator iter = mappings.iterator();
            while (iter.hasNext()) {
                String mapping = (String)iter.next();
                if (mapping.endsWith("*")) {
                    this.setFacesFilterPrefix(mapping.substring(0, mapping.length() - 1));
                    break;
                }
                if (!mapping.startsWith("*")) continue;
                this.setFacesFilterSuffix(mapping.substring(1));
            }
        }
    }

    boolean isPrefixMapping() {
        return this._prefixMapping;
    }
}

