/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.servlet.ServletRequest;
import org.jboss.seam.web.MultipartRequest;

public class UIFileUpload
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "org.jboss.seam.ui.UIFileUpload";
    public static final String COMPONENT_FAMILY = "org.jboss.seam.ui.FileUpload";
    private String accept;
    private String styleClass;
    private String style;

    public void decode(FacesContext context) {
        super.decode(context);
        ServletRequest request = (ServletRequest)context.getExternalContext().getRequest();
        if (!(request instanceof MultipartRequest)) {
            request = this.unwrapMultipartRequest(request);
        }
        if (request instanceof MultipartRequest) {
            ValueBinding vb;
            MultipartRequest req = (MultipartRequest)request;
            String clientId = this.getClientId(context);
            String contentType = req.getFileContentType(clientId);
            String fileName = req.getFileName(clientId);
            int fileSize = req.getFileSize(clientId);
            ValueBinding dataBinding = this.getValueBinding("data");
            if (dataBinding != null) {
                Class cls = dataBinding.getType(context);
                if (cls.isAssignableFrom(InputStream.class)) {
                    dataBinding.setValue(context, (Object)req.getFileInputStream(clientId));
                } else if (cls.isAssignableFrom(byte[].class)) {
                    dataBinding.setValue(context, (Object)req.getFileBytes(clientId));
                }
            }
            if ((vb = this.getValueBinding("contentType")) != null) {
                vb.setValue(context, (Object)contentType);
            }
            if ((vb = this.getValueBinding("fileName")) != null) {
                vb.setValue(context, (Object)fileName);
            }
            if ((vb = this.getValueBinding("fileSize")) != null) {
                vb.setValue(context, (Object)fileSize);
            }
        }
    }

    private ServletRequest unwrapMultipartRequest(ServletRequest request) {
        while (!(request instanceof MultipartRequest)) {
            boolean found = false;
            for (Method method : request.getClass().getMethods()) {
                if (!ServletRequest.class.isAssignableFrom(method.getReturnType()) || method.getParameterTypes().length != 0) continue;
                try {
                    request = (ServletRequest)method.invoke((Object)request, new Object[0]);
                    found = true;
                    break;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (!found) {
                for (AccessibleObject accessibleObject : request.getClass().getDeclaredFields()) {
                    if (!ServletRequest.class.isAssignableFrom(((Field)accessibleObject).getType())) continue;
                    try {
                        request = (ServletRequest)((Field)accessibleObject).get(request);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            if (found) continue;
            break;
        }
        return request;
    }

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", (UIComponent)this);
        writer.writeAttribute("type", (Object)"file", null);
        String clientId = this.getClientId(context);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        ValueBinding vb = this.getValueBinding("accept");
        if (vb != null) {
            writer.writeAttribute("accept", vb.getValue(context), null);
        } else if (this.accept != null) {
            writer.writeAttribute("accept", (Object)this.accept, null);
        }
        if (this.styleClass != null) {
            writer.writeAttribute("styleClass", (Object)this.styleClass, null);
        }
        if (this.style != null) {
            writer.writeAttribute("style", (Object)this.style, null);
        }
        writer.endElement("input");
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getAccept() {
        return this.accept;
    }

    public void setAccept(String accept) {
        this.accept = accept;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }
}

