/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rules;
import org.apache.commons.digester.RulesBase;
import org.richfaces.component.TreeNode;
import org.richfaces.component.TreeNodeImpl;
import org.richfaces.component.xml.XmlNodeData;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlTreeDataBuilder {
    public static TreeNode build(InputSource inputSource) throws SAXException, IOException {
        Digester digester = new Digester();
        Rule rule = new Rule();
        final ArrayList<Rule> rulesList = new ArrayList<Rule>(1);
        rulesList.add(rule);
        RulesBase rulesBase = new RulesBase(){

            protected List lookup(String namespace, String name) {
                return rulesList;
            }
        };
        digester.setRules((Rules)rulesBase);
        digester.parse(inputSource);
        return rule.treeNode;
    }

    private static final class Rule
    extends org.apache.commons.digester.Rule {
        private int level = -1;
        private List idsList = new ArrayList();
        private List treeNodesList = new ArrayList();
        private List exclusionSets = new ArrayList();
        private TreeNode treeNode = new TreeNodeImpl();

        private Rule() {
        }

        public void begin(String namespace, String name, Attributes attributes) throws Exception {
            int i;
            super.begin(namespace, name, attributes);
            ++this.level;
            XmlNodeData xmlNodeData = new XmlNodeData();
            xmlNodeData.setName(name);
            xmlNodeData.setNamespace(namespace);
            String id = null;
            if (attributes != null) {
                int length = attributes.getLength();
                for (i = 0; i < length; ++i) {
                    xmlNodeData.setAttribute(attributes.getQName(i), attributes.getValue(i));
                }
                id = attributes.getValue("id");
            }
            if (this.exclusionSets.size() == this.level) {
                this.exclusionSets.add(null);
            }
            if (id == null || id.length() == 0) {
                int currentId = 0;
                if (this.idsList.size() <= this.level) {
                    for (i = this.idsList.size(); i < this.level; ++i) {
                        this.idsList.add(null);
                    }
                    this.idsList.add(new Integer(0));
                } else {
                    Integer integer = (Integer)this.idsList.get(this.level);
                    if (integer != null) {
                        currentId = integer + 1;
                    }
                }
                Set exclusions = (Set)this.exclusionSets.get(this.level);
                while (exclusions != null && exclusions.contains(Integer.toString(currentId))) {
                    ++currentId;
                }
                this.idsList.set(this.level, new Integer(currentId));
                id = Integer.toString(currentId);
            } else {
                HashSet<String> exclusions = (HashSet<String>)this.exclusionSets.get(this.level);
                if (exclusions == null) {
                    exclusions = new HashSet<String>();
                    this.exclusionSets.set(this.level, exclusions);
                }
                exclusions.add(id);
            }
            TreeNodeImpl node = new TreeNodeImpl();
            node.setData(xmlNodeData);
            if (this.treeNode != null) {
                this.treeNode.addChild(id, node);
                this.treeNodesList.add(this.treeNode);
            }
            this.treeNode = node;
        }

        public void body(String namespace, String name, String text) throws Exception {
            super.body(namespace, name, text);
        }

        public void end(String namespace, String name) throws Exception {
            super.end(namespace, name);
            --this.level;
            if (this.idsList.size() - 1 > this.level + 1) {
                this.idsList.remove(this.idsList.size() - 1);
            }
            if (this.exclusionSets.size() - 1 > this.level + 1) {
                this.exclusionSets.remove(this.exclusionSets.size() - 1);
            }
            if (!this.treeNodesList.isEmpty()) {
                this.treeNode = (TreeNode)this.treeNodesList.remove(this.treeNodesList.size() - 1);
            }
        }
    }
}

