/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.exec;

import antlr.RecognitionException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.hibernate.hql.internal.ast.QuerySyntaxException;
import org.hibernate.hql.internal.ast.SqlGenerator;
import org.hibernate.hql.internal.ast.exec.AbstractStatementExecutor;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.persister.entity.Queryable;

public class BasicExecutor
extends AbstractStatementExecutor {
    private final Queryable persister;
    private final String sql;
    private final List parameterSpecifications;

    public BasicExecutor(HqlSqlWalker walker, Queryable persister) {
        super(walker, null);
        this.persister = persister;
        try {
            SqlGenerator gen = new SqlGenerator(this.getFactory());
            gen.statement(walker.getAST());
            this.sql = gen.getSQL();
            gen.getParseErrorHandler().throwQueryException();
            this.parameterSpecifications = gen.getCollectedParameters();
        }
        catch (RecognitionException e) {
            throw QuerySyntaxException.convert(e);
        }
    }

    @Override
    public String[] getSqlStatements() {
        return new String[]{this.sql};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(QueryParameters parameters, SessionImplementor session) throws HibernateException {
        int n;
        block8: {
            this.coordinateSharedCacheCleanup(session);
            Statement st = null;
            RowSelection selection = parameters.getRowSelection();
            try {
                st = session.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(this.sql, false);
                Iterator parameterSpecifications = this.parameterSpecifications.iterator();
                int pos = 1;
                while (parameterSpecifications.hasNext()) {
                    ParameterSpecification paramSpec = (ParameterSpecification)parameterSpecifications.next();
                    pos += paramSpec.bind((PreparedStatement)st, parameters, session, pos);
                }
                if (selection != null && selection.getTimeout() != null) {
                    st.setQueryTimeout(selection.getTimeout());
                }
                n = st.executeUpdate();
                if (st == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (st != null) {
                        st.close();
                    }
                    throw throwable;
                }
                catch (SQLException sqle) {
                    throw this.getFactory().getSQLExceptionHelper().convert(sqle, "could not execute update query", this.sql);
                }
            }
            st.close();
        }
        return n;
    }

    @Override
    protected Queryable[] getAffectedQueryables() {
        return new Queryable[]{this.persister};
    }
}

