/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.taglib;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.ValueBinding;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.ajax4jsf.Messages;
import org.richfaces.component.Draggable;
import org.richfaces.event.DragListener;

public class DragListenerTag
extends TagSupport {
    private static final long serialVersionUID = -274448680242671987L;
    private String type;
    private String binding;

    public int doStartTag() throws JspException {
        UIComponentTag parentTag = UIComponentTag.getParentUIComponentTag((PageContext)this.pageContext);
        if (parentTag == null) {
            throw new JspException(Messages.getMessage((String)"NO_UI_COMPONENT_TAG_ANCESTOR_ERROR", (Object)((Object)((Object)this)).getClass().getName()));
        }
        if (this.type == null && this.binding == null) {
            throw new JspException("Either of the following attributes is required: type binding");
        }
        if (parentTag.getCreated()) {
            FacesContext context = FacesContext.getCurrentInstance();
            Application application = context.getApplication();
            DragListener listener = null;
            UIComponent component = parentTag.getComponentInstance();
            if (this.binding != null) {
                ValueBinding valueBinding = application.createValueBinding(this.binding);
                try {
                    listener = (DragListener)valueBinding.getValue(context);
                }
                catch (EvaluationException e) {
                    throw new JspException((Throwable)e);
                }
            }
            if (listener == null) {
                String className = null;
                if (UIComponentTag.isValueReference((String)this.type)) {
                    try {
                        className = (String)application.createValueBinding(this.type).getValue(context);
                    }
                    catch (EvaluationException e) {
                        throw new JspException((Throwable)e);
                    }
                } else {
                    className = this.type;
                }
                if (className == null) {
                    throw new JspException("Type attribute resolved to null.");
                }
                try {
                    listener = (DragListener)Class.forName(className).newInstance();
                }
                catch (Exception e) {
                    throw new JspException(Messages.getMessage((String)"INSTANTIATE_LISTENER_ERROR", (Object)className, (Object)component.getId()), (Throwable)e);
                }
            }
            if (listener != null) {
                ((Draggable)component).addDragListener(listener);
            }
        }
        return 0;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getBinding() {
        return this.binding;
    }

    public void setBinding(String binding) {
        this.binding = binding;
    }

    public void release() {
        this.type = null;
        this.binding = null;
    }
}

