/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.BitSet;

public class HtmlUtils {
    private static final int MAX_BYTES_PER_CHAR = 10;
    private static final BitSet DONT_ENCODE_SET = new BitSet(256);
    private static String[] sISO8859_1_Entities;
    private static final byte[] encodingTestBytes;
    private static char _LAST_EMPTY_ELEMENT_START;
    private static String[][] emptyElementArr;
    private static String[] aNames;
    private static String[] bNames;
    private static String[] cNames;
    private static String[] fNames;
    private static String[] hNames;
    private static String[] iNames;
    private static String[] lNames;
    private static String[] mNames;
    private static String[] pNames;

    public static void writeText(Writer out, char[] buffer, char[] text) throws IOException {
        HtmlUtils.writeText(out, buffer, text, 0, text.length);
    }

    public static void writeText(Writer out, char[] buff, char[] text, int start, int length) throws IOException {
        int buffLength = buff.length;
        int buffIndex = 0;
        int end = start + length;
        int i = start;
        while (i < end) {
            char ch = text[i];
            if (ch < '\u00a0') {
                if (ch >= '?') {
                    buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                } else if (ch >= '\'') {
                    if (ch < '<') {
                        buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                    } else if (ch == '<') {
                        buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                        out.write("&lt;");
                    } else if (ch == '>') {
                        buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                        out.write("&gt;");
                    } else {
                        buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                    }
                } else if (ch == '&') {
                    buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                    out.write("&amp;");
                } else {
                    buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                }
            } else if (ch <= '\u00ff') {
                buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                out.write(38);
                out.write(sISO8859_1_Entities[ch - 160]);
                out.write(59);
            } else {
                buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                HtmlUtils._writeDecRef(out, ch);
            }
            ++i;
        }
        HtmlUtils.flushBuffer(out, buff, buffIndex);
    }

    public static void writeText(Writer out, char[] buff, String text) throws IOException {
        int buffLength = buff.length;
        int buffIndex = 0;
        int length = text.length();
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            if (ch < '\u00a0') {
                if (ch >= '?') {
                    buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                } else if (ch >= '\'') {
                    if (ch < '<') {
                        buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                    } else if (ch == '<') {
                        buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                        out.write("&lt;");
                    } else if (ch == '>') {
                        buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                        out.write("&gt;");
                    } else {
                        buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                    }
                } else if (ch == '&') {
                    buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                    out.write("&amp;");
                } else {
                    buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                }
            } else if (ch <= '\u00ff') {
                buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                out.write(38);
                out.write(sISO8859_1_Entities[ch - 160]);
                out.write(59);
            } else {
                buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                HtmlUtils._writeDecRef(out, ch);
            }
            ++i;
        }
        HtmlUtils.flushBuffer(out, buff, buffIndex);
    }

    public static void writeAttribute(Writer out, char[] buff, String text) throws IOException {
        int buffLength = buff.length;
        int buffIndex = 0;
        int length = text.length();
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            if (ch < '\u00a0') {
                if (ch >= '?') {
                    buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                } else if (ch >= '\'') {
                    if (ch < '<') {
                        buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                    } else if (ch == '>') {
                        buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                        out.write("&gt;");
                    } else {
                        buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                    }
                } else if (ch == '&') {
                    buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                    if (i + 1 < length && text.charAt(i + 1) == '{') {
                        out.write(ch);
                    } else {
                        out.write("&amp;");
                    }
                } else if (ch == '\"') {
                    buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                    out.write("&quot;");
                } else {
                    buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                }
            } else if (ch <= '\u00ff') {
                buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                out.write(38);
                out.write(sISO8859_1_Entities[ch - 160]);
                out.write(59);
            } else {
                buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                HtmlUtils._writeDecRef(out, ch);
            }
            ++i;
        }
        HtmlUtils.flushBuffer(out, buff, buffIndex);
    }

    public static void writeAttribute(Writer out, char[] buffer, char[] text) throws IOException {
        HtmlUtils.writeAttribute(out, buffer, text, 0, text.length);
    }

    public static void writeAttribute(Writer out, char[] buff, char[] text, int start, int length) throws IOException {
        int buffLength = buff.length;
        int buffIndex = 0;
        int end = start + length;
        int i = start;
        while (i < end) {
            char ch = text[i];
            if (ch < '\u00a0') {
                if (ch >= '?') {
                    buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                } else if (ch >= '\'') {
                    if (ch < '<') {
                        buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                    } else if (ch == '>') {
                        buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                        out.write("&gt;");
                    } else {
                        buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                    }
                } else if (ch == '&') {
                    buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                    if (i + 1 < end && text[i + 1] == '{') {
                        out.write(ch);
                    } else {
                        out.write("&amp;");
                    }
                } else if (ch == '\"') {
                    buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                    out.write("&quot;");
                } else {
                    buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                }
            } else if (ch <= '\u00ff') {
                buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                out.write(38);
                out.write(sISO8859_1_Entities[ch - 160]);
                out.write(59);
            } else {
                buffIndex = HtmlUtils.flushBuffer(out, buff, buffIndex);
                HtmlUtils._writeDecRef(out, ch);
            }
            ++i;
        }
        HtmlUtils.flushBuffer(out, buff, buffIndex);
    }

    private static void _writeDecRef(Writer out, char ch) throws IOException {
        if (ch == 8364) {
            out.write("&euro;");
            return;
        }
        out.write("&#");
        int i = ch;
        if (i > 10000) {
            out.write(48 + i / 10000);
            out.write(48 + (i %= 10000) / 1000);
            out.write(48 + (i %= 1000) / 100);
            out.write(48 + (i %= 100) / 10);
            out.write(48 + (i %= 10));
        } else if (i > 1000) {
            out.write(48 + i / 1000);
            out.write(48 + (i %= 1000) / 100);
            out.write(48 + (i %= 100) / 10);
            out.write(48 + (i %= 10));
        } else {
            out.write(48 + i / 100);
            out.write(48 + (i %= 100) / 10);
            out.write(48 + (i %= 10));
        }
        out.write(59);
    }

    private static int addToBuffer(Writer out, char[] buffer, int bufferIndex, int bufferLength, char ch) throws IOException {
        if (bufferIndex >= bufferLength) {
            out.write(buffer, 0, bufferIndex);
            bufferIndex = 0;
        }
        buffer[bufferIndex] = ch;
        return bufferIndex + 1;
    }

    private static int flushBuffer(Writer out, char[] buffer, int bufferIndex) throws IOException {
        if (bufferIndex > 0) {
            out.write(buffer, 0, bufferIndex);
        }
        return 0;
    }

    private HtmlUtils() {
    }

    public static void writeURL(Writer out, String text, String queryEncoding) throws IOException, UnsupportedEncodingException {
        int length = text.length();
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            if (ch < '!' || ch > '~') {
                if (ch == ' ') {
                    out.write(43);
                } else {
                    HtmlUtils.writeURIDoubleHex(out, ch);
                }
            } else if (ch == '\"') {
                out.write("%22");
            } else {
                if (ch == '?') {
                    out.write(63);
                    HtmlUtils.encodeURIString(out, text, queryEncoding, i + 1);
                    return;
                }
                out.write(ch);
            }
            ++i;
        }
    }

    private static void encodeURIString(Writer out, String text, String encoding, int start) throws IOException, UnsupportedEncodingException {
        ByteArrayOutputStream buf = null;
        OutputStreamWriter writer = null;
        char[] charArray = null;
        int length = text.length();
        int i = start;
        while (i < length) {
            block7: {
                char ch = text.charAt(i);
                if (DONT_ENCODE_SET.get(ch)) {
                    out.write(ch);
                } else {
                    if (buf == null) {
                        buf = new ByteArrayOutputStream(10);
                        writer = encoding != null ? new OutputStreamWriter((OutputStream)buf, encoding) : new OutputStreamWriter(buf);
                        charArray = new char[1];
                    }
                    try {
                        charArray[0] = ch;
                        writer.write(charArray, 0, 1);
                        writer.flush();
                    }
                    catch (IOException e) {
                        buf.reset();
                        break block7;
                    }
                    byte[] ba = buf.toByteArray();
                    int j = 0;
                    while (j < ba.length) {
                        HtmlUtils.writeURIDoubleHex(out, ba[j] + 256);
                        ++j;
                    }
                    buf.reset();
                }
            }
            ++i;
        }
    }

    private static void writeURIDoubleHex(Writer out, int i) throws IOException {
        out.write(37);
        out.write(HtmlUtils.intToHex((i >> 4) % 16));
        out.write(HtmlUtils.intToHex(i % 16));
    }

    private static char intToHex(int i) {
        if (i < 10) {
            return (char)(48 + i);
        }
        return (char)(65 + (i - 10));
    }

    public static void validateEncoding(String encoding) throws UnsupportedEncodingException {
        if (encoding != null) {
            new String(encodingTestBytes, encoding);
        }
    }

    public static boolean isEmptyElement(String name) {
        char firstChar = name.charAt(0);
        if (firstChar > _LAST_EMPTY_ELEMENT_START) {
            return false;
        }
        String[] array = emptyElementArr[name.charAt(0)];
        if (array != null) {
            int i = array.length - 1;
            while (i >= 0) {
                if (name.equalsIgnoreCase(array[i])) {
                    return true;
                }
                --i;
            }
        }
        return false;
    }

    static {
        int i = 97;
        while (i <= 122) {
            DONT_ENCODE_SET.set(i);
            ++i;
        }
        int i2 = 65;
        while (i2 <= 90) {
            DONT_ENCODE_SET.set(i2);
            ++i2;
        }
        int i3 = 48;
        while (i3 <= 57) {
            DONT_ENCODE_SET.set(i3);
            ++i3;
        }
        DONT_ENCODE_SET.set(37);
        DONT_ENCODE_SET.set(43);
        DONT_ENCODE_SET.set(35);
        DONT_ENCODE_SET.set(38);
        DONT_ENCODE_SET.set(61);
        DONT_ENCODE_SET.set(45);
        DONT_ENCODE_SET.set(95);
        DONT_ENCODE_SET.set(46);
        DONT_ENCODE_SET.set(42);
        DONT_ENCODE_SET.set(126);
        DONT_ENCODE_SET.set(47);
        DONT_ENCODE_SET.set(39);
        DONT_ENCODE_SET.set(33);
        DONT_ENCODE_SET.set(40);
        DONT_ENCODE_SET.set(41);
        sISO8859_1_Entities = new String[]{"nbsp", "iexcl", "cent", "pound", "curren", "yen", "brvbar", "sect", "uml", "copy", "ordf", "laquo", "not", "shy", "reg", "macr", "deg", "plusmn", "sup2", "sup3", "acute", "micro", "para", "middot", "cedil", "sup1", "ordm", "raquo", "frac14", "frac12", "frac34", "iquest", "Agrave", "Aacute", "Acirc", "Atilde", "Auml", "Aring", "AElig", "Ccedil", "Egrave", "Eacute", "Ecirc", "Euml", "Igrave", "Iacute", "Icirc", "Iuml", "ETH", "Ntilde", "Ograve", "Oacute", "Ocirc", "Otilde", "Ouml", "times", "Oslash", "Ugrave", "Uacute", "Ucirc", "Uuml", "Yacute", "THORN", "szlig", "agrave", "aacute", "acirc", "atilde", "auml", "aring", "aelig", "ccedil", "egrave", "eacute", "ecirc", "euml", "igrave", "iacute", "icirc", "iuml", "eth", "ntilde", "ograve", "oacute", "ocirc", "otilde", "ouml", "divide", "oslash", "ugrave", "uacute", "ucirc", "uuml", "yacute", "thorn", "yuml"};
        encodingTestBytes = new byte[]{65};
        _LAST_EMPTY_ELEMENT_START = (char)112;
        emptyElementArr = new String[_LAST_EMPTY_ELEMENT_START + '\u0001'][];
        aNames = new String[]{"area"};
        bNames = new String[]{"br", "base", "basefont"};
        cNames = new String[]{"col"};
        fNames = new String[]{"frame"};
        hNames = new String[]{"hr"};
        iNames = new String[]{"img", "input", "isindex"};
        lNames = new String[]{"link"};
        mNames = new String[]{"meta"};
        pNames = new String[]{"param"};
        HtmlUtils.emptyElementArr[97] = aNames;
        HtmlUtils.emptyElementArr[65] = aNames;
        HtmlUtils.emptyElementArr[98] = bNames;
        HtmlUtils.emptyElementArr[66] = bNames;
        HtmlUtils.emptyElementArr[99] = cNames;
        HtmlUtils.emptyElementArr[67] = cNames;
        HtmlUtils.emptyElementArr[102] = fNames;
        HtmlUtils.emptyElementArr[70] = fNames;
        HtmlUtils.emptyElementArr[104] = hNames;
        HtmlUtils.emptyElementArr[72] = hNames;
        HtmlUtils.emptyElementArr[105] = iNames;
        HtmlUtils.emptyElementArr[73] = iNames;
        HtmlUtils.emptyElementArr[108] = lNames;
        HtmlUtils.emptyElementArr[76] = lNames;
        HtmlUtils.emptyElementArr[109] = mNames;
        HtmlUtils.emptyElementArr[77] = mNames;
        HtmlUtils.emptyElementArr[112] = pNames;
        HtmlUtils.emptyElementArr[80] = pNames;
    }
}

