/**
 * Copyright (c) 2019-2021 Red Hat, Inc.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Red Hat, Inc. - initial API and implementation
 */
export declare const CHE_REPO = "che-server";
export declare const CHE_OPERATOR_REPO = "codeready-operator";
export interface TagInfo {
    name: string;
    commit: {
        sha: string;
        url: string;
    };
    zipball_url: string;
}
export declare class CheGithubClient {
    private readonly octokit;
    constructor();
    /**
     * Returns version (tag) information based on installer and version string (e.g. 7.19.2).
     */
    getTemplatesTagInfo(installer: string, version?: string): Promise<TagInfo | undefined>;
    /**
     * Gets last 50 tags from the given repository.
     * @param repo repository name to list tag in
     * @param prefix return only tags that starts with given prefix
     */
    private listLatestTags;
    /**
     * Gets tag info if it exists.
     * @param repo repository name to search for the tag in
     * @param tagName name of the tag
     */
    private getTag;
    /**
     * Returns latest commit information in tag format.
     * @param repo repository name to get the latest commit from
     */
    private getLastCommitInfo;
    /**
     * Returns tag/commit information about given version.
     * The informaton includes zip archive download link.
     * If non-existing version is given, then undefined will be returned.
     * @param repo repository name
     * @param version version or version prefix. If only prefix is given, the latest one that match will be choosen.
     */
    private getTagInfoByVersion;
    /**
     * Helper for getTagInfoByVersion
     * Gets tag by exact match or latest tag with given prefix
     * @param repo repository name
     * @param versionPrefix version or version prefix, e.g. 7.22.0 or 7.18
     */
    private getTagInfoByVersionPrefix;
    /**
     * Finds the latest tag of format x.y.z, where x,y and z are numbers.
     * @param tags repository tags list returned by octokit
     */
    getLatestTag(tags: TagInfo[]): TagInfo;
    /**
     * Sorts given tags. First is the latest.
     * All tags should use semantic versioning in form x.y.z, where x,y and z are numbers.
     * If a tag is not in the descrbed above format, it will be ignored.
     * @param tags list of tags to sort
     */
    private sortSemanticTags;
}
