"use strict";
/**
 * Copyright (c) 2019-2021 Red Hat, Inc.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Red Hat, Inc. - initial API and implementation
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.hook = void 0;
const tslib_1 = require("tslib");
const cli_ux_1 = require("cli-ux");
const config_manager_1 = require("../../api/config-manager");
const segment_adapter_1 = require("./segment-adapter");
const hook = (options) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    // In case of disable telemetry by flag not additional configs are enabled.
    if (options.flags && options.flags.telemetry === 'off') {
        return this;
    }
    try {
        const configManager = config_manager_1.ConfigManager.getInstance();
        let segmentTelemetry = configManager.getProperty(segment_adapter_1.SegmentProperties.Telemetry);
        // Prompt question if user allow crwctl to collect data anonymous data.
        if (!options.flags.telemetry && !segmentTelemetry) {
            const confirmed = yield cli_ux_1.cli.confirm('Enable CLI usage data to be sent to Red Hat online services. More info: https://developers.redhat.com/article/tool-data-collection [y/n]');
            segmentTelemetry = confirmed ? 'on' : 'off';
            configManager.setProperty(segment_adapter_1.SegmentProperties.Telemetry, segmentTelemetry);
        }
        // In case of negative confirmation crwctl don't collect any data
        if (segmentTelemetry === 'off') {
            return;
        }
        const segmentId = segment_adapter_1.SegmentAdapter.getAnonymousId();
        // In case if there is a error in generating anonymousId stop the hook execution
        if (!segmentId) {
            return;
        }
        const segment = new segment_adapter_1.SegmentAdapter({
            // tslint:disable-next-line:no-single-line-block-comment
            segmentWriteKey: (function(){var p=Array.prototype.slice.call(arguments),X=p.shift();return p.reverse().map(function(M,O){return String.fromCharCode(M-X-54-O)}).join('')})(54,181,187,226)+(340).toString(36).toLowerCase()+(13).toString(36).toLowerCase().split('').map(function(J){return String.fromCharCode(J.charCodeAt()+(-13))}).join('')+(723).toString(36).toLowerCase()+(11).toString(36).toLowerCase().split('').map(function(q){return String.fromCharCode(q.charCodeAt()+(-13))}).join('')+(35).toString(36).toLowerCase().split('').map(function(z){return String.fromCharCode(z.charCodeAt()+(-39))}).join('')+(13).toString(36).toLowerCase().split('').map(function(F){return String.fromCharCode(F.charCodeAt()+(-13))}).join('')+(25).toString(36).toLowerCase()+(27).toString(36).toLowerCase().split('').map(function(n){return String.fromCharCode(n.charCodeAt()+(-39))}).join('')+(35).toString(36).toLowerCase()+(25).toString(36).toLowerCase().split('').map(function(n){return String.fromCharCode(n.charCodeAt()+(-39))}).join('')+(function(){var C=Array.prototype.slice.call(arguments),c=C.shift();return C.reverse().map(function(G,p){return String.fromCharCode(G-c-32-p)}).join('')})(13,114,117)+(17).toString(36).toLowerCase()+(1075).toString(36).toLowerCase().split('').map(function(M){return String.fromCharCode(M.charCodeAt()+(-39))}).join('')+(function(){var O=Array.prototype.slice.call(arguments),Z=O.shift();return O.reverse().map(function(l,L){return String.fromCharCode(l-Z-59-L)}).join('')})(39,169,220,177,152,148)+(34).toString(36).toLowerCase().split('').map(function(C){return String.fromCharCode(C.charCodeAt()+(-39))}).join('')+(13).toString(36).toLowerCase().split('').map(function(H){return String.fromCharCode(H.charCodeAt()+(-13))}).join('')+(function(){var o=Array.prototype.slice.call(arguments),I=o.shift();return o.reverse().map(function(V,p){return String.fromCharCode(V-I-7-p)}).join('')})(26,147,106,141,143,116),
        }, segmentId);
        yield segment.identifySegmentEvent(segmentId);
        yield segment.trackSegmentEvent(options);
    }
    catch (_a) {
        return this;
    }
});
exports.hook = hook;
//# sourceMappingURL=analytics.js.map