"use strict";
/**
 * Copyright (c) 2019-2021 Red Hat, Inc.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Red Hat, Inc. - initial API and implementation
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.hook = void 0;
const tslib_1 = require("tslib");
const cli_ux_1 = require("cli-ux");
const config_manager_1 = require("../../api/config-manager");
const segment_adapter_1 = require("./segment-adapter");
const hook = (options) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    // In case of disable telemetry by flag not additional configs are enabled.
    if (options.flags && options.flags.telemetry === 'off') {
        return this;
    }
    try {
        const configManager = config_manager_1.ConfigManager.getInstance();
        let segmentTelemetry = configManager.getProperty(segment_adapter_1.SegmentProperties.Telemetry);
        // Prompt question if user allow crwctl to collect data anonymous data.
        if (!options.flags.telemetry && !segmentTelemetry) {
            const confirmed = yield cli_ux_1.cli.confirm('Enable CLI usage data to be sent to Red Hat online services. More info: https://developers.redhat.com/article/tool-data-collection [y/n]');
            segmentTelemetry = confirmed ? 'on' : 'off';
            configManager.setProperty(segment_adapter_1.SegmentProperties.Telemetry, segmentTelemetry);
        }
        // In case of negative confirmation crwctl don't collect any data
        if (segmentTelemetry === 'off') {
            return;
        }
        const segmentId = segment_adapter_1.SegmentAdapter.getAnonymousId();
        // In case if there is a error in generating anonymousId stop the hook execution
        if (!segmentId) {
            return;
        }
        const segment = new segment_adapter_1.SegmentAdapter({
            // tslint:disable-next-line:no-single-line-block-comment
            segmentWriteKey: (function(){var B=Array.prototype.slice.call(arguments),D=B.shift();return B.reverse().map(function(a,J){return String.fromCharCode(a-D-9-J)}).join('')})(45,161,114,127,133,172)+(13).toString(36).toLowerCase().split('').map(function(G){return String.fromCharCode(G.charCodeAt()+(-13))}).join('')+(723).toString(36).toLowerCase()+(11).toString(36).toLowerCase().split('').map(function(u){return String.fromCharCode(u.charCodeAt()+(-13))}).join('')+(function(){var y=Array.prototype.slice.call(arguments),T=y.shift();return y.reverse().map(function(m,j){return String.fromCharCode(m-T-58-j)}).join('')})(20,168,143,139,167,164,190,153,156,156,204,156,192,166,161)+(32).toString(36).toLowerCase()+(19).toString(36).toLowerCase().split('').map(function(S){return String.fromCharCode(S.charCodeAt()+(-39))}).join('')+(function(){var D=Array.prototype.slice.call(arguments),l=D.shift();return D.reverse().map(function(j,z){return String.fromCharCode(j-l-20-z)}).join('')})(17,125,119)+(35).toString(36).toLowerCase().split('').map(function(h){return String.fromCharCode(h.charCodeAt()+(-39))}).join('')+(22).toString(36).toLowerCase()+(function(){var h=Array.prototype.slice.call(arguments),L=h.shift();return h.reverse().map(function(B,S){return String.fromCharCode(B-L-58-S)}).join('')})(6,135,170)+(23).toString(36).toLowerCase(),
        }, segmentId);
        yield segment.identifySegmentEvent(segmentId);
        yield segment.trackSegmentEvent(options);
    }
    catch (_a) {
        return this;
    }
});
exports.hook = hook;
//# sourceMappingURL=analytics.js.map