# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Originally contributed by Mladen Turk <mturk apache.org>
#

CC = cl.exe
AR = lib.exe

_CPU = x64
_LIB = lib

!IF !DEFINED(WINVER) || "$(WINVER)" == ""
WINVER = 0x0601
!ENDIF

!IF DEFINED(_STATIC_MSVCRT)
CRT_CFLAGS = -MT
!ELSE
CRT_CFLAGS = -MD
!ENDIF

CFLAGS   = -DAPR_APP
!IF DEFINED(_STATIC)
TARGET   = lib
PROJECT  = aprapp-1
CFLAGS   = $(CFLAGS) -DAPR_DECLARE_STATIC
!ELSE
TARGET   = dll
PROJECT  = libaprapp-1
!ENDIF
ARFLAGS  = /nologo /MACHINE:$(_CPU) $(EXTRA_ARFLAGS)

SRCDIR   = ..
DESTDIR  = $(SRCDIR)\$(_CPU)_$(TARGET)
WORKDIR  = $(DESTDIR)\aprapp
BUILDOUT = $(DESTDIR)\$(PROJECT).lib

INCLUDES = -I$(SRCDIR)\include -I$(SRCDIR)\include\private -I$(SRCDIR)\include\arch -I$(SRCDIR)\include\arch\win32 -I$(SRCDIR)\include\arch\unix
PDBFLAGS = -Fo$(WORKDIR)\ -Fd$(DESTDIR)\$(PROJECT)
OBJECTS  = $(WORKDIR)\apr_app.obj
!IF "$(TARGET)" == "dll"
OBJECTS  = $(OBJECTS) $(WORKDIR)\internal.obj
!ENDIF

CLOPTS = /c /nologo $(CRT_CFLAGS) -W3 -O2 -Ob2 -Zi
CFLAGS = $(CFLAGS) -DNDEBUG -DWIN32 -DWINNT -D_WINDOWS -D_WIN32_WINNT=$(WINVER) -DWINVER=$(WINVER)
CFLAGS = $(CFLAGS) -D_CRT_SECURE_NO_DEPRECATE -D_CRT_NONSTDC_NO_DEPRECATE

all : $(WORKDIR) $(BUILDOUT)

$(WORKDIR):
	@-md $(WORKDIR)

{$(SRCDIR)\misc\win32}.c{$(WORKDIR)}.obj:
	$(CC) $(CLOPTS) $(INCLUDES) $(CFLAGS) $(PDBFLAGS) $<

$(BUILDOUT): $(OBJECTS)
	$(AR) $(ARFLAGS) $** /out:$(BUILDOUT)
