<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1701771 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_socache_memcache.xml.meta">

<name>mod_socache_memcache</name>
<description>Fournisseur de cache d'objets partag&eacute;s bas&eacute; sur Memcache.</description>
<status>Extension</status>
<sourcefile>mod_socache_memcache.c</sourcefile>
<identifier>socache_memcache_module</identifier>

<summary>
    <p>Le module <code>mod_socache_memcache</code> est un fournisseur de cache
    d'objets partag&eacute;s qui permet la cr&eacute;ation et l'acc&egrave;s &agrave; un cache
    maintenu par le syst&egrave;me de mise en cache d'objets en m&eacute;moire
    distribu&eacute;e &agrave; hautes performances <a
    href="http://memcached.org/">memcached</a>.
    </p>

    <p>Cette m&eacute;thode "create" du fournisseur de cache d'objets partag&eacute;s
    requiert une liste de sp&eacute;cifications h&ocirc;te/port en cache m&eacute;moire
    s&eacute;par&eacute;es par des virgules. Si vous utilisez ce fournisseur
    dans la configuration d'autres modules (comme
    <directive module="mod_ssl">SSLSessionCache</directive>), vous devez
    fournir la liste des serveurs sous la forme du param&egrave;tre optionnel
    "arg".</p>

     <highlight language="config">
         SSLSessionCache memcache:memcache.example.com:12345,memcache2.example.com:12345
     </highlight>

    <p>Vous trouverez des d&eacute;tails &agrave; propos des autres fournisseurs de
    cache d'objets partag&eacute;s <a href="../socache.html">ici</a>.
    </p>

</summary>

<directivesynopsis>
<name>MemcacheConnTTL</name>
<description>Dur&eacute;e de conservation des connexions inactives</description>
<syntax>MemcacheConnTTL <em>num[units]</em></syntax>
<default>MemcacheConnTTL 15s</default>
<contextlist>
<context>server config</context>
<context>virtual host</context>
</contextlist>
<compatibility>Disponible &agrave; partir de la version 2.4.17 du serveur HTTP
Apache.</compatibility>

<usage>

    <p>D&eacute;finit la dur&eacute;e pendant laquelle les connexions
    inactives avec le(s) serveur(s) memcache seront conserv&eacute;es
    (plateformes thread&eacute;es seulement).</p>
    
    <p>Les valeurs valides de la directive
    <directive>MemcacheConnTTL</directive> sont des dur&eacute;es d'une heure
    maximum. La valeur 0 signifie une absence de p&eacute;remption</p>

    <note><p>L'unit&eacute; par d&eacute;faut pour ce d&eacute;lai est la seconde, mais vous
    pouvez ajouter un suffixe pour sp&eacute;cifier une unit&eacute; diff&eacute;rente ; ms
    pour milliseconde, s pour seconde, min pour minute et h pour heure..
    </p></note>

    <p>Dans les versions ant&eacute;rieures &agrave; 2.4.17, ce d&eacute;lai &eacute;tait cod&eacute; en
    dur et sa valeur &eacute;tait 600 microsecondes. La valeur la plus proche
    de cette ancienne valeur pour la directive
    <directive>MemcacheConnTTL</directive> est donc 1ms.</p>

    <example>
    <highlight language="config">
# D&eacute;finition d'un d&eacute;lai de 10 minutes
MemcacheConnTTL 10min
# D&eacute;finition d'un d&eacute;lai de 60 secondes
MemcacheConnTTL 60
    </highlight>
    </example>

</usage>
</directivesynopsis>

</modulesynopsis>
