<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1738542 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviwed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="auth.xml.meta">
<parentdocument href="./">Recettes / Tutoriels</parentdocument>

<title>Authentification et autorisation</title>

<summary>
    <p>L'authentification est un processus qui vous permet de vérifier
    qu'une personne est bien celle qu'elle prétend être. L'autorisation
    est un processus qui permet à une personne d'aller là où elle veut
    aller, ou d'obtenir les informations qu'elle désire.</p>

    <p>Pour le contrôle d'accès en général, voir le How-To <a
    href="access.html">Contrôle d'accès</a>.</p>
</summary>

<section id="related"><title>Modules et directives concernés</title>

<p>Trois groupes de modules sont concernés par le processus
d'authentification et d'autorisation. Vous devrez utiliser au moins un
module de chaque groupe.</p>

<ul>
  <li>Type d'authentification (voir la directive <directive
  module="mod_authn_core">AuthType</directive>)
    <ul>
      <li><module>mod_auth_basic</module></li>
      <li><module>mod_auth_digest</module></li>
    </ul>
  </li>
  <li>Fournisseur d'authentification (voir les directives <directive
  module="mod_auth_basic">AuthBasicProvider</directive> et <directive
  module="mod_auth_digest">AuthDigestProvider</directive>)

    <ul>
      <li><module>mod_authn_anon</module></li>
      <li><module>mod_authn_dbd</module></li>
      <li><module>mod_authn_dbm</module></li>
      <li><module>mod_authn_file</module></li>
      <li><module>mod_authnz_ldap</module></li>
      <li><module>mod_authn_socache</module></li>
    </ul>
  </li>
  <li>Autorisation (voir la directive <directive
  module="mod_authz_core">Require</directive>)
    <ul>
      <li><module>mod_authnz_ldap</module></li>
      <li><module>mod_authz_dbd</module></li>
      <li><module>mod_authz_dbm</module></li>
     <li><module>mod_authz_groupfile</module></li>
      <li><module>mod_authz_host</module></li>
      <li><module>mod_authz_owner</module></li>
      <li><module>mod_authz_user</module></li>
    </ul>
  </li>
</ul>

  <p>On peut aussi ajouter <module>mod_authn_core</module> et
  <module>mod_authz_core</module>. Ces modules implémentent des
  directives générales qui opèrent au dessus de tous les modules
  d'authentification.</p>

  <p>Le module <module>mod_authnz_ldap</module> est un fournisseur
  d'authentification et d'autorisation. Le module
  <module>mod_authz_host</module> fournit une autorisation et un
  contrôle d'accès basés sur le nom du serveur, l'adresse IP ou
  certaines caractéristiques de la requête, mais ne fait pas partie du
  système fournisseur d'authentification. Le module
  <module>mod_access_compat</module> a été créé à des fins de
  compatibilité ascendante avec mod_access.</p>

  <p>Vous devriez aussi jeter un coup d'oeil au manuel de recettes de <a
  href="access.html">Contrôle d'accès</a>, qui décrit les différentes
  méthodes de contrôle d'accès à votre serveur.</p>

</section>

<section id="introduction"><title>Introduction</title>
    <p>Si votre site web contient des informations sensibles ou
    destinées seulement à un groupe de personnes restreint, les
    techniques exposées dans cet article vont vous aider à vous assurer
    que les personnes qui ont accès à ces pages sont bien celles
    auxquelles vous avez donné l'autorisation d'accès.</p>

    <p>Cet article décrit les méthodes "standards" de protection de
    parties de votre site web que la plupart d'entre vous sont appelés à
    utiliser.</p>

    <note><title>Note :</title>
    <p>Si vos données ont un réel besoin de sécurisation, prévoyez
    l'utilisation de <module>mod_ssl</module> en plus de toute méthode
    d'authentification.</p>
    </note>
</section>

<section id="theprerequisites"><title>Les prérequis</title>
    <p>Les directives décrites dans cet article devront être insérées
    soit au niveau de la configuration de votre serveur principal (en
    général dans une section <directive module="core"
    type="section">Directory</directive>), soit au niveau de la
    configuration des répertoires (fichiers <code>.htaccess</code>)</p>

    <p>Si vous envisagez l'utilisation de fichiers
    <code>.htaccess</code>, la configuration de votre serveur devra
    permettre l'ajout de directives d'authentification dans ces
    fichiers. Pour ce faire, on utilise la directive <directive
    module="core">AllowOverride</directive>, qui spécifie quelles
    directives pourront éventuellement contenir les fichiers de
    configuration de niveau répertoire.</p>

    <p>Comme il est ici question d'authentification, vous aurez besoin
    d'une directive <directive module="core">AllowOverride</directive>
    du style :</p>

    <highlight language="config">AllowOverride AuthConfig</highlight>

    <p>Si vous avez l'intention d'ajouter les directives directement
    dans le fichier de configuration principal, vous devrez bien entendu
    posséder les droits en écriture sur ce fichier.</p>

    <p>Vous devrez aussi connaître un tant soit peu la structure des
    répertoires de votre serveur, ne serait-ce que pour savoir où se
    trouvent certains fichiers. Cela ne devrait pas présenter de grandes
    difficultés, et nous essaierons de clarifier tout ça lorsque le besoin
    s'en fera sentir.</p>

    <p>Enfin, vous devrez vous assurer que les modules
    <module>mod_authn_core</module> et <module>mod_authz_core</module>
    ont été soit compilés avec le binaire httpd, soit chargés par le
    fichier de configuration httpd.conf. Ces deux modules fournissent
    des directives générales et des fonctionnalités qui sont critiques
    quant à la configuration et l'utilisation de l'authentification et
    de l'autorisation au sein du serveur web.</p>
</section>

<section id="gettingitworking"><title>Mise en oeuvre</title>
    <p>Nous décrivons ici les bases de la protection par mot de passe
    d'un répertoire de votre serveur.</p>

    <p>Vous devez en premier lieu créer un fichier de mots de passe. La
    méthode exacte selon laquelle vous allez créer ce fichier va varier
    en fonction du fournisseur d'authentification choisi. Mais nous
    entrerons dans les détails plus loin, et pour le moment, nous nous
    contenterons d'un fichier de mots de passe en mode texte.</p>

    <p>Ce fichier doit être enregistré à un endroit non accessible
    depuis le web, de façon à ce que les clients ne puissent pas le
    télécharger. Par exemple, si vos documents sont servis à partir de
    <code>/usr/local/apache/htdocs</code>, vous pouvez enregistrer le
    fichier des mots de passe dans
    <code>/usr/local/apache/passwd</code>.</p>

    <p>L'utilitaire <program>htpasswd</program> fourni avec Apache
    permet de créer ce fichier. Vous le trouverez dans le répertoire
    <code>bin</code> de votre installation d'Apache. Si vous avez
    installé Apache à partir d'un paquetage tiers, il sera probablement
    dans le chemin par défaut de vos exécutables.</p>

    <p>Pour créer le fichier, tapez :</p>

    <example>
      htpasswd -c /usr/local/apache/passwd/passwords rbowen
    </example>

    <p><program>htpasswd</program> vous demandera d'entrer le mot de
    passe, et de le retaper pour confirmation :</p>

    <example>
      # htpasswd -c /usr/local/apache/passwd/passwords rbowen<br />
      New password: mot-de-passe<br />
      Re-type new password: mot-de-passe<br />
      Adding password for user rbowen
    </example>

    <p>Si <program>htpasswd</program> n'est pas dans le chemin par
    défaut de vos exécutables, vous devrez bien entendu entrer le chemin
    complet du fichier. Dans le cas d'une installation par défaut, il se
    trouve à <code>/usr/local/apache2/bin/htpasswd</code>.</p>

    <p>Ensuite, vous allez devoir configurer le serveur de façon à ce
    qu'il demande un mot de passe et lui préciser quels utilisateurs ont
    l'autorisation d'accès. Pour ce faire, vous pouvez soit éditer le
    fichier <code>httpd.conf</code>, soit utiliser un fichier
    <code>.htaccess</code>. Par exemple, si vous voulez protéger le
    répertoire <code>/usr/local/apache/htdocs/secret</code>, vous pouvez
    utiliser les directives suivantes, soit dans le fichier
    <code>/usr/local/apache/htdocs/secret/.htaccess</code>, soit dans le
    fichier <code>httpd.conf</code> à l'intérieur d'une section &lt;Directory
    "/usr/local/apache/htdocs/secret"&gt; :</p>

    <highlight language="config">
AuthType Basic
AuthName "Restricted Files"
# (Following line optional)
AuthBasicProvider file
AuthUserFile "/usr/local/apache/passwd/passwords"
Require user rbowen
    </highlight>

    <p>Examinons ces directives une à une. La directive <directive
    module="mod_authn_core">AuthType</directive> définit la méthode
    utilisée pour authentifier l'utilisateur. La méthode la plus
    courante est <code>Basic</code>, et elle est implémentée par
    <module>mod_auth_basic</module>. Il faut cependant garder à l'esprit
    que l'authentification Basic transmet le mot de passe depuis le
    client vers le serveur en clair. Cette méthode ne devra donc pas
    être utilisée pour la transmission de données hautement sensibles si
    elle n'est pas associée au module <module>mod_ssl</module>. Apache
    supporte une autre méthode d'authentification : <code>AuthType
    Digest</code>. Cette méthode est implémentée par le module <module
    >mod_auth_digest</module> et a été conçue pour
    améliorer la sécurité. Ce but n'a cependant pas été atteint et il est préférable
    de chiffrer la connexion avec <module>mod_ssl</module>.</p>

    <p>La directive <directive
    module="mod_authn_core">AuthName</directive> définit
    l'<dfn>Identificateur</dfn> (Realm) à utiliser avec
    l'authentification. L'identificateur possède deux fonctions. Tout
    d'abord, le client présente en général cette information à
    l'utilisateur dans le cadre de la boîte de dialogue de mot de passe.
    Ensuite, le client l'utilise pour déterminer quel mot de passe
    envoyer pour une zone authentifiée donnée.</p>

    <p>Ainsi par exemple, une fois un client authentifié dans la zone
    <code>"Fichiers réservés"</code>, il soumettra à nouveau
    automatiquement le même mot de passe pour toute zone du même serveur
    marquée de l'identificateur <code>"Fichiers réservés"</code>. De
    cette façon, vous pouvez éviter à un utilisateur d'avoir à saisir
    plusieurs fois le même mot de passe en faisant partager le même
    identificateur entre plusieurs zones réservées. Bien entendu et pour
    des raisons de sécurité, le client devra redemander le mot
    de passe chaque fois que le nom d'hôte du serveur sera modifié.</p>

    <p>La directive <directive
    module="mod_auth_basic">AuthBasicProvider</directive> est, dans ce
    cas, facultative, car <code>file</code> est la valeur par défaut
    pour cette directive. Par contre, cette directive sera obligatoire
    si vous utilisez une autre source d'authentification comme
    <module>mod_authn_dbm</module> ou
    <module>mod_authn_dbd</module>.</p>

    <p>La directive <directive
    module="mod_authn_file">AuthUserFile</directive> définit le chemin
    du fichier de mots de passe que nous venons de créer avec
    <program>htpasswd</program>. Si vous possédez un grand nombre
    d'utilisateurs, la durée de la recherche dans un fichier texte pour
    authentifier un utilisateur à chaque requête va augmenter
    rapidement, et pour pallier cet inconvénient, Apache peut aussi
    stocker les données relatives aux
    utilisateurs dans des bases de données rapides. Le module
    <module>mod_authn_dbm</module> fournit la directive <directive
    module="mod_authn_dbm">AuthDBMUserFile</directive>. Les programmes <program>
    dbmmanage</program> et <program>htdbm</program> permettent de
    créer et manipuler ces fichiers. Vous
    trouverez de nombreuses options d'autres types d'authentification
    fournies par des modules tiers dans la <a
    href="http://modules.apache.org/">Base de données des modules
    d'Apache</a>.</p>

    <p>Enfin, la directive <directive
    module="mod_authz_core">Require</directive> implémente la partie
    autorisation du processus en définissant l'utilisateur autorisé à
    accéder à cette zone du serveur. Dans la section suivante, nous
    décrirons les différentes méthodes d'utilisation de la directive
    <directive module="mod_authz_core">Require</directive>.</p>
</section>

<section id="lettingmorethanonepersonin"><title>Autorisation d'accès à
plusieurs personnes</title>
    <p>Les directives ci-dessus n'autorisent qu'une personne (quelqu'un
    possédant le nom d'utilisateur <code>rbowen</code>) à accéder au
    répertoire. Dans la plupart des cas, vous devrez autoriser
    l'accès à plusieurs personnes. C'est ici
    qu'intervient la directive <directive module="mod_authz_groupfile"
    >AuthGroupFile</directive>.</p>

    <p>Si vous voulez autoriser l'accès à plusieurs personnes, vous
    devez créer un fichier de groupes qui associe des noms de groupes
    avec une liste d'utilisateurs de ce groupe. Le format de ce fichier
    est très simple, et vous pouvez le créer avec votre éditeur favori.
    Son contenu se présente comme suit :</p>

   <example>
     Nom-de-groupe: rbowen dpitts sungo rshersey
   </example>

    <p>Il s'agit simplement une liste des membres du groupe sous la
    forme d'une ligne séparée par des espaces.</p>

    <p>Pour ajouter un utilisateur à votre fichier de mots de passe
    préexistant, entrez :</p>

    <example>
      htpasswd /usr/local/apache/passwd/passwords dpitts
    </example>

    <p>Vous obtiendrez le même effet qu'auparavant, mais le mot de passe
    sera ajouté au fichier, plutôt que d'en créer un nouveau (C'est le
    drapeau <code>-c</code> qui permet de créer un nouveau fichier de
    mots de passe)..</p>

    <p>Maintenant, vous devez modifier votre fichier
    <code>.htaccess</code> ou la section <directive module="core"
    type="section">Directory</directive> comme suit :</p>

    <highlight language="config">
AuthType Basic
AuthName "By Invitation Only"
# Optional line:
AuthBasicProvider file
AuthUserFile "/usr/local/apache/passwd/passwords"
AuthGroupFile "/usr/local/apache/passwd/groups"
Require group GroupName
    </highlight>

    <p>Maintenant, quiconque appartient au groupe
    <code>Nom-de-groupe</code>, et possède une entrée dans le fichier
    <code>password</code> pourra accéder au répertoire s'il tape le bon
    mot de passe.</p>

    <p>Il existe une autre méthode moins contraignante pour autoriser
    l'accès à plusieurs personnes. Plutôt que de créer un fichier de
    groupes, il vous suffit d'ajouter la directive suivante :</p>

    <highlight language="config">Require valid-user</highlight>

    <p>Le remplacement de la ligne <code>Require user rbowen</code> par
    la ligne <code>Require valid-user</code> autorisera l'accès à
    quiconque possédant une entrée dans le fichier password, et ayant
    tapé le bon mot de passe.</p>
</section>

<section id="possibleproblems"><title>Problèmes possibles</title>
    <p>L'authentification Basic est spécifiée d'une telle manière que
    vos nom d'utilisateur et mot de passe doivent être vérifiés chaque
    fois que vous demandez un document au serveur, et ceci même si vous
    rechargez la même page, et pour chaque image contenue dans la page
    (si elles sont situées dans un répertoire protégé). Comme vous
    pouvez l'imaginer, ceci ralentit un peu le fonctionnement. La mesure
    dans laquelle le fonctionnement est ralenti est proportionnelle à la
    taille du fichier des mots de passe, car ce dernier doit être ouvert
    et la liste des utilisateurs parcourue jusqu'à ce que votre nom soit
    trouvé, et ceci chaque fois qu'une page est chargée.</p>

    <p>En conséquence, ce ralentissement impose une limite pratique au
    nombre d'utilisateurs que vous pouvez enregistrer dans un fichier de
    mots de passe. Cette limite va varier en fonction des performances
    de votre serveur, mais vous commencerez à remarquer un
    ralentissement lorsque vous atteindrez quelques centaines
    d'utilisateurs, et serez alors appelés à utiliser une méthode
    d'authentification différente.</p>
</section>

<section id="dbmdbd"><title>Autre méthode de stockage des mots de
passe</title>

    <p>Suite au problème évoqué précédemment et induit par le stockage
    des mots de passe dans un fichier texte, vous pouvez être appelé à
    stocker vos mots de passe d'une autre manière, par exemple dans une
    base de données.</p>

    <p>Pour y parvenir, on peut utiliser les modules
    <module>mod_authn_dbm</module> ou <module>mod_authn_dbd</module>.
    Vous pouvez choisir comme format de stockage <code>dbm</code> ou
    <code>dbd</code> à la place de <code>file</code> pour la directive
    <directive module="mod_auth_basic">AuthBasicProvider</directive>.</p>

    <p>Par exemple, pour sélectionner un fichier dbm à la place d'un
    fichier texte :</p>

    <highlight language="config">
&lt;Directory "/www/docs/private"&gt;

    AuthName "Private"
    AuthType Basic
    AuthBasicProvider dbm
    AuthDBMUserFile "/www/passwords/passwd.dbm"
    Require valid-user

&lt;/Directory&gt;
    </highlight>

    <p>D'autres options sont disponibles. Consultez la documentation de
    <module>mod_authn_dbm</module> pour plus de détails.</p>
</section>

<section id="multprovider"><title>Utilisation de plusieurs fournisseurs
d'authentification</title>

    <p>Depuis l'arrivée des nouvelles architecture d'autorisation et
    d'authentification basées sur les fournisseurs, vous n'êtes plus
    limité à une méthode d'authentification et d'autorisation
    unique. En fait, on peut panacher autant de fournisseurs que l'on
    veut, ce qui vous permet d'élaborer l'architecture qui correspond
    exactement à vos besoins. Dans l'exemple suivant, on utilise
    conjointement les fournisseurs d'authentification
    file et LDAP :</p>

    <highlight language="config">
&lt;Directory "/www/docs/private"&gt;

    AuthName "Private"
    AuthType Basic
    AuthBasicProvider file ldap
    AuthUserFile "/usr/local/apache/passwd/passwords"
    AuthLDAPURL ldap://ldaphost/o=yourorg
    Require valid-user

&lt;/Directory&gt;
    </highlight>

    <p>Dans cet exemple, le fournisseur file va tenter d'authentifier
    l'utilisateur en premier. S'il n'y parvient pas, le fournisseur LDAP
    sera sollicité. Ceci permet l'élargissement des possibilités
    d'authentification si votre organisation implémente plusieurs types
    de bases d'authentification. D'autres scénarios d'authentification
    et d'autorisation peuvent associer un type d'authentification avec
    un autre type d'autorisation. Par exemple, une authentification
    basée sur un fichier de mots de passe peut permettre l'attribution
    d'autorisations basée sur un annuaire LDAP.</p>

    <p>Tout comme plusieurs fournisseurs d'authentification peuvent être
    implémentés, on peut aussi utiliser plusieurs méthodes
    d'autorisation. Dans l'exemple suivant, on utilise à la fois une
    autorisation à base de fichier de groupes et une autorisation à base
    de groupes LDAP.</p>

    <highlight language="config">
&lt;Directory "/www/docs/private"&gt;

    AuthName "Private"
    AuthType Basic
    AuthBasicProvider file
    AuthUserFile "/usr/local/apache/passwd/passwords"
    AuthLDAPURL ldap://ldaphost/o=yourorg
    AuthGroupFile "/usr/local/apache/passwd/groups"
    Require group GroupName
    Require ldap-group cn=mygroup,o=yourorg

&lt;/Directory&gt;
    </highlight>

    <p>Pour un scénario d'autorisation un peu plus avancé, des
    directives de conteneur d'autorisation comme <directive
    module="mod_authz_core" type="section">RequireAll</directive> et
    <directive module="mod_authz_core"
    type="section">RequireAny</directive> permettent d'appliquer une
    logique telle que l'ordre dans lequel les autorisations sont
    appliquées peut être entièrement contrôlé au niveau de la
    configuration. Voir <a
    href="../mod/mod_authz_core.html#logic">Conteneurs
    d'autorisations</a> pour un exemple de ce contrôle.</p>

</section>

<section id="beyond"><title>Pour aller plus loin qu'une simple
autorisation</title>

    <p>La manière dont les autorisations sont accordées est désormais
    beaucoup plus souple qu'une simple vérification auprès d'une seule
    base de données. Il est maintenant possible de choisir l'ordre, la
    logique et la manière selon lesquels une autorisation est
    accordée.</p>

    <section id="authandororder"><title>Appliquer logique et
    ordonnancement</title>
        <p>Le contrôle de la manière et de l'ordre selon lesquels le
	processus d'autorisation était appliqué
	constituait une sorte de mystère par
	le passé. Dans Apache 2.2, un mécanisme d'authentification basé
	sur les fournisseurs a été développé afin de séparer le
	véritable processus d'authentification de l'autorisation et ses
	différentes fonctionnalités. Un des avantages colatéraux
	résidait dans le fait que les fournisseurs d'authentification
	pouvaient être configurés et appelés selon un ordre particulier
	indépendant de l'ordre de chargement du module auth proprement
	dit. Ce mécanisme basé sur les fournisseurs a été étendu au
	processus d'autorisation. Ceci signifie que la directive
	<directive module="mod_authz_core">Require</directive> définit
	non seulement quelles méthodes d'autorisation doivent être
	utilisées, mais aussi l'ordre dans lequel elles sont appelées.
	Les méthodes d'autorisation sont appelées selon l'ordre dans
	lequel les directives <directive
	module="mod_authz_core">Require</directive> apparaissent dans la
	configuration.</p>

        <p>Avec l'introduction des directives de conteneur
	d'autorisations <directive module="mod_authz_core"
	type="section">RequireAll</directive>
 	et <directive module="mod_authz_core"
	type="section">RequireAny</directive>, la
	configuration contrôle aussi le moment où les méthodes
	d'autorisation sont appelées, et quels critères déterminent
	l'autorisation d'accès. Voir <a
	href="../mod/mod_authz_core.html#logic">Conteneurs
	d'autorisations</a> pour un exemple de la manière de les
	utiliser pour exprimer des logiques d'autorisation
	complexes.</p>

        <p>Par défaut, toutes les directives <directive
	module="mod_authz_core">Require</directive> sont
	traitées comme si elles étaient contenues dans une directive
	<directive module="mod_authz_core"
	type="section">RequireAny</directive>. En d'autres termes, il
	suffit
	qu'une méthode d'autorisation s'applique avec succès pour que
	l'autorisation soit accordée.</p>

    </section>

    <section id="reqaccessctrl"><title>Utilisation de fournisseurs
    d'autorisation pour le contrôle d'accès</title>
        <p>La vérification du nom d'utilisateur et du mot de passe ne
	constituent qu'un aspect des méthodes d'authentification.
	Souvent, le contrôle d'accès à certaines personnes n'est pas
	basé sur leur identité ; il peut dépendre, par exemple de leur
	provenance.</p>

        <p>Les fournisseurs d'autorisation <code>all</code>,
	<code>env</code>, <code>host</code> et <code>ip</code> vous
	permettent d'accorder ou refuser l'accès en
	fonction de critères tels que le nom d'hôte ou l'adresse
	IP de la machine qui effectue la requête.</p>

        <p>L'utilisation de ces fournisseurs est spécifiée à l'aide de
	la directive <directive
	module="mod_authz_core">Require</directive>. Cette directive
	permet d'enregistrer quels fournisseurs d'autorisation
	seront appelés dans le processus d'autorisation au cours du
	traitement de la requête. Par exemple :</p>

        <highlight language="config">Require ip <var>address</var></highlight>

        <p>où <var>adresse</var> est une adresse IP (ou une adresse IP
	partielle) ou :</p>

        <highlight language="config">Require host <var>domain_name</var></highlight>

        <p>où <var>nom_domaine</var> est un nom de domaine entièrement
	qualifé (ou un nom de domaine partiel) ; vous pouvez indiquer
	plusieurs adresses ou noms de domaines, si vous le désirez.</p>

        <p>Par exemple, si vous voulez rejeter les spams dont une
	machine vous inonde, vous pouvez utiliser ceci :</p>

        <highlight language="config">
&lt;RequireAll&gt;
    Require all granted
    Require not ip 10.252.46.165
&lt;/RequireAll&gt;
        </highlight>

        <p>Ainsi, les visiteurs en provenance de cette adresse ne
	pourront pas voir le contenu concerné par cette directive. Si,
	par contre, vous connaissez le nom de la machine, vous pouvez
	utiliser ceci :</p>

        <highlight language="config">
&lt;RequireAll&gt;
    Require all granted
    Require not host host.example.com
&lt;/RequireAll&gt;
        </highlight>

        <p>Et si vous voulez interdire l'accès à toutes les machines
	d'un domaine, vous pouvez spécifier une partie seulement de
	l'adresse ou du nom de domaine :</p>

        <highlight language="config">
&lt;RequireAll&gt;
    Require all granted
    Require not ip 192.168.205
    Require not host phishers.example.com moreidiots.example
    Require not host ke
&lt;/RequireAll&gt;
        </highlight>

        <p>L'utilisation de la directive <directive
	module="mod_authz_core" type="section">RequireAll</directive>
	avec de multiples directives <directive module="mod_authz_core"
	type="section">Require</directive>, toutes avec la négation
	<code>not</code>, n'accordera l'accès que si toutes les
	conditions négatives sont vérifiées. En d'autres termes, l'accès
	sera refusé si au moins une des conditions négatives n'est pas
	vérifiée.</p>

    </section>

    <section id="filesystem"><title>Compatibilité ascendante du contrôle
    d'accès</title>
        <p>L'adoption d'un mécanisme à base de fournisseurs pour
	l'authentification, a pour effet colatéral de rendre inutiles
	les directives <directive
	module="mod_access_compat">Order</directive>, <directive
	module="mod_access_compat">Allow</directive>, <directive
	module="mod_access_compat">Deny</directive> et <directive
	module="mod_access_compat">Satisfy</directive>. Cependant, et à
	des fins de compatibilité ascendante vers les anciennes
	configurations, ces directives ont été déplacées vers le module
	<module>mod_access_compat</module>.</p>

    <note type="warning"><title>Note</title>
      <p>Les directives fournies par le module
      <module>mod_access_compat</module> sont devenues obsolètes depuis
      la refonte du module <module>mod_authz_host</module>. Mélanger d'anciennes
      directives comme <directive
      module="mod_access_compat">Order</directive>, <directive
      module="mod_access_compat">Allow</directive> ou <directive
      module="mod_access_compat">Deny</directive> avec des nouvelles comme
      <directive module="mod_authz_core">Require</directive> est techniquement
      possible mais déconseillé. En effet, <module>mod_access_compat</module> a
      été conçu pour supporter des configurations ne contenant que des anciennes
      directives afin de faciliter le passage à la version 2.4. Voir le document
      <a href="../upgrading.html">upgrading</a> pour plus de détails.
      </p>
    </note>	
    </section>

</section>

<section id="socache"><title>Mise en cache de l'authentification</title>
    <p>Dans certains cas, l'authentification constitue une charge
    inacceptable pour un fournisseur d'authentification ou votre réseau.
    Ceci est susceptible d'affecter les utilisateurs du module
    <module>mod_authn_dbd</module> (ou les fournisseurs
    tiers/personnalisés). Pour résoudre ce problème, HTTPD 2.3/2.4
    propose un nouveau fournisseur de mise en cache,
    <module>mod_authn_socache</module>, qui permet de mettre en cache
    les données d'authentification, et ainsi réduire la charge du/des
    fournisseurs(s) originels.</p>
    <p>Cette mise en cache apportera un gain en performance substantiel
    à certains utilisateurs.</p>
</section>

<section id="moreinformation"><title>Pour aller plus loin . . .</title>
    <p>Vous pouvez aussi lire la documentation de
    <module>mod_auth_basic</module> et <module>mod_authz_host</module>
    qui contient des informations supplémentaires à propos du
    fonctionnement de tout ceci.
    Certaines configurations d'authentification peuvent aussi être
    simplifiées à l'aide de la directive <directive
    type="section"
    module="mod_authn_core">AuthnProviderAlias</directive>.</p>

    <p>Les différents algorithmes de chiffrement supportés par Apache
    pour authentifier les données sont expliqués dans <a
    href="../misc/password_encryptions.html">PasswordEncryptions</a>.</p>

    <p>Enfin vous pouvez consulter la recette <a href="access.html">Contrôle
    d'accès</a>, qui décrit un certain nombre de situations en relation
    avec le sujet.</p>

</section>

</manualpage>

