<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE manualpage SYSTEM "./style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="./style/manual.fr.xsl"?>
<!-- English Revision: 1741841 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="custom-error.xml.meta">

  <title>Messages d'erreur personnalisés</title>

  <summary>
    <p>Le serveur HTTP Apache fournit des messages d'erreur génériques
    pour les codes de statut 4xx ou 5xx ; ces messages sont cependant
    relativement austères, imprécis, et peuvent s'avérer intimidants
    pour les visiteurs du site. Si vous le souhaitez, vous pouvez
    afficher des messages d'erreur plus conviviaux, dans un langage
    autre que l'anglais, ou même sous une forme plus en adéquation avec
    le style de votre site.</p>

    <p>Il est possible de définir des messages d'erreur personnalisés
    pour chaque code de statut HTTP associé à une condition d'erreur -
    c'est à dire tout code de statut 4xx ou 5xx.</p>

    <p>De plus, il est possible de
    personnaliser le message d'erreur en fonction d'un jeu de valeurs
    fourni, en utilisant les <a href="howto/ssi.html">Inclusions Côté
    Serveur (SSI)</a>. Un programme CGI ou un autre gestionnaire
    dynamique (PHP, mod_perl, etc...) peut aussi utiliser ces variables
    pour gérer les conditions d'erreur.</p>


  </summary>

  <section id="configuration"><title>Configuration</title>

    <p>Les messages d'erreur personnalisés sont configurés via la
    directive <directive module="core">ErrorDocument</directive>, qui
    peut être utilisée dans un contexte global, serveur virtuel ou
    répertoire. On peut utiliser cette directive dans les fichiers
    .htaccess si <directive module="core">AllowOverride</directive> est
    définie à FileInfo.</p>

    <highlight language="config">
ErrorDocument 500 "Désolé, notre script s'est
crashé ; comme c'est dommage !"
ErrorDocument 500 /cgi-bin/crash-recover
ErrorDocument 500 http://error.example.com/server_error.html
ErrorDocument 404 /errors/not_found.html 
ErrorDocument 401 /subscription/how_to_subscribe.html
    </highlight>

<p>La syntaxe de la directive <code>ErrorDocument</code> est :</p>
      <highlight language="config">
      ErrorDocument &lt;code_3_chiffres&gt; &lt;action&gt;
    </highlight>
      <p>où action peut être traitée comme :</p>
        <ol>
      <li>Une URL de redirection local (si l'action commence par un "/").</li>
      <li>Une URL de redirection externe (si action est une URL valide).</li>
      <li>Le texte à afficher (si l'action ne répond à aucune des
      deux conditions précédentes). Entourez le texte de guillemets (")
      s'il contient plusieurs mots.</li>
        </ol>

    <p>Dans le cas d'une redirection vers une URL locale, des variables
    d'environnement supplémentaires sont définies de façon à ce que la
    réponse puisse être personnalisée par la suite. Elles ne sont pas
    envoyées aux URLs externes.</p>

  </section>

        <section id="variables"><title>Variables disponibles</title>

      <p>La redirection vers une autre URL peut être utile, mais
      seulement s'il est possible de transmettre certaines informations
      qui pourront être utilisées pour expliquer ou journaliser
      la condition d'erreur ou le problème plus clairement.</p>

	<p>Pour y parvenir, lorsque la redirection d'erreur est envoyée,
	des variables d'environnement supplémentaires sont définies à
	partir des en-têtes de la requête originale en préfixant le nom
	d'origine de l'en-tête par 'REDIRECT_', ce qui permet de fournir au
	message d'erreur le contexte de la requête originelle.</p>

      <p>Par exemple, en plus des variables d'environnement habituelles,
      vous pouvez recevoir ce qui suit :</p>


      <example>
        REDIRECT_HTTP_ACCEPT=*/*, image/gif, image/jpeg, image/png<br />
        REDIRECT_HTTP_USER_AGENT=Mozilla/5.0 Fedora/3.5.8-1.fc12 Firefox/3.5.8<br />
        REDIRECT_PATH=.:/bin:/usr/local/bin:/sbin<br />
        REDIRECT_QUERY_STRING=<br />
        REDIRECT_REMOTE_ADDR=121.345.78.123<br />
        REDIRECT_REMOTE_HOST=client.example.com<br />
        REDIRECT_SERVER_NAME=www.example.edu<br />
        REDIRECT_SERVER_PORT=80<br />
        REDIRECT_SERVER_SOFTWARE=Apache/2.2.15<br />
        REDIRECT_URL=/cgi-bin/buggy.pl
      </example>

      <p>Les variables d'environnement <code>REDIRECT_</code> sont
      créées à partir des variables d'environnement préexistantes à la
      redirection qui sont préfixées par la chaîne <code>REDIRECT_</code> ;
      par exemple, <code>HTTP_USER_AGENT</code> devient
      <code>REDIRECT_HTTP_USER_AGENT</code>.</p>

      <p><code>REDIRECT_URL</code>, <code>REDIRECT_STATUS</code>, et
      <code>REDIRECT_QUERY_STRING</code> sont systématiquement définies,
      les autres variables n'étant définies que si l'en-tête
      correspondant existait avant la condition d'erreur.</p>

      <p><strong>Aucune</strong> d'entre elles ne sera définie si votre
      directive <directive module="core">ErrorDocument</directive>
      spécifie une redirection <em>externe</em> (toute URL commençant
      par un protocole du style <code>http:</code>, même si elle fait
      référence au même hôte que le serveur).</p>

  </section>

  <section id="custom"><title>Personnalisation des messages d'erreur</title>


	<p>Si vous faites pointer votre directive
	<code>ErrorDocument</code> vers certains gestionnaires
	dynamiques comme les inclusions côté serveur, les scripts CGI ou
	d'autres gestionnaires, vous pouvez utiliser les variables
	d'environnement supplémentaires disponibles pour personnaliser
	le message.</p>


      <p>Si la directive ErrorDname-basedocument spécifie une redirection locale
      vers un script CGI, ce dernier doit ajouter un en-tête
      "<code>Status:</code>" dans sa sortie afin de s'assurer du bon
      acheminement jusqu'au client de la condition d'erreur qui a
      provoqué cette redirection. Par exemple, un script Perl spécifié
      par une directive ErrorDocument pourrait contenir ce qui suit
      :</p>

      <highlight language="perl">
...
print  "Content-type: text/html\n"; 
printf "Status: %s Condition Intercepted\n", $ENV{"REDIRECT_STATUS"}; 
...
      </highlight>

      <p>Si un script est dédié à la gestion d'une condition d'erreur
      spécifique, telle que <code>404&nbsp;Not&nbsp;Found</code>, il
      peut utiliser le code et le texte de l'erreur spécifiques à la
      place.</p>

      <p>Notez que si la réponse contient un en-tête
      <code>Location:</code> (afin d'initier une redirection côté
      client), le script <em>doit</em> émettre un en-tête approprié
      (comme <code>302&nbsp;Found</code>). Dans le cas contraire,
      l'en-tête <code>Location:</code> ne produira aucun effet.</p>
  </section>

  <section id="multi-lang"><title>Messages d'erreur personnalisés
  multilingues</title>

    <p>Vous trouverez dans la distribution du serveur HTTP Apache un
    répertoire contenant des messages d'erreur personnalisés traduits en
    16 langues différentes. Pour activer cette fonctionnalité, vous
    pouvez aussi inclure un fichier de configuration qui se trouve dans
    le répertoire de configuration <code>conf/extra</code>.</p>

    <p>Dans le fichier de configuration de votre serveur, vous trouverez
    un groupe de lignes du style :</p>

    <highlight language="config">
    # Multi-language error messages
    #Include conf/extra/httpd-multilang-errordoc.conf
    </highlight>

    <p>Décommentez la ligne <code>Include</code> pour activer cette
    fonctionnalité, et présenter des messages d'erreur dont le langage
    sera négocié en fonction du langage préféré défini au niveau du
    navigateur du client.</p>

    <p>De plus, ces documents contiennent diverses variables
    <code>REDIRECT_</code>, de façon à ce que l'utilisateur final
    dispose d'informations supplémentaires à propos de ce qui a pu se
    produire, et de ce qu'il est susceptible de faire maintenant.</p>

    <p>Ces documents peuvent être personnalisés en fournissant autant
    d'informations utiles que vous le souhaitez aux utilisateurs à
    propos de votre site, et de ce qu'ils sont susceptibles d'y trouver.</p>

    <p>Pour pouvoir utiliser cette fonctionnalité, vous devez activer
    <module>mod_include</module> et <module>mod_negotiation</module>.</p>

 </section>


</manualpage>
