<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 420990 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="module-dict.xml.meta">

  <title>Termes utilisés pour décrire les modules</title>

<summary>
   <p>Ce document décrit les termes utilisés pour décrire chaque <a
   href="./">module</a> Apache.</p>
</summary>

<section id="Description"><title>Description</title>

<p>Une brève description des fonctions du module.</p>
</section>

<section id="Status"><title>Statut</title>

    <p>Ce terme indique le degré de rapprochement du module par rapport
    au coeur du serveur web Apache ; en d'autres termes, vous pouvez
    être amené à recompiler le serveur pour pouvoir accéder au module et
    à ses fonctionnalités. Les valeurs possibles de cet attribut sont
    :</p>

    <dl>
      <dt>MPM</dt>

      <dd>Un module dont le statut est "MPM" est un <a
      href="../mpm.html">module Multi-Processus</a>. A la différence des
      autres modules, un seul module MPM peut et doit être utilisé par Apache à
      la fois. Ce type de module est responsable de la répartition et du
      traitement de base des requêtes.</dd>

      <dt>Base</dt>

      <dd>Un module dont le statut est "Base" est compilé dans le
      serveur et chargé avec ce dernier par défaut ; il est donc
      toujours disponible à moins que vous n'ayez fait en sorte de
      supprimer le module de votre configuration.</dd>

      <dt>Extension</dt>

      <dd>Un module dont le statut est "Extension" n'est pas compilé et
      chargé dans le serveur par défaut. Pour activer le module et
      accéder à ses fonctionnalités, vous devez modifier la
      configuration de la compilation du serveur et recompiler
      Apache.</dd>

      <dt>Expérimental</dt>

      <dd>Le statut "Experimental" indique que le module fait partie du
      kit Apache, mais que vous devez l'utiliser à vos risques et
      périls. Le module est documenté à des fins d'exhaustivité, et
      n'est pas obligatoirement supporté.</dd>

      <dt>Externe</dt>

      <dd>Ce statut indique que le module ("module tiers") ne fait pas
      partie de la distribution de base d'Apache. Nous ne sommes pas
      responsables de ces modules et n'en assurons pas le support.</dd>
    </dl>
</section>

<section id="SourceFile"><title>Fichier source</title>

    <p>Il s'agit tout simplement de la liste des noms des fichiers
    source qui contiennent le code du module. C'est aussi le nom utilisé
    par la directive <directive module="core"
    type="section">IfModule</directive>.</p>
</section>

<section id="ModuleIdentifier"><title>Identificateur de module</title>

    <p>C'est une chaîne permettant d'identifier le module à utiliser
    dans la directive <directive module="mod_so">LoadModule</directive>
    pour le chargement dynamique des modules. En particulier, c'est le
    nom de la variable externe de type module dans le fichier
    source.</p>
</section>

<section id="Compatibility"><title>Compatibilité</title>

    <p>Si le module ne faisait pas partie de la distribution originale
    d'Apache version 2, la version à partir de laquelle il est
    disponible est indiquée ici. En outre, si le module n'est disponible
    que sur certaines plates-formes, cela sera mentionné ici.</p>
</section>

</manualpage>
