<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1840965 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
Upon adding a new module XML doc, you will need to:

svn ps svn:eol-style native <alltextfiles>
svn ps svn:keywords LastChangedRevision mod_allowmethods.xml

in order for it to rebuild correctly.

-->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_allowmethods.xml.meta">
<name>mod_allowmethods</name>
<description>Ce module permet de restreindre aisément les méthodes HTTP
pouvant être utilisées sur le serveur</description>
<status>Experimental</status>
<sourcefile>mod_allowmethods.c</sourcefile>
<identifier>allowmethods_module</identifier>
<compatibility>Disponible à partir de la version 2.3 du serveur HTTP Apache</compatibility>

<summary>
<p>Ce module permet de restreindre aisément les méthodes HTTP
pouvant être utilisées sur le serveur. La configuration la plus courante
est du style :</p>

<highlight language="config">
&lt;Location "/"&gt;
   AllowMethods GET POST OPTIONS
&lt;/Location&gt;
</highlight>

</summary>

<directivesynopsis>
<name>AllowMethods</name>
<description>Restreint l'accès aux méthodes HTTP spécifiées</description>
<syntax>AllowMethods reset|<em>HTTP-method</em>
[<em>HTTP-method</em>]...</syntax>
<default>AllowMethods reset</default>
<contextlist><context>directory</context></contextlist>
<status>Experimental</status>

<usage>

<p>Les noms des méthodes HTTP sont sensibles à la casse, et sont en
général définis en majuscules, comme dans les RFCs. Les méthodes GET et
HEAD sont considérées comme équivalentes. Le mot-clé
<code>reset</code> permet de désactiver
<module>mod_allowmethods</module> dans les niveaux inférieurs
d'imbrication :</p>

<highlight language="config">
&lt;Location "/svn"&gt;
   AllowMethods reset
&lt;/Location&gt;
</highlight>

<note><title>Avertissement</title>
  <p>La méthode TRACE ne peut pas être rejetée par ce module ; pour ce
  faire, vous devez utiliser la directive <directive
  module="core">TraceEnable</directive>.</p>
</note>

<p>Le module <module>mod_allowmethods</module> a été écrit pour
remplacer l'implémentation "bricolée" des directives <directive
module="core">Limit</directive> et <directive
module="core">LimitExcept</directive>.</p>
</usage>
</directivesynopsis>

</modulesynopsis>

