<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1818967 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_filter.xml.meta">

<name>mod_filter</name>
<description>Module de configuration de filtre intelligent sensible au
contexte</description>
<status>Base</status>
<sourcefile>mod_filter.c</sourcefile>
<identifier>filter_module</identifier>
<compatibility>Versions 2.1 et supérieures</compatibility>

<summary>
    <p>Ce module permet une configuration intelligente et dépendant du
    contexte des filtres de contenu en sortie. Par exemple, Apache peut
    être configuré pour faire traiter différents types de contenus par
    différents filtres, même lorsque le type de contenu n'est pas connu
    à l'avance (par exemple dans un serveur mandataire).</p>

    <p>Le fonctionnement de <module>mod_filter</module> consiste à
    introduire des branchements dans la chaîne de filtrage. Plutôt que
    d'insérer directement des filtres dans la chaîne, on insère un
    sélecteur de filtre qui va effectuer un branchement conditionnel
    vers un fournisseur de filtre. <module>mod_filter</module> peut
    utiliser tout filtre de contenu comme fournisseur ; aucune
    modification des modules de filtrage existants n'est nécessaire
    (bien qu'il soit tout de même possible de les simplifier).</p>
</summary>

<section id="smart"><title>Filtrage intelligent</title>
    <p>Dans le modèle de filtrage traditionnel, les filtres sont insérés
    sans condition à l'aide de la directive <directive
    module="mod_mime">AddOutputFilter</directive> et des directives
    apparentées. Chaque filtre doit ensuite déterminer s'il doit
    s'exécuter ou non, et les administrateurs du serveur disposent de
    peu de souplesse pour faire en sorte que la chaîne soit traitée de
    manière dynamique.</p>

    <p><module>mod_filter</module>, à l'opposé, fournit aux
    administrateurs du serveur un grand degré de souplesse pour
    configurer la chaîne de filtrage. Concrètement, la décision
    d'insérer un filtre peut être prise en fonction d'une <a
    href="../expr.html">expression</a> booléenne complexe. Ceci
    généralise le fonctionnement relativement souple de la directive
    <directive>AddOutputFilterByType</directive>.</p>
</section>

<section id="terms"><title>Déclarations de filtres, fournisseurs et
chaînes</title>
    <p class="figure">
    <img src="../images/mod_filter_old.gif" width="160" height="310"
    alt="[Cette image illustre le modèle de filtrage traditionnel]"/><br />
    <dfn>Figure 1:</dfn> Le modèle de filtrage traditionnel</p>

    <p>Dans le modèle traditionnel, les filtres en sortie constituent
    une simple chaîne s'étendant depuis le générateur de contenu (ou
    gestionnaire) jusqu'au client. Ce fonctionnement peut convenir s'il
    permet d'atteindre le but recherché, mais pose
    problème lorsque cette chaîne doit être configurée dynamiquement en
    fonction de la sortie du gestionnaire.</p>

    <p class="figure">
    <img src="../images/mod_filter_new.gif" width="423" height="331"
    alt="[Cette image illustre le modèle de fonctionnement de
    mod_filter]"/><br />
    <dfn>Figure 2:</dfn> Le modèle de fonctionnement de
    <module>mod_filter</module></p>

    <p>Le fonctionnement de <module>mod_filter</module> consiste à
    introduire des branchements dans la chaîne de filtrage. Plutôt que
    d'insérer directement des filtres dans la chaîne, on insère un
    sélecteur de filtre qui va effectuer un branchement conditionnel
    vers un fournisseur de filtre. <module>mod_filter</module> peut
    utiliser tout filtre de contenu comme fournisseur ; aucune
    modification des modules de filtrage existants n'est nécessaire
    (bien qu'il soit tout de même possible de les simplifier). Il peut y
    avoir plusieurs fournisseurs pour un seul filtre, mais un seul
    fournisseur sera choisi pour chaque requête.</p>

    <p>Une chaîne de filtrage peut comporter autant d'instances du
    sélecteur de filtre que l'on souhaite, chacune d'entre elles pouvant
    disposer de plusieurs fournisseurs. Un sélecteur de filtre possédant
    un seul fournisseur dont le choix est inconditionnel constitue un
    cas particulier : cette situation est équivalente à l'insertion
    directe du filtre dans la chaîne.</p>
</section>

<section id="config"><title>Configuration de la chaîne de
filtrage</title>
    <p>Trois étapes sont nécessaires pour configurer une chaîne de
    filtrage avec <module>mod_filter</module>. Voir ci-dessous la
    description détaillée des directives.</p>

    <dl>
    <dt>Déclaration des filtres</dt>
    <dd>La directive <directive
    module="mod_filter">FilterDeclare</directive> permet de déclarer un
    filtre en lui assignant un nom et un type. Elle n'est obligatoire
    que si le filtre n'est pas du type par défaut
    AP_FTYPE_RESOURCE.</dd>

    <dt>Enregistrement des fournisseurs</dt>
    <dd>La directive <directive
    module="mod_filter">FilterProvider</directive> permet d'associer un
    fournisseur à un filtre. Le filtre a été éventuellement déclaré à
    l'aide de la directive <directive module="mod_filter"
    >FilterDeclare</directive> ; si ce n'est pas le cas, FilterProvider
    va le déclarer implicitement avec le type par défaut
    AP_FTYPE_RESOURCE. Le fournisseur doit avoir été enregistré à
    l'aide de <code>ap_register_output_filter</code> par un module
    quelconque. Le dernier argument de la directive <directive
    module="mod_filter">FilterProvider</directive> est une expression :
    le fournisseur s'exécutera pour une requête si et seulement si
    l'expression est évaluée vraie. L'expression peut évaluer une
    requête HTTP ou les en-têtes de la réponse, des variables
    d'environnement, ou le gestionnaire utilisé par cette requête. À la
    différence des version précédentes, mod_filter supporte désormais
    les expressions complexes associant des critères multiples au moyen
    d'une logique AND / OR (&amp;&amp; / ||) et de parenthèses. Pour les
    détails sur la syntaxe de l'expression, voir la <a
    href="../expr.html">documentation sur ap_expr</a>.</dd>

    <dt>Configuration de la chaîne de filtrage</dt>
    <dd>Les directives ci-dessus permettent d'élaborer les éléments
    d'une chaîne de filtrage intelligente, mais pas de les configurer en
    vue de leur exécution. La directive <directive module="mod_filter"
    >FilterChain</directive> élabore une chaîne de filtrage à
    partir de filtres intelligents déclarés, permettant avec souplesse
    d'insérer des filtres au début ou à la fin de la chaîne, de
    supprimer un filtre ou même la chaîne complète.</dd>
</dl>
</section>
<section id="errordocs"><title>Filtrage et statut de la réponse</title>
    <p>Normalement, mod_filter n'applique les filtres qu'aux réponses
    possédant un statut HTTP 200 (OK). Pour pouvoir filtrer des
    documents possédant un autre statut, vous devez définir la variable
    d'environnement <var>filter-errordocs</var>, les réponses étant
    alors filtrées sans se préoccuper de leur statut. Pour définir ce
    comportement de manière plus fine, vous pouvez utiliser des
    conditions dans la directive
    <directive>FilterProvider</directive>.</p>
</section>
<section id="upgrade"><title>Mise à jour depuis une configuration du
serveur HTTP Apache 2.2</title>
    <p>La directive <directive
    module="mod_filter">FilterProvider</directive> a été modifiée par
    rapport à httpd 2.2 : les arguments <var>match</var> et
    <var>dispatch</var> ont été remplacés par l'argument unique
    <var>expression</var> plus polyvalent. En général, il est possible
    de convertir une paire match/dispatch vers les deux côtés d'une
    expression, de la manière suivante :</p>
    <example>"dispatch = 'match'"</example>
    <p>Les en-têtes de requête et de réponse et les variables
    d'environnement sont maintenant interprétés selon les syntaxes
    respectives <var>%{req:foo}</var>, <var>%{resp:foo}</var> et
    <var>%{env:foo}</var>. Les variables <var>%{HANDLER}</var> et
    <var>%{CONTENT_TYPE}</var> sont également supportées.</p>
    <p>Notez que l'évaluation de l'expression ne supporte plus les
    comparaisons de sous-chaînes. Ces dernières peuvent
    être remplacées par des comparaisons d'expressions rationnelles.</p>
</section>

<section id="examples"><title>Exemples</title>
    <dl>
    <dt>Inclusions côté serveur (SSI)</dt>
    <dd>Un exemple simple de remplacement de la directive <directive
    module="core">AddOutputFilterByType</directive>
    <highlight language="config">
FilterDeclare SSI
FilterProvider SSI INCLUDES "%{CONTENT_TYPE} =~ m|^text/html|"
FilterChain SSI
    </highlight>
    </dd>

    <dt>Inclusions côté serveur (SSI)</dt>
    <dd>Même exemple que ci-dessus, mais envoi vers un gestionnaire
    (comportement classique des SSI ; les fichiers .shtml sont
    traités).
    <highlight language="config">
FilterProvider SSI INCLUDES "%{HANDLER} = 'server-parsed'"
FilterChain SSI
    </highlight>
    </dd>

    <dt>Émulation de mod_gzip avec mod_deflate</dt>
    <dd>Insertion du filtre INFLATE seulement si l'en-tête
    Accept-Encoding a une valeur autre que "gzip". Ce filtre s'exécute
    avec le type ftype CONTENT_SET.
    <highlight language="config">
FilterDeclare gzip CONTENT_SET
FilterProvider gzip inflate "%{req:Accept-Encoding} !~ /gzip/"
FilterChain gzip
    </highlight>
    </dd>

    <dt>Diminution de la résolution d'une image</dt>
    <dd>Supposons que nous voulions réduire la résolution de toutes les
    images web, et que nous disposions de filtres pour les images GIF,
    JPEG et PNG.
    <highlight language="config">
FilterProvider unpack jpeg_unpack "%{CONTENT_TYPE} = 'image/jpeg'"
FilterProvider unpack gif_unpack  "%{CONTENT_TYPE} = 'image/gif'"
FilterProvider unpack png_unpack  "%{CONTENT_TYPE} = 'image/png'"

FilterProvider downsample downsample_filter "%{CONTENT_TYPE} = m|^image/(jpeg|gif|png)|"
FilterProtocol downsample "change=yes"

FilterProvider repack jpeg_pack "%{CONTENT_TYPE} = 'image/jpeg'"
FilterProvider repack gif_pack  "%{CONTENT_TYPE} = 'image/gif'"
FilterProvider repack png_pack  "%{CONTENT_TYPE} = 'image/png'"
&lt;Location "/image-filter"&gt;
    FilterChain unpack downsample repack
&lt;/Location&gt;
    </highlight>
    </dd>
    </dl>
</section>

<section id="protocol"><title>Gestion de protocole</title>
    <p>Historiquement, tout filtre doit s'assurer que toute modification
    qu'il effectue est correctement représentée dans les en-têtes de la
    réponse HTTP, et qu'il ne s'exécutera pas si cette exécution
    résultait en une modification interdite. Ceci impose aux auteurs de
    filtres la corvée de réimplémenter certaines fonctionnalités
    communes dans chaque filtre :</p>

    <ul>
    <li>De nombreux filtres modifient les contenus, et de ce fait
    invalident les balises de ces contenus, leur somme de
    contrôle, leur condensé (hash) existant, ainsi que leur
    taille.</li>

    <li>Les filtres qui nécessitent une réponse entière et non tronquée en
    entrée, doivent s'assurer qu'il n'ont pas reçu une réponse à une
    requête partielle.</li>

    <li>Les filtres qui modifient la sortie d'un autre filtre doivent
    s'assurer qu'ils ne violent pas la directive d'un en-tête
    <code>Cache-Control: no-transform</code> éventuel.</li>

    <li>Les filtres peuvent agir sur des réponses de façon à ce qu'elles
    ne puissent plus être mises en cache.</li>
    </ul>

    <p><module>mod_filter</module> a pour but de gérer de manière
    générale ces détails de l'implémentation des filtres, réduisant par
    là-même la complexité des modules de filtrage de contenu. Le
    travail permettant d'atteindre ce but est cependant toujours en
    cours ; la directive <directive
    module="mod_filter">FilterProtocol</directive>
    implémente certaines de ces fonctionnalités à des fins de
    compatibilité ascendante avec les modules d'Apache 2.0. Pour les
    versions 2.1 et supérieures de httpd, les API
    <code>ap_register_output_filter_protocol</code> et
    <code>ap_filter_protocol</code> permettent aux modules de filtrage
    de définir leurs propres comportements.</p>

    <p>Cependant, <module>mod_filter</module> ne doit pas interférer
    avec un filtre qui gère déjà tous les aspects du protocole. Par
    défaut (c'est à dire en l'absence de toute directive <directive
    module="mod_filter">FilterProtocol</directive>),
    <module>mod_filter</module> ne modifiera donc pas les en-têtes.</p>

    <p>Au moment où ces lignes sont écrites, cette fonctionnalité a été
    très peu testée, car les modules d'usage courant ont été conçus pour
    fonctionner avec httpd 2.0. Les modules qui l'utilisent devront donc
    l'expérimenter avec précautions.</p>
</section>

<directivesynopsis>
<name>AddOutputFilterByType</name>
<description>assigne un filtre en sortie pour un type de média
particulier</description>
<syntax>AddOutputFilterByType <var>filtre</var>[;<var>filtre</var>...]
<var>type_de_média</var> [<var>type_de_média</var>] ...</syntax>
<contextlist><context>server config</context>
<context>virtual host</context><context>directory</context>
<context>.htaccess</context></contextlist>
<override>FileInfo</override>
<compatibility>Présentait de sévères limitations avant d'être déplacé dans
<module>mod_filter</module> dans la version 2.3.7</compatibility>

<usage>
    <p>Cette directive active un <a
    href="../filter.html">filtre</a> en sortie particulier pour une
    requête en fonction du <glossary>type de média</glossary> de la réponse.</p>

    <p>L'exemple suivant active le filtre <code>DEFLATE</code> qui est
    fourni par le module <module>mod_deflate</module>. Il va compresser
    toute sortie dont le type MIME est <code>text/html</code> ou
    <code>text/plain</code> avant de l'envoyer au client.</p>

    <highlight language="config">
      AddOutputFilterByType DEFLATE text/html text/plain
    </highlight>

    <p>Si vous voulez assigner plusieurs filtres au contenu, leurs noms
    doivent être séparés par des points-virgules. On peut aussi utiliser
    une directive <directive>AddOutputFilterByType</directive> pour
    chacun des filtres à assigner.</p>

    <p>La configuration ci-dessous impose le traitement de toute sortie
    de script dont le type MIME est <code>text/html</code> en premier
    lieu par le filtre <code>INCLUDES</code>, puis par le filtre
    <code>DEFLATE</code>.</p>

    <highlight language="config">
&lt;Location "/cgi-bin/"&gt;
    Options Includes
    AddOutputFilterByType INCLUDES;DEFLATE text/html
&lt;/Location&gt;
    </highlight>

</usage>

<seealso><directive module="mod_mime">AddOutputFilter</directive></seealso>
<seealso><directive module="core">SetOutputFilter</directive></seealso>
<seealso><a href="../filter.html">Les filtres</a></seealso>
</directivesynopsis>

<directivesynopsis>
<name>FilterDeclare</name>
<description>Déclare un filtre intelligent</description>
<syntax>FilterDeclare <var>nom_filtre</var> <var>[type]</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>Options</override>

<usage>
    <p>Cette directive permet de déclarer un filtre en sortie associé à
    un en-tête ou une variable d'environnement qui déterminera les
    conditions de son exécution. Le premier argument est le <var>nom du
    filtre</var> destiné à être utilisé dans les directives <directive
    module="mod_filter">FilterProvider</directive>, <directive
    module="mod_filter">FilterChain</directive> et <directive
    module="mod_filter">FilterProtocol</directive>.</p>

    <p>Le dernier argument (optionnel) est le type du filtre, et peut
    prendre les valeurs de <code>ap_filter_type</code>, à savoir
    <code>RESOURCE</code> (valeur par défaut), <code>CONTENT_SET</code>,
    <code>PROTOCOL</code>, <code>TRANSCODE</code>,
    <code>CONNECTION</code> ou <code>NETWORK</code>.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>FilterProvider</name>
<description>Enregistre un filtre de contenu</description>
<syntax>FilterProvider <var>nom_filtre</var> <var>nom_fournisseur</var>
 <var>expression</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>Options</override>

<usage>
    <p>Cette directive permet d'associer un <em>fournisseur</em> au
    filtre intelligent. Le fournisseur sera invoqué si et seulement si
    l'<var>expression</var> est évaluée vraie lorsque le sélecteur de
    filtre est appelé pour la première fois.</p>

    <p>
    <var>nom fournisseur</var> doit avoir été enregistré au cours du
    chargement d'un module à l'aide de
    <code>ap_register_output_filter</code>.
    </p>

    <p><var>expression</var> est une expression <a
    href="../expr.html">ap_expr</a>.</p>

</usage>
<seealso><a href="../expr.html">Les expressions dans le serveur HTTP
Apache</a>, pour une référence complète et d'autres exemples.</seealso>
<seealso><module>mod_include</module></seealso>
</directivesynopsis>

<directivesynopsis>
<name>FilterChain</name>
<description>Configure la chaîne de filtrage</description>
<syntax>FilterChain [+=-@!]<var>nom_filtre</var> <var>...</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>Options</override>

<usage>
    <p>Cette directive permet de configurer une chaîne de filtrage
    composée de filtres déclarés. <directive>FilterChain</directive>
    accepte un nombre illimité d'arguments, chacun d'entre eux étant
    précédé d'un caractère de contrôle unique qui détermine l'action à
    entreprendre :</p>

    <dl>
    <dt><code>+<var>nom filtre</var></code></dt>
    <dd>Ajoute<var>nom filtre</var> à la fin de la chaîne de filtrage</dd>

    <dt><code>@<var>nom filtre</var></code></dt>
    <dd>Ajoute <var>nom filtre</var> au début de la chaîne de filtrage</dd>

    <dt><code>-<var>nom filtre</var></code></dt>
    <dd>Supprime <var>nom filtre</var> de la chaîne de filtrage</dd>

    <dt><code>=<var>nom filtre</var></code></dt>
    <dd>Supprime tous les filtres de la chaîne de filtrage existante et
    les remplace par <var>nom filtre</var></dd>

    <dt><code>!</code></dt>
    <dd>Supprime tous les filtres de la chaîne de filtrage existante</dd>

    <dt><code><var>nom filtre</var></code></dt>
    <dd>Équivalent à <code>+<var>nom filtre</var></code></dd>
    </dl>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>FilterProtocol</name>
<description>Vérifie le respect du protocole HTTP</description>
<syntax>FilterProtocol <var>nom_filtre</var> [<var>nom_fournisseur</var>]
    <var>drapeaux_protocole</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>Options</override>

<usage>
    <p>Cette directive permet à <module>mod_filter</module> de s'assurer
    qu'un filtre ne s'exécutera pas s'il ne doit pas le faire, et que
    les en-têtes de la réponse HTTP sont définis correctement en tenant
    compte des effets du filtre.</p>

    <p>Cette directive se présente sous deux formes. Avec trois
    arguments, elle s'applique de manière spécifique à un <var>nom
    filtre</var> et un <var>nom fournisseur</var> pour ce filtre. Avec
    deux arguments, elle s'applique à un <var>nom filtre</var> pour
    <em>tout</em> fournisseur qu'il actionne.</p>

    <p>Les drapeaux spécifiés sont fusionnés avec les drapeaux que les
    fournisseurs sous-jacents ont éventuellement enregistrés avec
    <module>mod_filter</module>. Par exemple, un filtre peut avoir
    spécifié en interne un drapeau équivalent à <code>change=yes</code>,
    mais une configuration particulière du module peut le surcharger
    en spécifiant <code>change=no</code>.
    </p>

    <p><var>drapeaux_protocole</var> peut contenir un ou plusieurs
    drapeaux parmi les suivants :</p>

    <dl>
    <dt><code>change=yes|no</code></dt>
    <dd>Indique si le filtre doit modifier le contenu, y compris éventuellement sa
    taille</dd>

    <dt><code>change=1:1</code></dt>
    <dd>Le filtre modifie le contenu, mais pas sa taille</dd>

    <dt><code>byteranges=no</code></dt>
    <dd>Le filtre ne peut pas traiter de réponses à des sous-requêtes et
    nécessite des réponses complètes en entrée</dd>

    <dt><code>proxy=no</code></dt>
    <dd>Le filtre ne doit pas s'exécuter dans un contexte de mandataire</dd>

    <dt><code>proxy=transform</code></dt>
    <dd>Le filtre transforme la réponse de manière incompatible avec
    l'en-tête HTTP <code>Cache-Control: no-transform</code></dd>

    <dt><code>cache=no</code></dt>
    <dd>Le filtre fait en sorte que la sortie ne puisse pas être mise en
    cache (par exemple en introduisant des modifications de contenu
    aléatoires)</dd>
    </dl>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>FilterTrace</name>
<description>Obtention d'informations de débogage/diagnostique en
provenance de <module>mod_filter</module></description>
<syntax>FilterTrace <var>nom_filtre</var> <var>niveau</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context></contextlist>

<usage>
    <p>Cette directive permet d'obtenir des informations de débogage en
    provenance de <module>mod_filter</module>. Elle est conçue pour
    aider à tester et déboguer les fournisseurs (ou modules de filtrage)
    ; elle peut aussi apporter une aide à l'utilisation de
    <module>mod_filter</module> lui-même.</p>

    <p>La sortie de débogage dépend de la définition d'argument
    <var>level</var> :</p>
    <dl>
    <dt><code>0</code> (valeur par défaut)</dt>
    <dd>Aucune information de débogage n'est générée.</dd>

    <dt><code>1</code></dt>
    <dd><module>mod_filter</module> va enregistrer les ensembles de
    conteneurs de données (buckets and brigades) qui traversent le
    filtre dans le journal des erreurs, avant que le fournisseur ne les
    traite. Ces informations sont similaires à celles générées par <a
    href="http://apache.webthing.com/mod_diagnostics/"
    >mod_diagnostics</a>.
    </dd>

    <dt><code>2</code> (pas encore implémenté)</dt>
    <dd>Ce niveau permettra d'enregistrer l'ensemble des données qui
    traversent le filtre dans un fichier temporaire avant de les envoyer
    au fournisseur. <strong>Pour un débogage mono-utilisateur
    seulement</strong> ; l'enregistrement des données concernant
    plusieurs requêtes simultannées ne sera pas supporté.</dd>
    </dl>
</usage>
</directivesynopsis>

</modulesynopsis>

