<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1749829 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_negotiation.xml.meta">

<name>mod_negotiation</name>
<description>Effectue la <a
href="../content-negotiation.html">négociation de
contenu</a></description>
<status>Base</status>
<sourcefile>mod_negotiation.c</sourcefile>
<identifier>negotiation_module</identifier>

<summary>
    <p>La négociation de contenu, ou plus précisément la sélection de
    contenu, est la sélection parmi plusieurs documents disponibles, du
    document qui "colle" au plus près des possibilités du client. Pour y
    parvenir, deux méthodes sont employées.</p>

    <ul>
      <li>Une table de correspondances de types (un fichier associé au
      gestionnaire <code>type-map</code>) qui contient une liste
      explicite des fichiers contenant les différentes variantes.</li>

      <li>Une recherche multivues (Multiviews) (activée par l'<directive
      module="core">Options</directive> <code>Multiviews</code>), où le
      serveur effectue une recherche de correspondance de modèle de nom
      de fichier implicite, et fait son choix parmi les résultats.</li>
    </ul>
</summary>
<seealso><directive module="core">Options</directive></seealso>
<seealso><module>mod_mime</module></seealso>
<seealso><a href="../content-negotiation.html">Négociation de
contenu</a></seealso>
<seealso><a href="../env.html">Variables d'environnement</a></seealso>

<section id="typemaps"><title>Tables de correspondances de types</title>
    <p>Une table de correspondances de types possède un format similaire
    à celui des en-têtes de messagerie RFC822. Elle contient des
    descriptions de documents séparées par des lignes vides, toute ligne
    commençant par un dièse ('#') étant considérée comme un
    commentaire. Une description de document comporte plusieurs
    enregistrements d'en-têtes ; chaque enregistrement peut être réparti
    sur plusieurs lignes à condition que les lignes supplémentaires
    commencent par un ou plusieurs espaces. Lors du traitement, les
    espaces de début de ligne seront supprimés et les lignes
    concaténées. L'enregistrement d'un en-tête comprend un mot-clé qui
    se termine toujours par un caractère "deux-points" ':', suivi d'une
    valeur. Les espaces sont autorisés entre le nom d'en-tête et sa
    valeur, ainsi qu'entre les différents éléments de la valeur. Les
    en-têtes autorisés sont :</p>

    <dl>
      <dt><code>Content-Encoding:</code></dt>
      <dd>Le codage du fichier. Apache ne reconnaît que les codages
      définis par une directive <directive
      module="mod_mime">AddEncoding</directive>. Sont normalement inclus
      les codages <code>x-compress</code> pour les fichiers compressés
      avec compress, et <code>x-gzip</code> pour les fichiers compressés
      avec gzip. Le préfixe <code>x-</code> est ignoré lors des
      comparaisons de codages.</dd>

      <dt><code>Content-Language:</code></dt>
      <dd>Le(s) langage(s) de la variante, sous la forme d'un symbole de
      langage Internet standard (<a
      href="http://www.ietf.org/rfc/rfc1766.txt">RFC 1766</a>). Par
      exemple, <code>en</code> correspond à l'anglais. Si la variante
      contient plusieurs langages, ils sont séparés par des
      virgules.</dd>

      <dt><code>Content-Length:</code></dt>
      <dd>La taille du fichier en octets. Si cet en-tête n'est pas
      présent, c'est la taille réelle du fichier qui est utilisée.</dd>

      <dt><code>Content-Type:</code></dt>

      <dd>
        Le <glossary ref="mime-type">type MIME</glossary> du document
	avec des paramètres optionnels. Les paramètres sont séparés du
	type de médium ainsi qu'entre eux par un point-virgule, et
	possèdent la syntaxe <code>nom=valeur</code>. Les paramètres
	courants sont :

        <dl>
          <dt><code>level</code></dt>
          <dd>un entier spécifiant la version du type de média. Pour
	  <code>text/html</code>, la valeur par défaut est 2, sinon
	  0.</dd>

          <dt><code>qs</code></dt>
          <dd>un nombre en virgule flottante de 0[.000] à 1[.000], indiquant la
	  "qualité" relative de la variante courante par rapport aux
	  autres variantes disponibles, indépendamment des possibilités
	  du client. Par exemple, un fichier jpeg est en général une
	  source de qualité supérieure à un fichier ascii s'il est censé
	  représenter une image. Cependant, si la ressource représentée
	  est une image ascii, un fichier ascii possèdera une qualité
	  supérieure à un fichier jpeg. Toutes les valeurs de
	  <code>qs</code> sont donc spécifiques à une certaine
	  ressource.</dd>
        </dl>

        <example><title>Exemple</title>
          Content-Type: image/jpeg; qs=0.8
        </example>
      </dd>

      <dt><code>URI:</code></dt>
      <dd>l'URI du fichier contenant la variante (du type de médium
      donné, codé selon le codage de contenu donné). Cet URI est
      considéré comme relatif au fichier de correspondances ; il doit
      être situé sur le même serveur, et doit faire référence au
      fichier auquel le client se verrait accorder l'accès s'il était
      requis directement.</dd>

      <dt><code>Body:</code></dt>
      <dd>Le contenu réel de la ressource
      peut être inclus dans la table de correspondances en utilisant
      l'en-tête Body. Cet en-tête doit contenir une chaîne désignant un
      délimiteur pour le contenu du corps. Les lignes suivantes du
      fichier de correspondances de types seront alors considérées comme
      parties du corps de la ressource jusqu'à ce que le délimiteur soit
      détecté.

      <example><title>Exemple:</title>
        Body:----xyz----<br />
        &lt;html&gt;<br />
        &lt;body&gt;<br />
        &lt;p&gt;Contenu de la page.&lt;/p&gt;<br />
        &lt;/body&gt;<br />
        &lt;/html&gt;<br />
        ----xyz----
      </example>
      </dd>
    </dl>

    <p>Considérons une ressource, <code>document.html</code>, disponible
    en anglais, en français et en allemand. Les fichiers correspondants
    se nomment respectivement <code>document.html.en</code>,
    <code>document.html.fr</code>, et <code>document.html.de</code>. Le
    fichier de correspondances de types se nommera
    <code>document.html.var</code> et contiendra ce qui suit :</p>

    <example>
    URI: document.html<br />
    <br />
    Content-language: en<br />
    Content-type: text/html<br />
    URI: document.html.en<br />
    <br />
    Content-language: fr<br />
    Content-type: text/html<br />
    URI: document.html.fr<br />
    <br />
    Content-language: de<br />
    Content-type: text/html<br />
    URI: document.html.de<br />
    <br />

    </example>

    <p>Ces quatre fichiers doivent se trouver dans le même répertoire,
    et le fichier <code>.var</code> doit être associé au gestionnaire
    <code>type-map</code> via une directive <directive
    module="mod_mime">AddHandler</directive> :</p>

    <highlight language="config">
    AddHandler type-map .var
    </highlight>

    <p>A l'arrivée d'une requête pour la ressource
    <code>document.html.var</code>, la variante de
    <code>document.html</code> qui correspond le mieux à la préference
    de langage spécifiée dans l'en-tête de la requête de l'utilisateur
    <code>Accept-Language</code> sera choisie.</p>

    <p>Si <code>Multiviews</code> est activée, et si <directive
    module="mod_mime">MultiviewsMatch</directive> est définie à
    "handlers" ou "any", une requête pour <code>document.html</code> va
    rechercher <code>document.html.var</code>, et continuer la
    négociation avec le gestionnaire explicite type-map.</p>

    <p>D'autres directives de configuration, comme <directive
    module="mod_alias">Alias</directive>, peuvent être utilisées pour
    associer <code>document.html</code> avec
    <code>document.html.var</code>.</p>
</section>

<section id="multiviews"><title>Multivues</title>
    <p>Une recherche Multivues est activée par l'<directive
    module="core">Options</directive> <code>Multiviews</code>. Si le
    serveur reçoit une requête pour <code>/un/répertoire/foo</code>, et
    si <code>/un/répertoire/foo</code> n'existe pas, le serveur parcourt
    le répertoire à la recherche de tous les fichiers de nom
    <code>foo.*</code>, et simule véritablement une correspondance de
    type qui nomme tous ces fichiers en leur assignant les mêmes type
    de média et codage de contenu qu'ils auraient eus si le client avait
    requis l'un d'entre eux avec son nom complet. Il choisit ensuite le
    fichier qui correspond le mieux au profile du client, puis renvoie
    le document.</p>

    <p>La directive <directive
    module="mod_mime">MultiviewsMatch</directive> définit si Apache doit
    prendre en compte les fichiers qui ne comportent pas de métadonnées
    de négociation de contenu lors du choix du fichier à servir.</p>
</section>

<directivesynopsis>
<name>CacheNegotiatedDocs</name>
<description>Permet la mise en cache au niveau des serveurs mandataires
des documents dont le contenu a été négocié</description>
<syntax>CacheNegotiatedDocs On|Off</syntax>
<default>CacheNegotiatedDocs Off</default>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>Si elle est définie à "on", cette directive permet la mise en
    cache au niveau des serveurs mandataires des documents dont le
    contenu a été négocié. Le processus de mise en cache sera alors plus
    efficace, mais des clients se trouvant derrière le mandataire
    seront alors susceptibles de se voir servir des versions de
    documents qui ne correspondent pas forcément à leurs attentes.</p>

    <p>Cette directive ne s'applique qu'aux requêtes en provenance de
    navigateurs HTTP/1.0. HTTP/1.1 fournit un bien meilleur contrôle de
    la mise en cache des documents au contenu négocié, et cette
    directive n'a aucun effet sur les réponses aux requêtes
    HTTP/1.1.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>ForceLanguagePriority</name>
<description>Action à entreprendre si un document acceptable unique
n'est pas trouvé</description>
<syntax>ForceLanguagePriority None|Prefer|Fallback [Prefer|Fallback]</syntax>
<default>ForceLanguagePriority Prefer</default>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>ForceLanguagePriority</directive> utilise
    le langage défini par la directive <directive
    module="mod_negotiation">LanguagePriority</directive> pour terminer
    la négociation lorsque le serveur n'est pas en mesure de trouver une
    solution satisfaisante unique.</p>

    <p><code>ForceLanguagePriority Prefer</code> utilise la directive
    <code>LanguagePriority</code> pour servir le résultat d'un choix
    unique, au lieu de renvoyer un résultat HTTP 300 (MULTIPLE CHOICES),
    lorsque que plusieurs choix équivalents sont disponibles. Par
    exemple, avec les deux directives ci-dessous, si l'en-tête
    <code>Accept-Language</code> de l'utilisateur assigne à
    <code>en</code> et <code>de</code> une qualité de <code>.500</code>
    (les deux langages sont également acceptables), alors c'est la
    première variante acceptable de langue <code>en</code> qui sera
    servie.</p>

    <highlight language="config">
LanguagePriority en fr de
ForceLanguagePriority Prefer
    </highlight>

    <p><code>ForceLanguagePriority Fallback</code> utilise la directive
    <directive module="mod_negotiation">LanguagePriority</directive>
    pour servir un résultat valide, au lieu de renvoyer un résultat HTTP
    406 (NOT ACCEPTABLE). Avec les deux directives ci-dessous, si
    l'en-tête <code>Accept-Language</code> de l'utilisateur ne mentionne
    que les réponses de langage <code>es</code>, et si aucune variante
    dans cette langue n'est trouvée, c'est la première variante de la
    liste définie par la directive <directive module="mod_negotiation"
    >LanguagePriority</directive> qui sera servie.</p>

    <highlight language="config">
LanguagePriority en fr de
ForceLanguagePriority Fallback
    </highlight>

    <p>Les deux options, <code>Prefer</code> et <code>Fallback</code>,
    peuvent être spécifiées, de façon à ce que la variante servie soit
    la première variante qui convient définie par la directive
    <directive module="mod_negotiation">LanguagePriority</directive> si
    plusieurs variantes sont également acceptables, ou le premier
    document disponible si aucune variante ne convient à la liste de
    langages acceptables fournie par le client.</p>
</usage>
<seealso><directive module="mod_mime">AddLanguage</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>LanguagePriority</name>
<description>L'ordre de priorité des variantes de langages pour les
cas où le client n'a pas formulé de préférences</description>
<syntax>LanguagePriority <var>langage-MIME</var> [<var>langage-MIME</var>]
...</syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>LanguagePriority</directive> permet de
    définir, au cours du traitement d'une requête Multivues, l'ordre de
    priorité des variantes de langages pour les cas
    où le client n'a pas formulé de préférences. La liste énumère les
    <var>langages-MIME</var> dans un ordre de préférences
    décroissantes.</p>

    <highlight language="config">
      LanguagePriority en fr de
    </highlight>

    <p>Dans le cas d'une requête pour <code>foo.html</code>, si
    <code>foo.html.fr</code> et <code>foo.html.de</code> existent, et si
    le client n'a pas formulé de préférences, c'est le fichier
    <code>foo.html.fr</code> qui sera renvoyé.</p>

    <p>Notez que cette directive n'a d'effet que si le 'meilleur'
    langage n'a pas pu être déterminé d'une autre manière ou si la
    valeur de la directive  <directive
    module="mod_negotiation">ForceLanguagePriority</directive> est
    différente de <code>None</code>. En général, c'est le client qui
    détermine le langage préféré, non le serveur.</p>
</usage>
<seealso><directive module="mod_mime">AddLanguage</directive></seealso>
</directivesynopsis>

</modulesynopsis>
