<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1562488 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="netware.xml.meta">
  <parentdocument href="./">Notes spécifiques à un système</parentdocument>

  <title>Utilisation d'Apache avec Novell NetWare</title>

  <summary>

    <p>Ce document explique l'installation, la configuration et le
    lancement d'Apache 2.0 sous Novell NetWare 6.0 et les versions
    ultérieures. Si vous trouvez une bogue, ou voulez tout simplement
    contribuer de quelque manière que ce soit, utilisez s'il vous plait
    notre <a href="http://httpd.apache.org/bug_report.html">page des
    rapports de bogues.</a></p>

    <p>La page des rapports de bogues et la liste de diffusion dev-httpd
    ne doivent pas être utilisées pour poser des questions à propos de
    la configuration ou du lancement d'Apache. Avant de soumettre un
    rapport de bogue ou une question, consultez ce document, la <a
    href="http://wiki.apache.org/httpd/FAQ">FAQ</a> ou tout autre sujet de la
    documentation en rapport avec votre problème. Si vous n'avez
    toujours pas résolu votre problème, postez votre question dans le
    newsgroup <a
    href="news://developer-forums.novell.com/novell.devsup.webserver">
    novell.devsup.webserver</a>, où de nombreux utilisateurs d'Apache
    sont prêts à répondre à toutes les nouvelles et obscures questions à
    propos de l'utilisation d'Apache sous Netware.</p>

    <p>Dans la majeure partie de ce document, vous êtes sensé avoir
    installé Apache à partir d'une distribution binaire. Si vous voulez
    compiler Apache vous-même (par exemple pour aider au développement,
    ou pour rechercher des bogues), reportez-vous à la section traitant
    de la <a href="#comp">Compilation d'Apache pour Netware</a>
    ci-dessous.</p>

  </summary>

  <section id="req">

    <title>Prérequis</title>

    <p>Apache 2.0 nécessite NetWare 6.0 service pack 3 et supérieurs
    pour fonctionner. Si vous utilisez un service pack antérieur à SP3,
    vous devez installer les dernières <a
    href="http://developer.novell.com/ndk/libc.htm">Bibliothèques
    Netware pour C (LibC)</a>.</p>

    <p>Vous trouverez les service packs Netware <a
    href="http://support.novell.com/misc/patlst.htm#nw">ici</a>.</p>

    <p>Apache 2.0 pour NetWare peut aussi fonctionner dans un
    environnement NetWare 5.1, à partir du moment où le dernier service
    pack ou la dernière version des <a
    href="http://developer.novell.com/ndk/libc.htm">Bibliothèques
    Netware pour C (LibC)</a> ont été installés. <strong>ATTENTION
    :</strong> Apache 2.0 pour NetWare n'a pas été testé dans cet
    environnement car il n'a pas été conçu pour ce dernier.</p>

  </section>

  <section id="down">

    <title>Téléchargement d'Apache pour NetWare</title>

    <p>Les informations à propos de la dernière version
    d'Apache sont disponibles sur le site web d'Apache à <a
    href="http://www.apache.org/">http://www.apache.org/</a>. Vous y
    trouverez la version courante, des versions alpha ou bêta-test plus
    récentes, ainsi que des sites miroirs et des sites FTP anonymes. Les
    distributions binaires des dernières versions d'Apache 2.0 pour
    NetWare sont disponibles <a
    href="http://www.apache.org/dist/httpd/binaries/netware">ici</a>.</p>

  </section>

  <section id="inst">

    <title>Installation d'Apache pour NetWare</title>

    <p>Il n'existe pas actuellement de programme d'installation d'Apache
    pour Netware. Si vous installez Apache 2.0 pour NetWare à partir des
    sources, vous devrez copier les fichiers sur le serveur
    manuellement.</p>

    <p>Suivez ces instructions pour installer Apache sous Netware à
    partir de la distribution binaire (en supposant que vous effectuez
    l'installation dans <code>sys:/apache2</code>) :</p>

    <ul>
      <li>Décompressez le fichier binaire téléchargé à la racine du
      volume <code>SYS:</code> (vous pouvez cependant l'installer dans
      tout volume)</li>

      <li>Editez le fichier <code>httpd.conf</code> et définissez les
      directives <directive module="core">ServerRoot</directive> et
      <directive module="core">ServerName</directive> avec les valeurs
      correctes des chemins de fichiers qui correspondent à la
      configuration de votre serveur.</li>

      <li>Ajoutez <code>SYS:/APACHE2</code> au chemin de recherche, par
      une commande du style : <example>SEARCH ADD
      SYS:\APACHE2</example></li>

    </ul>

    <p>Suivez ces instructions pour installer Apache pour Netware
    manuellement à partir de votre propre répertoire de sources (en
    supposant que vous effectuez l'installation dans
    <code>sys:/apache2</code>) :</p>

    <ul>
      <li>Créez un répertoire que vous appellerez <code>Apache2</code>
      dans un volume Netware.</li>

      <li>Copiez <code>APACHE2.NLM</code>, <code>APRLIB.NLM</code> dans
      <code>SYS:/APACHE2</code>.</li>

      <li>Créez un répertoire que vous appellerez <code>BIN</code> dans
      <code>SYS:/APACHE2</code>.</li>

      <li>Copiez <code>HTDIGEST.NLM</code>, <code>HTPASSWD.NLM</code>,
      <code>HTDBM.NLM</code>, <code>LOGRES.NLM</code>,
      <code>ROTLOGS.NLM</code> dans <code>SYS:/APACHE2/BIN</code>.</li>

      <li>Créez un répertoire que vous appellerez <code>CONF</code> dans
      <code>SYS:/APACHE2</code>.</li>

      <li>Copiez le fichier <code>HTTPD-STD.CONF</code> dans le
      répertoire <code>SYS:/APACHE2/CONF</code> et renommez-le en
      <code>HTTPD.CONF</code>.</li>

      <li>Copiez les fichiers <code>MIME.TYPES</code>,
      <code>CHARSET.CONV</code> et <code>MAGIC</code> dans le répertoire
      <code>SYS:/APACHE2/CONF</code>.</li>

      <li>Copiez tous les fichiers et sous-répertoires de
      <code>\HTTPD-2.0\DOCS\ICONS</code> dans
      <code>SYS:/APACHE2/ICONS</code>.</li>

      <li>Copiez tous les fichiers et sous-répertoires de
      <code>\HTTPD-2.0\DOCS\MANUAL</code> dans
      <code>SYS:/APACHE2/MANUAL</code>.</li>

      <li>Copiez tous les fichiers et sous-répertoires de
      <code>\HTTPD-2.0\DOCS\ERROR</code> dans
      <code>SYS:/APACHE2/ERROR</code>.</li>

      <li>Copiez tous les fichiers et sous-répertoires de
      <code>\HTTPD-2.0\DOCS\DOCROOT</code> dans
      <code>SYS:/APACHE2/HTDOCS</code>.</li>

      <li>Créez le répertoire <code>SYS:/APACHE2/LOGS</code> sur le
      serveur.</li>

      <li>Créez le répertoire <code>SYS:/APACHE2/CGI-BIN</code> sur le
      serveur.</li>

      <li>Créez le répertoire <code>SYS:/APACHE2/MODULES</code> et
      copiez tous les modules nlm dans le répertoire
      <code>modules</code>.</li>

      <li>Editez le fichier <code>HTTPD.CONF</code>, et recherchez
      toutes les marques <code>@@Value@@</code> afin de les remplacer
      par les valeurs appropriées.</li>

      <li>Ajoutez <code>SYS:/APACHE2</code> au chemin de recherche, par
      une commande du style : <example>SEARCH ADD
      SYS:\APACHE2</example>.</li>
    </ul>

    <p>Outre le volume par défaut <code>SYS</code>, Apache peut être
    installé dans tout autre volume.</p>

    <p>Au cours du processus d'installation, l'ajout du mot-clé
    "install" à la ligne de commande du makefile va provoquer la
    construction d'une distribution complète sous forme d'un paquetage
    dans le sous-répertoire <code>DIST</code>. Vous pouvez simplement
    installer Apache en copiant la distribution créée précédemment à la
    racine d'un volume Netware (voir <a href="#comp">Compilation
    d'Apache pour NetWare</a> ci-dessous).</p>

  </section>

  <section id="run">

    <title>Exécuter Apache pour NetWare</title>

    <p>Pour démarrer Apache, tapez simplement <code>apache</code> dans
    la console. Ceci aura pour effet de charger Apache dans l'espace
    d'adressage du système d'exploitation. Si vous préférez charger
    Apache dans un espace d'adressage protégé, vous pouvez spécifier cet
    espace d'adressage à l'aide de l'instruction de chargement suivante
    :</p>

    <example>
      load address space = apache2 apache2
    </example>

    <p>Cette instruction va charger Apache dans un espace d'adressage
    appelé apache2. Il est possible d'exécuter plusieurs instances
    simultanées d'Apache sous Netware, en chargeant chacune d'entre
    elles dans son propre espace d'adressage protégé.</p>

    <p>Une fois démarré, Apache écoute le port 80 (à moins que vous
    n'ayez modifié la directive <directive
    module="mpm_common">Listen</directive> dans les fichiers de
    configuration). Pour vous connecter au serveur et afficher la page
    par défaut, lancez un navigateur et entrez le nom du serveur ou son
    adresse IP. Vous devriez voir une page de bienvenue, et un lien vers
    le manuel Apache. Si rien ne se produit, ou si vous obtenez un
    message d'erreur, consultez le fichier <code>error_log</code> dans
    le répertoire <code>logs</code>.</p>

    <p>Lorsque votre installation de base fonctionne, vous devez la
    configurer correctement en éditant les fichiers du répertoire
    <code>conf</code>.</p>

    <p>Pour arrêter une instance d'Apache s'exécutant dans l'espace
    d'adressage du système d'exploitation, entrez simplement dans la
    console :</p>

    <example>
      unload apache2
    </example>

    <p>ou</p>

    <example>
      apache2 shutdown
    </example>

    <p>Si Apache s'exécute dans un espace d'adressage protégé, spécifiez
    cet espace d'adressage dans l'instruction d'arrêt :</p>

    <example>
      unload address space = apache2 apache2
    </example>

    <p>Lorsqu'on travaille avec Apache, il est important de savoir
    comment il trouve ses fichiers de configuration. Vous pouvez
    spécifier un fichier de configuration sur la ligne de commande de
    deux manières :</p>

    <ul>
      <li><code>-f</code> spécifie un chemin vers un fichier de
      configuration particulier</li>
    </ul>

    <example>
      apache2 -f "vol:/nom-serveur/conf/fich-conf.conf"
    </example>

    <example>
      apache -f test/test.conf
    </example>

    <p>Dans ces cas, la directive <directive
    module="core">ServerRoot</directive> doit être correctement définie
    dans le fichier de configuration.</p>

    <p>Si vous ne spécifiez pas de nom de fichier de configuration avec
    l'option <code>-f</code>, Apache utilisera le nom de fichier codé en
    dur dans le serveur, en général <code>conf/httpd.conf</code>.
    L'invocation d'Apache avec l'option <code>-V</code> indiquera ce nom
    comme valeur de l'étiquette <code>SERVER_CONFIG_FILE</code>. Apache
    va ensuite déterminer son <directive
    module="core">ServerRoot</directive> en effectuant les tests
    suivants, dans cet ordre </p>

    <ul>
      <li>Une directive <code>ServerRoot</code> via une option
      <code>-C</code> switch.</li>

      <li>L'option de ligne de commande <code>-d</code>.</li>

      <li>Le contenu du répertoire courant.</li>

      <li>La racine du répertoire d'installation codée en dur dans le
      serveur.</li>
    </ul>

    <p>La racine du répertoire d'installation codée en dur dans le
      serveur est en général <code>sys:/apache2</code>. L'invocation
      d'Apache avec l'option <code>-V</code> indiquera ce chemin comme
      valeur de l'étiquette <code>HTTPD_ROOT</code>.</p>

    <p>Apache 2.0 pour Netware comporte un jeu d'options de ligne de
    commande permettant d'afficher ou de modifier certaines
    caractéristiques de l'instance du serveur web en cours d'exécution.
    Ces options ne sont disponibles que lorsqu'Apache est en cours
    d'exécution. Chacune de ces options doit être précédée du mot-clé
    <code>APACHE2</code>.</p>

    <dl>
      <dt>RESTART</dt>
      <dd>Demande à Apache d'arrêter tout worker thread en cours
      d'exécution lorsqu'il devient inactif, de recharger le fichier de
      configuration, et de redémarrer chaque worker thread en fonction
      de la nouvelle configuration.</dd>

      <dt>VERSION</dt>
      <dd>Affiche des informations à propos de la version de l'instance
      d'Apache en cours d'exécution.</dd>

      <dt>MODULES</dt>
      <dd>Affiche la liste des modules chargés (intégrés et
      externes). </dd>

      <dt>DIRECTIVES</dt>
      <dd>Affiche la liste des directives disponibles.</dd>

      <dt>SETTINGS</dt>
      <dd>Active ou désactive l'affichage du statut des threads sur la
      console. En cas d'activation, l'état de chaque thread en cours
      d'exécution s'affiche sur l'écran de la console Apache.</dd>

      <dt>SHUTDOWN</dt>
      <dd>Arrête l'instance du serveur web Apache en cours
      d'exécution.</dd>

      <dt>HELP</dt>
      <dd>Décrit chacune des options disponibles au cours de l'exécution
      d'Apache.</dd>
    </dl>

    <p>Par défaut, ces options sont passées à l'instance d'apache
    s'exécutant dans l'espace d'adressage du système d'exploitation.
    Pour passer une option à une instance d'Apache spécifique
    s'exécutant dans un espace d'adressage protégé, ajouter le paramètre
    -p suivi du nom de l'espace d'adressage. Pour plus d'informations,
    tapez "apache2 Help" sur la ligne de commande.</p>

  </section>

  <section id="use">

    <title>Configuration d'Apache pour NetWare</title>

    <p>Apache lit en général ses fichiers de configuration dans le
    répertoire <code>conf</code>. Ces fichiers sont les mêmes que ceux
    de la version Unix, mais quelques directives sont différentes sous
    Netware. Voir la <a href="../mod/">Documentation Apache</a> pour
    l'ensemble des directives disponibles.</p>

    <p>Les principales différences propres à Apache pour NetWare sont
    : </p>

    <ul>
      <li>
        <p>Comme Apache pour Netware est une application multithread,
	elle n'utilise pas de processus séparé pour chaque requête,
	comme c'est le cas pour certaines implémentations sous Unix. Il
	n'y a que des threads en cours d'exécution : un thread parent,
	et plusieurs threads enfants ou worker qui traitent les
	requêtes.</p>

        <p>En conséquence, les directives de gestion des "processus"
	sont différentes :</p>

        <p><directive
	module="mpm_common">MaxConnectionsPerChild</directive> - comme sous
	Unix, cette directive contrôle le nombre maximum de connexions
	qu'un worker thread peut traiter avant de s'arrêter. Avec la
	valeur par défaut <code>MaxConnectionsPerChild 0</code>,
	le thread va pouvoir traiter un nombre illimité de requêtes.
	Cette valeur est recommandée sous Netware, à moins que vous
	n'ayez des raisons particulières de la modifier.</p>

        <p><directive module="mpm_common">StartThreads</directive> -
	Cette directive indique au serveur le nombre de threads qu'il
	doit lancer au démarrage. Il est recommandé de conserver la
	valeur par défaut <code>StartThreads 50</code>.</p>

        <p><directive module="mpm_common">MinSpareThreads</directive> -
	Cette directive indique au serveur le nombre de worker threads
	additionnels qu'il doit lancer si le nombre de threads inactifs
	tombe en dessous de cette valeur. Il est recommandé de conserver la
	valeur par défaut <code>MinSpareThreads 10</code>.</p>

        <p><directive module="mpm_common">MaxSpareThreads</directive> -
	Cette directive indique au serveur qu'il doit commencer à
	arrêter des worker threads si le nombre de threads inactifs
	passe au dessus de cette valeur. Il est recommandé de conserver
	la valeur par défaut <code>MaxSpareThreads 100</code>.</p>

        <p><directive module="mpm_netware">MaxThreads</directive> -
	Cette directive impose un nombre maximum de worker threads. Il
	est recommandé de conserver la valeur par défaut
	<code>ThreadsPerChild 250</code>.</p>

        <p><directive module="mpm_common">ThreadStackSize</directive> -
	Cette directive indique au serveur la taille de la pile à
	utiliser pour un worker thread individuel. Il est recommandé de
	conserver la valeur par défaut <code>ThreadStackSize
	65536</code>.</p>
      </li>

      <li>
        <p>Les directives qui acceptent des noms de fichiers comme
	arguments ne doivent pas utiliser des noms de fichiers Unix,
	mais des noms de fichiers Netware. Cependant, comme Apache
	utilise des noms de style Unix en interne, on doit utiliser des
	slashes et non des antislashes. Il est recommandé de préfixer
	tous les chemins de fichiers racines par un nom de volume. Si ce
	dernier est omis, Apache supposera que le volume est
	<code>SYS:</code>, ce qui n'est pas forcément correct.</p>
      </li>

      <li>
        <p>Apache pour Netware a la possibilité de charger des modules
	en cours d'exécution, sans avoir à recompiler le serveur. Si
	Apache est compilé avec les options par défaut, il va installer
	de nombreux modules optionnels dans le répertoire
	<code>\Apache2\modules</code>. Pour les activer, ou en activer
	d'autres, on doit utiliser la directive <directive
        module="mod_so">LoadModule</directive>. Par exemple, pour
	activer le module status, ajoutez la ligne suivante :</p>

        <example>
          LoadModule status_module modules/status.nlm
        </example>

        <p>Des informations à propos de la  <a
        href="../mod/mod_so.html#creating">création de modules
	chargeables</a> sont aussi disponibles.</p>
      </li>
    </ul>

    <section id="use-add">

      <title>Autres directives spécifiques à Netware :</title>

      <ul>
        <li><directive module="core">CGIMapExtension</directive> -
        Cette directive associe une extension de fichier CGI à un
	interpréteur de script.</li>
      </ul>
      <ul>
        <li><directive module="mod_nw_ssl">SecureListen</directive> -
        Cette directive active le chiffrement SSL pour un port
	spécifique.</li>
      </ul>
      <ul>
        <li><directive module="mod_nw_ssl">NWSSLTrustedCerts</directive> -
        Cette directive permet d'ajouter des certificats de confiance
	pouvant être utilisés pour créer des connexions sécurisées vers
	des serveurs mandataires.</li>
      </ul>
      <ul>
        <li><directive module="mod_nw_ssl">NWSSLUpgradeable</directive> -
        Cette directive permet de faire passer en SSL une connexion
	initialisée sur les adresse IP et Port spécifiés.</li>
      </ul>

    </section>

  </section>

  <section id="comp">

    <title>Compilation d'Apache pour NetWare</title>

    <p>La compilation d'Apache nécessite MetroWerks CodeWarrior 6.x ou
    supérieur. Une fois compilé, Apache peut être installé à la racine
    de tout volume Netware. Le répertoire d'installation par défaut est
    <code>sys:/Apache2</code>.</p>

    <p>Avant de démarrer Apache, vous devez remplir le répertoire
    <code>conf</code>. Copiez le fichier <code>HTTPD-STD.CONF</code>
    depuis le répertoire <code>conf</code> de la distribution et
    renommez-le en <code>HTTPD.CONF</code>. Editez le fichier
    <code>HTTPD.CONF</code> en recherchant les repères
    <code>@@Value@@</code>, et remplacez ces derniers par la valeur
    appropriée. Copiez de même les fichiers <code>conf/magic</code> et
    <code>conf/mime.types</code>. Vous pouvez aussi construire une
    distribution complète en ajoutant le mot-clé <code>install</code>
    lors de l'invocation des makefiles.</p>

    <section id="comp-req">

      <title>Prérequis :</title>

      <p>Les outils de développement suivants sont nécessaires pour la
      compilation d'Apache pour Netware :</p>

      <ul>
        <li>Metrowerks CodeWarrior 6.0 ou supérieur avec le <a
	href="http://developer.novell.com/ndk/cwpdk.htm">NetWare PDK
	3.0</a> ou supérieur.</li>

        <li>Les <a
	href="http://developer.novell.com/ndk/libc.htm">Bibliothèques
	Netware pour C (LibC)</a></li>

        <li>Les <a
	href="http://developer.novell.com/ndk/cldap.htm">Bibliothèques
	LDAP pour C</a></li>

        <li>Le <a href="http://www.gzip.org/zlib/">Code source de la
	bibliothèque de compression ZLIB</a></li>

        <li>L'utilitaire AWK (awk, gawk ou similaire). AWK peut être
	téléchargé à <a
	href="http://developer.novell.com/ndk/apache.htm"
	>http://developer.novell.com/ndk/apache.htm</a>.
	L'utilitaire doit se trouver dans votre chemin windows et avoir
	pour nom <code>awk.exe</code>.</li>

        <li>Pour utiliser les makefiles, vous devez disposer de GNU make
	version 3.78.1 (GMake) disponible à <a
	href="http://developer.novell.com/ndk/apache.htm"
	>http://developer.novell.com/ndk/apache.htm</a>.</li>
      </ul>

    </section>

    <section id="comp-make">

      <title>Compiler Apache en utilisant les makefiles Netware
      :</title>

      <ul>
        <li>Définissez la variable d'environnement
	<code>NOVELLLIBC</code> avec le chemin des bibliothèques Netware
	pour C SDK ; par exemple : <example>Set
	NOVELLLIBC=c:\novell\ndk\libc</example></li>

        <li>Définissez la variable d'environnement
	<code>METROWERKS</code> avec le chemin de votre compilateur
	Metrowerks CodeWarrior ; par exemple : <example>Set
	METROWERKS=C:\Program Files\Metrowerks\CodeWarrior</example>. Si
	vous l'avez installé dans le répertoire par défaut
	<code>C:\Program Files\Metrowerks\CodeWarrior</code>, vous
	n'avez pas besoin de définir cette variable.</li>

        <li>Définissez la variable d'environnement <code>LDAPSDK</code>
	avec le chemin des bibliothèques LDAP pour C ; par exemple :
	<example>Set
	LDAPSDK=c:\Novell\NDK\cldapsdk\NetWare\libc</example></li>

        <li>Définissez la variable d'environnement <code>ZLIBSDK</code>
	avec le chemin du code source de la bibliothèque Zlib ; par
	exemple : <example>Set ZLIBSDK=D:\NOVELL\zlib</example></li>

	<li>Définissez la variable d'environnement <code>PCRESDK</code>
	avec le chemin d'installation du code source de la bibliothèque
	PCRE ; par exemple :
	<example>Set PCRESDK=D:\NOVELL\pcre</example>
	</li>

        <li>Définissez la variable d'environnement <code>AP_WORK</code>
	avec le chemin du code source de <code>httpd</code>.
	<example>Set AP_WORK=D:\httpd-2.0.x</example></li>

        <li>Définissez la variable d'environnement <code>APR_WORK</code>
	avec le chemin du code source d'<code>apr</code> ; en général
	<code>\httpd\srclib\apr</code>, mais le projet APR peut se
	trouver en dehors de la structure des répertoires de httpd.
	<example>Set APR_WORK=D:\apr-1.x.x</example></li>

        <li>Définissez la variable d'environnement <code>APU_WORK</code>
	avec le chemin du code source d'<code>apr-util</code> ; en
	général <code>\httpd\srclib\apr-util</code>, mais le projet
	APR-UTIL peut se trouver en dehors de la structure des
	répertoires de httpd. <example>Set
	APU_WORK=D:\apr-util-1.x.x</example></li>

        <li>Vérifiez que les chemins des utilitaires AWK et GNU make
	(<code>gmake.exe</code>) ont bien été inclus dans la variable
	d'environnement système <code>PATH</code>.</li>

        <li>Téléchargez le code source et décompressez-le dans un
	répertoire de votre choix sur votre station de travail.</li>

        <li>Positionnez-vous dans le répertoire <code>\httpd-2.0</code>
	et compilez les utilitaires précompilés à l'aide de la commande
	"<code>gmake -f nwgnumakefile prebuild</code>". Cette cible va
	créer le répertoire <code>\httpd-2.0\nwprebuild</code>, et y
	copier tous les utilitaires nécessaires au franchissement des
	étapes suivantes de la compilation.</li>

        <li>Copiez les fichiers
	<code>\httpd-2.0\nwprebuild\GENCHARS.nlm</code> et
	<code>\httpd-2.0\nwprebuild\DFTABLES.nlm</code> vers le volume
	<code>SYS:</code> d'un serveur Netware et exécutez-les à l'aide
	des commandes suivantes :
          <example>
            SYS:\genchars &gt; sys:\test_char.h<br />
            SYS:\dftables sys:\chartables.c<br />
          </example>
        </li>

        <li>Copiez les fichiers <code>test_char.h</code> et
	<code>chartables.c</code> vers le répertoire
	<code>\httpd-2.0\os\netware</code> de la machine où s'effectue
	la compilation.</li>

        <li>Positionnez-vous dans le répertoire <code>\httpd-2.0</code>
	et compilez Apache à l'aide de la commande "<code>gmake -f
	nwgnumakefile</code>". Vous pouvez créer un répertoire pour la
	distribution en ajoutant le paramètre install à la commande ;
	par exemple :
        <example>gmake -f nwgnumakefile install</example>
        </li>
      </ul>

    </section>

    <section id="comp-add">

      <title>Options de make supplémentaires</title>

      <ul>
        <li><code>gmake -f nwgnumakefile</code><p>Compile les versions
	de distribution de tous les binaires et les copie dans un
	répertoire <code>\release</code>.</p></li>

        <li><code>gmake -f nwgnumakefile DEBUG=1</code><p>Compile les versions
	de débogage de tous les binaires et les copie dans un
	répertoire <code>\debug</code>.</p></li>

        <li><code>gmake -f nwgnumakefile install</code><p>Crée une
	distribution complète d'Apache avec les binaires, la
	documentation et les fichiers support dans un répertoire
	<code>\dist\Apache2</code>.</p></li>

        <li><code>gmake -f nwgnumakefile prebuild</code><p>Compile tous
	les utilitaires précompilés et les copie dans le répertoire
	<code>\nwprebuild</code>.</p></li>

        <li><code>gmake -f nwgnumakefile installdev</code><p>Même effet
	que l'option install, mais en plus, les répertoires
	<code>\lib</code> et <code>\include</code> sont créés dans le
	répertoire de destination, et les en-têtes et fichiers d'import
	y sont copiés.</p></li>

        <li><code>gmake -f nwgnumakefile clean</code><p>Supprime tous
	les fichiers objets et les binaires de la zone de compilation
	<code>\release.o</code>, ou <code>\debug.o</code> si
	<code>DEBUG</code> a été défini.</p></li>

        <li><code>gmake -f nwgnumakefile clobber_all</code><p>Même effet
	que clean, mais en plus, le répertoire de la distribution est
	supprimé s'il existe.</p></li>
      </ul>

    </section>

    <section id="comp-add-env">

      <title>Variables d'environnement supplémentaires</title>

      <ul>
        <li>Pour compiler tous les modules expérimentaux, définissez la
	variable d'environnement <code>EXPERIMENTAL</code> :
        <example>Set EXPERIMENTAL=1</example>
        </li>

        <li>Pour compiler Apache en utilisant les sockets de style BSD
	standard, plutôt que Winsock, définissez la variable
	d'environnement <code>USE_STDSOCKETS</code> :
        <example>Set USE_STDSOCKETS=1</example>
        </li>

      </ul>

    </section>

    <section id="comp-mod_ssl">

      <title>Compilation de mod_ssl pour la plate-forme Netware</title>

      <p>Pour fournir les services SSL, Apache pour Netware utilise par
      défaut le module intégré <module>mod_nw_ssl</module>. Ce module ne
      fournit que les services SSL implémentés par le système
      d'exploitation Netware lui-même pour gérer tous les chiffrements
      pour un port donné. Cependant, on peut aussi utiliser mod_ssl de
      la même manière que sur les autres plate-formes.</p>

      <p>Afin de pouvoir compiler mod_ssl pour la plate-forme Netware,
      les bibliothèques OpenSSL doivent être disponibles. Elles peuvent
      être installées de la manière suivante :</p>

      <ul>
          <li>Téléchargez la dernière distribution du code source
	  d'OpenSSL 0.9.8 depuis la page <a
	  href="http://www.openssl.org/source/">OpenSSL Source</a> (les
	  versions 0.9.7 doivent être patchées, et ne sont donc pas
	  recommandées).</li>

          <li>Editez le fichier <code>NetWare/set_env.bat</code>, et
	  effectuez toutes modifications nécessaires des chemins des
	  outils et utilitaires en fonction de votre environnement de
	  développement.</li>

          <li>Exécutez les scripts suivants depuis la racine du
	  répertoire des sources d'OpenSSL :
          <example>
              Netware\set_env netware-libc<br />
              Netware\build netware-libc
          </example>
          Pour des raisons de performances, vous devez activer la
	  compilation avec le code ASM. Télécharger NASM depuis le <a
	  href="http://nasm.sourceforge.net/">site SF</a>. Configurez
	  ensuite OpenSSL pour utiliser le code ASM :
          <example>
              Netware\build netware-libc nw-nasm enable-mdc2 enable-md5
          </example>
          Attention : n'utilisez pas l'Assembleur CodeWarrior - il
	  produit un code de mauvaise qualité !</li>

          <li>Avant de compiler Apache, définissez la variable
	  d'environnement <code>OSSLSDK</code> avec le chemin absolu de
	  la racine du répertoire du code source d'openssl, et
	  définissez WITH_MOD_SSL à 1.
          <example>
              Set OSSLSDK=d:\openssl-0.9.8x<br />
              Set WITH_MOD_SSL=1
          </example></li>

      </ul>

    </section>

  </section>

</manualpage>

