<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1791236 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="win_compiling.xml.meta">
  <parentdocument href="./">Notes spécifiques à certaines
  plates-formes</parentdocument>

  <title>Compiler Apache pour Microsoft Windows</title>

  <summary>

    <p>Il y a de nombreux points importants à connaître avant de
    compiler Le serveur HTTP Apache pour Microsoft Windows. Avant de commencer, lisez le
    document <a href="windows.html">Utiliser le serveur HTTP Apache avec Microsoft
    Windows</a>.</p>

    <p>httpd peut être compilé sous Windows en utilisant une chaîne de
    compilation basée sur cmake, ou à partir de fichiers projet Visual
    Studio maintenus par les développeurs de httpd. La chaîne de
    compilation basée sur cmake supporte directement davantage de
    versions de Visual Studio, mais possède actuellement des
    fonctionnalités très limitées.</p>

  </summary>

  <section id="requirements">

    <title>Prérequis</title>

    <p>Pour compiler Apache, l'environnement doit satisfaire aux
    conditions suivantes :</p>

    <ul>
      <li>
        <p>Espace disque</p>

        <p>Assurez-vous de disposer d'un minimum de 200 Mo d'espace
	disque disponible. Après l'installation, Apache occupe environ
	80 Mo d'espace disque, plus l'espace réservé aux journaux et au
	cache, la taille de ces derniers pouvant augmenter rapidement.
	Les besoins réels en espace disque dépendent étroitement de la
	configuration choisie et des bibliothèques ou modules tiers
	installés, en particulier lorsqu'OpenSSL est mis en oeuvre.
	Comme de nombreux fichiers sont au format texte et donc
	facilement compressibles, l'utilisation de la compression du
	système de fichiers NTFS divise ces besoins par deux.</p>
      </li>

      <li>
        <p>Correctifs requis</p>

        <p>Le binaire httpd est compilé à l'aide de nombreux correctifs
	appliqués aux paquets tiers, ce qui permet de s'assurer que le
	code fourni est bien compilable et déboguable. Ces correctifs
	sont disponibles à <a
        href="http://www.apache.org/dist/httpd/binaries/win32/patches_applied/"
        >http://www.apache.org/dist/httpd/binaries/win32/patches_applied/</a>,
	et il est recommandé de les appliquer afin d'obtenir un
	résultat identique aux binaires "officiels" distribués par
	l'ASF.</p>
      </li>

      <li>
        <p>Microsoft Visual C++ 6.0 (Visual Studio 97) ou supérieur.</p>

        <p>Apache peut être compilé en utilisant l'outil ligne de
	commande, ou depuis l'espace de travail IDE Visual Studio. Pour
	la compilation depuis la ligne de commandes, l'environnement
	doit comporter les variables the <code>PATH</code>,
	<code>INCLUDE</code>, <code>LIB</code>, ainsi que d'autres
	variables qui peuvent être définies via le script
	<code>vcvars32.bat</code> :</p>

        <note>Vous pouvez vous procurer le paquet du Processeur Visual
	Studio pour votre ancienne version de Visual Studio, ou une
	version complète (et non Express) d'une édition plus récente de
	Visual Studio pour l'assembleur ml.exe. Ceci vous permettra, si
	vous le souhaitez, de compiler OpenSSL en utilisant une
	implémentation du code d'assemblage plus efficace.</note>

        <note>Seule la chaîne d'outils de compilation de Microsoft est
	supportée de manière suivie par les contributeurs actifs à httpd.
	Bien que le projet accepte régulièrement des correctifs pour
	s'assurer que MinGW et d'autre outils de compilation
	fonctionnent, ou même pour les améliorer, ils ne sont pas
	maintenus de manière suivie et sont même souvent hors d'état
	de fonctionner à certains stades du développement normal.</note>
      </li>

      <li>
        <p>Le SDK de la plate-forme Windows mis à jour, février 2003 ou
	plus récent.</p>

	<p>Un SDK approprié pour la plate-forme Windows est inclus par
	défaut dans les versions complètes (et non Express/lite) de
	Visual C++ 7.1 (Visual Studio 2002) et supérieures ; les
	utilisateurs peuvent ignorer ces étapes, à moins qu'ils aient
	choisi d'utiliser une version plus récente ou différente du SDK.</p>

	<p>Pour pouvoir utiliser Visual C++ 6.0 or 7.0 (Studio 2000
	.NET), l'environnement du SDK de la plate-forme doit être préparé en utilisant le
	script <code>setenv.bat</code> (installé par le SDK de la plate-forme) avant de
	lancer la compilation en ligne de commande ou l'interface GUI
	msdev/devenv. L'installation du SDK de la plate-forme pour les
	versions Express de Visual Studio (2003 et supérieures) devrait
	ajuster l'environnement par défaut de manière appropriée.</p>

        <example>
	  "c:\Program Files\Microsoft Visual Studio\VC98\Bin\VCVARS32"<br />
          "c:\Program Files\Platform SDK\setenv.bat"
        </example>


      </li>

      <li>
        <p>Perl et awk</p>

	<p>De nombreuses étapes recommandées ici nécessitent un
	interpréteur perl durant le processus de préparation de la
	compilation.</p>

        <p>Pour installer Apache à partir du système de compilation, de
	nombreux fichiers sont modifiés via l'utilitaire
	<code>awk.exe</code>. awk effectue la modification des fichiers
	au moment de l'installation ; il a été choisi car il nécessite
	un téléchargement de petite taille (par rapport à Perl ou
	WSH/VB). Le site de Brian Kernighan <a
	href="http://www.cs.princeton.edu/~bwk/btl.mirror/"
        >http://www.cs.princeton.edu/~bwk/btl.mirror/</a> propose un
	binaire précompilé pour Win32, <a
	href="http://www.cs.princeton.edu/~bwk/btl.mirror/awk95.exe"
        >http://www.cs.princeton.edu/~bwk/btl.mirror/awk95.exe</a>, que
	vous devez enregistrer sous le nom <code>awk.exe</code> (plutôt
	que <code>awk95.exe</code>).</p>

        <note>Si awk.exe n'est pas trouvé, la cible install du fichier
	Makefile.win n'effectuera aucune substitution dans les fichiers
	.conf installés. Vous devez modifier manuellement les fichiers
	.conf installés afin de permettre au serveur de démarrer.
	Recherchez et remplacez toutes les balises "@token@" par une
	valeur appropriée.</note>

        <note>L'IDE Visual Studio ne trouvera le chemin de
	<code>awk.exe</code> que dans la variable PATH, ou dans le
	chemin des exécutables spécifié par l'option de menu Tools -&gt;
	Options -&gt; (Projects -&gt;) Directories. Assurez-vous
	qu'awk.exe est bien dans votre chemin système.</note>

        <note>Notez aussi, si vous utilisez les outils Cygwin (<a
	href="http://www.cygwin.com/">http://www.cygwin.com/</a>), que
	l'utilitaire awk de nomme <code>gawk.exe</code> et que le
	fichier <code>awk.exe</code> est en fait un lien symbolique vers
	le fichier <code>gawk.exe</code>. Le shell de commandes Windows
	ne reconnaît pas les liens symboliques, et par conséquent la
	compilation d'InstallBin échouera. Pour contourner le problème,
	vous pouvez supprimer le lien <code>awk.exe</code> de
	l'installation de Cygwin, et copier <code>gawk.exe</code> vers
	<code>awk.exe</code>. Notez aussi que les portages cygwin/mingw
	de gawk 3.0.x étaient bogués ; veuillez par conséquent effectuer
	une mise à jour vers la	version 3.1.x avant l'utilisation de
	tout portage de gawk.</note>
      </li>

      <li>
        <p>[Optionnel] bibliothèque zlib (pour le module
	<module>mod_deflate</module>)</p>

        <p>Zlib doit être installée dans un sous-répertoire du
	répertoire <code>srclib</code> et nommé <code>zlib</code>. Elle
	doit être compilée directement à cette place. Zlib est
	disponible à l'adresse <a
	href="http://www.zlib.net/">http://www.zlib.net/</a> -- le
	fonctionnement correct du module <module>mod_deflate</module> a
	été vérifié avec la version 1.2.3.</p>

        <example>
          nmake -f win32\Makefile.msc<br />
          nmake -f win32\Makefile.msc test
        </example>
      </li>

      <li>
        <p>[Optionnel] Bibliothèques OpenSSL (pour le module
	<module>mod_ssl</module> et <code>ab.exe</code> avec le support
	ssl)</p>

	<note>La bibliothèque OpenSSL est un logiciel de chiffrement. Le
	pays dans lequel vous résidez peut imposer des restrictions à
	l'importation, la possession, l'utilisation, et/ou la
	réexportation vers un autre pays des logiciels de chiffrement.
	AVANT d'utiliser tout logiciel de chiffrement, veuillez
	consulter la législation de votre pays, les règles et politiques
	d'importation, de possession, ou d'utilisation, et de
	réexportation des logiciels de chiffrement, afin de déterminer
	si vous en avez le droit. Voir <a
	href="http://www.wassenaar.org/">http://www.wassenaar.org/</a>
	pour plus de détails.</note>

        <p>La configuration et la compilation d'OpenSSL nécessite
	l'installation de perl.</p>

        <p>Pour pouvoir compiler <module>mod_ssl</module> ou le projet
	<code>abs.exe</code>, qui devient ab.c avec le support SSL
	activé, vous devez
	télécharger OpenSSL à l'adresse <a
	href="http://www.openssl.org/source/">http://www.openssl.org/source/</a>,
	et l'installer dans un sous-répertoire du répertoire
	<code>srclib</code> que vous nommerez <code>openssl</code>. Afin
	de préparer OpenSSL à la liaison avec le module Apache mod_ssl
	ou abs.exe, et désactiver les fonctionnalités d'Openssl grévées
	de brevets, vous pouvez utiliser la commande de compilation
	suivante :</p>

        <example>
          perl Configure no-rc5 no-idea enable-mdc2 enable-zlib VC-WIN32
               -Ipath/to/srclib/zlib -Lpath/to/srclib/zlib<br />
          ms\do_masm.bat<br />
          nmake -f ms\ntdll.mak
        </example>

        <note>Il est déconseillé d'utiliser zlib-dynamic, car la charge
	de la décompression des flux SSL est alors transférée à la
	première requête qui doit charger la dll zlib. Notez que le
	correctif proposé active le drapeau -L afin de pouvoir
	fonctionner avec les compilations Windows, corrige le nom de
	zdll.lib et s'assure que les fichiers .pdb sont générés afin de
	pouvoir résoudre les problèmes. Si l'assembleur n'est pas
	installé, vous devez ajouter no-asm ci-dessus et utiliser le
	script ms\do_ms.bat à la place de ms\do_masm.bat.</note>
      </li>

      <li>
        <p>[Optionnel] Bibliothèques de bases de données (pour
<module>mod_dbd</module> et <module>mod_authn_dbm</module>)</p>

        <p>La bibliothèque apr-util fournit un accès aux fonctionnalités
	clients dbm (base de données à base de clés) et dbd (base de
	données à base de requêtes) au serveur httpd et à certains de
	ses modules, comme les modules d'authentification et
	d'autorisation. Les fournisseurs sdbm dbm et odbc dbd sont
	compilés automatiquement.</p>

        <p>Le support dbd inclut le paquet instantclient Oracle, MySQL,
	PostgreSQL et sqlite. Par exemple, pour les compiler tous,
	définissez LIB de façon à inclure le chemin des bibliothèques,
	INCLUDE de façon à inclure le chemin des en-têtes, et PATH de
	façon à inclure le chemin des dll et bin de chacun des quatre
	SDK, et définissez la variable d'environnement DBD_LIST de façon
	à indiquer au processus de compilation quels SDKs pilotes
	clients du sont correctement installés ; par exemple :</p>

        <example>
          set DBD_LIST=sqlite3 pgsql oracle mysql
        </example>

        <p>De manière similaire, le support dbm peut être étendu avec
	DBM_LIST pour compiler un fournisseur Berkeley DB (db) et/ou un
	fournisseur gdbm, en configurant tout d'abord de la même manière
	LIB, INCLUDE et PATH afin de s'assurer que les bibliothèques et
	en-têtes de la bibliothèque client sont bien disponibles.</p>

        <example>
          set DBM_LIST=db gdbm
        </example>

        <note>En fonction du choix des distributions de bases de
	données, il peut s'avérer nécessaire de modifier le nom des
	cibles de l'édition de liens (par exemple gdbm.lib à la place de
	libgdb.lib) listées dans les fichiers .dsp/.mak des répertoires
	srclib\apr-util\dbd ou ...\dbm correspondants.</note>

        <p>Voir le fichier README-win32.txt pour plus d'informations à
	propos de l'obtention des différents SDKs pilotes de bases de
	données.</p>
      </li>

    </ul>

  </section>

<section id="unixsrcbuild">

    <title>Compilation à partir des sources Unix</title>

    <p>Le projet du serveur HTTP Apache à pour politique de ne fournir
    que des sources de type Unix. Les paquets source de type Windows
    disponibles en téléchargement ont été élaborés par des
    contributeurs, et ne seront pas forcément reconduits pour toutes les
    versions. Vous pouvez cependant compiler le serveur sous Windows à
    partir des sources Unix en ajoutant quelques étapes supplémentaires.</p>

    <ol>
    	<li>Téléchargez et ouvrez le tarball source Unix de la dernière
	version du serveur HTTP Apache.</li>
    	<li>Téléchargez et ouvrez le tarball source Unix de la dernière
	version de APR, APR-Util et APR-Iconv, et copier l'arborescence
	obtenue dans httpd-2.x.x\srclib\apr, httpd-2.x.x\srclib\apr-util
	et httpd-2.x.x\srclib\apr-iconv</li>
    	<li>Ouvrez la console et placez-vous au niveau du répertoire httpd-2.x.x</li>
    	<li>Exécutez l'utilitaire de conversion de fins de ligne</li>
    </ol>

    <example>
      perl srclib\apr\build\lineends.pl
    </example>

    <p>Vous pouvez maintenant compiler le serveur via l'environnement de
    développement Visual Studio en utilisant l'IDE. Les compilations
    du serveur en ligne de commande ne sont possibles avec des sources
    de type Unix que si vous exportez les fichiers .mak comme indiqué
    ci-dessous.
    </p>

  </section>

  <section id="commandbuild">

    <title>Compilation à partir de la ligne de commandes</title>

    <p><code>Makefile.win</code> est le makefile principal ou racine
    d'Apache. Pour compiler Apache sous Windows, utilisez simplement une
    des commandes suivantes pour compiler la version
    <code>release</code> ou <code>debug</code> :</p>

    <example>
      nmake /f Makefile.win _apacher<br /><br />
      nmake /f Makefile.win _apached
    </example>


    <p>Ces deux commandes effectuent la compilation d'Apache. Cependant,
    avec la deuxième, les fichiers résultants ne seront pas optimisés,
    ce qui va faciliter l'examen pas à pas du code pour trouver des
    bogues et résoudre les problèmes.</p>

    <p>Vous pouvez indiquer vos choix en matière de fournisseurs dbd et
    dbm à l'aide des variables (d'environnement) additionnelles de make
    DBD_LIST et DBM_LIST ; voir les commentaires à propos des
    [Optionnel] Bibliothèques de bases de données ci-dessus. Consultez
    les commentaires initiaux dans Makefile.win pour plus d'options
    pouvant être fournies lors de la compilation.</p>

  </section>

  <section id="workspacebuild">

    <title>Compilation depuis l'espace de travail IDE de Developer
    Studio</title>

    <p>Apache peut aussi être compilé depuis l'environnement de
    développement Visual Studio de VC++. Pour simplifier ce processus,
    l'espace de travail Visual Studio <code>Apache.dsw</code> est
    fourni. Cet espace de travail expose la liste complète des projets
    <code>.dsp</code> actifs nécessaires à l'installation binaire
    complète d'Apache. Il inclut les dépendances entre projets afin que
    ces derniers soient compilés selon l'ordre approprié.</p>

    <p>Ouvrez l'espace de travail <code>Apache.dsw</code>, et
    sélectionnez <code>InstallBin</code> (compilation
    <code>Release</code> ou <code>Debug</code>, selon vos souhaits)
    comme Active Project. <code>InstallBin</code> provoque la
    compilation de tous les projets concernés, puis invoque
    <code>Makefile.win</code> pour installer les exécutables et dlls
    compilés. Vous pouvez modifier la valeur de <code>INSTDIR=</code>
    via la configuration de <code>InstallBin</code>, onglet Général,
    entrée ligne de commandes de compilation. La valeur par défaut de
    <code>INSTDIR</code> est le répertoire <code>/Apache2</code>. Si
    vous désirez effectuer un test de compilation (sans installation),
    sélectionnez le projet <code>BuildBin</code>.</p>

    <p>Les fichiers projets <code>.dsp</code> sont distribués au format
    Visual Studio 6.0 (98). Visual C++ 5.0 (97) les reconnaît. Les
    utilisateurs de Visual Studio 2002 (.NET) et versions supérieures
    doivent convertir <code>Apache.dsw</code> et les fichiers
    <code>.dsp</code> en un projet <code>Apache.sln</code>, ainsi que
    les fichiers <code>.msproj</code> ; assurez-vous de reconvertir le
    fichier <code>.msproj</code> si l'un des fichiers source
    <code>.dsp</code> est modifié ! Cette opération est vraiment très
    simple, il suffit de réouvrir <code>Apache.dsw</code> dans l'IDE
    VC++ 7.0 et de le reconvertir.</p>

    <!-- Traduction à revoir -->
    <note>Il y a une erreur dans la conversion .vcproj des fichiers
    .dsp. devenv.exe interprète mal le drapeau
    /D pour les drapeaux RC contenant de grandes /D'éfinitions entourées
    de guillemets, et contenant elles-mêmes des espaces. Ainsi, la
    commande :
    <example>
      perl srclib\apr\build\cvtdsp.pl -2005
    </example>
    va convertir les drapeaux /D pour les drapeaux RC afin d'utiliser
    une syntaxe alternative, interprétable ; malheureusement, cette
    syntaxe n'est pas supportée par Visual Studio 97 ou ses fichiers
    .mak exportés. Ces drapeaux /D permettent de transmettre la longue
    description des fichiers de mod_apachemodule.so à leurs compilations
    d'identificateur de version de ressource .rc partagée.</note>

    
	<note><strong>Compilation avec OpenSSL versions 1.1.0 et supérieures</strong>
    Suite à une modification de la structure de compilation d'OpenSSL à partir
    de la version 1.1.0, vous devez convertir les fichiers dsp concernés via la
    commance cvtdsp.pl fournie par APR versions 1.6 et supérieures :
    <example>
      perl srclib\apr\build\cvtdsp.pl -ossl11
    </example>
	</note>

    <!-- Traduction à revoir -->
    <p>Les utilisateurs de Visual Studio 2002 (.NET) et versions
    supérieures doivent aussi utiliser
    la boîte de dialogue Configuration Manager du menu Build pour
    décocher les deux versions <code>Debug</code> et
    <code>Release</code> des modules <module>mod_ssl</module>
    et <module>mod_deflate</module> pour <code>abs</code>. Ces modules
    sont compilés
    en invoquant <code>nmake</code> ou directement l'IDE avec la cible
    <code>BinBuild</code> pour compiler ces modules de manière
    conditionnelle si les sous-répertoires de <code>srclib</code>
    <code>openssl</code> et/ou <code>zlib</code> existent, et en
    fonction des définitions des variables d'environnement
    <code>DBD_LIST</code> et <code>DBM_LIST</code>.</p>

    </section>

  <section id="exportingmakfiles">

    <title>Export des fichiers .mak de la ligne de commandes</title>


    <p>Les fichiers <code>.mak</code> exportés posent plus de problèmes,
    mais les utilisateurs de Visual C++ 5.0 en ont besoin pour compiler
    <module>mod_ssl</module>, abs (<program>ab</program> avec support
    SSL) et/ou <module>mod_deflate</module>. Les fichiers .mak
    supportent aussi un choix plus large de distributions de chaînes
    d'outils C++, comme Visual Studio Express.</p>

    <p>Vous devez tout d'abord compiler tous les projets afin de créer
    toutes les cibles dynamiques auto-générées, de façon à ce que les
    dépendances puissent être interprétées correctement. Compilez
    l'ensemble du projet depuis l'IDE Visual Studio 6.0 (98), en
    utilisant la cible <code>BuildAll</code>, puis utilisez le menu de
    projet Export pour tous les makefiles (en cochant "with
    dependencies"). Utilisez la commande suivante pour transformer les
    chemins absolus en chemins relatifs de façon à ce que la compilation
    puisse s'effectuer depuis n'importe quelle position dans
    l'arborescence :</p>

    <example>
      perl srclib\apr\build\fixwin32mak.pl
    </example>

    <p>Vous devez exécuter cette commande depuis la <em>racine</em> de
    l'arborescence des sources de httpd. Tout fichier projet
    <code>.mak</code> et <code>.dep</code> du répertoire courant et de
    ses sous-répertoires sera corrigé, et les repères de temps ajustés
    en fonction des <code>.dsp</code>.</p>

    <p>Vérifiez toujours le SDK de la plate-forme ou autres chemins
    fichiers locaux, spécifiques à la machine dans les fichiers
    <code>.mak</code> et <code>.dep</code> générés. Le répertoire
    <code>DevStudio\Common\MSDev98\bin\</code> (VC6) contient un fichier
    <code>sysincl.dat</code> qui énumère toutes les exceptions. Mettez à
    jour ce fichier (en particulier les chemins avec slashes et
    anti-slashes, tels que <code>sys/time.h</code> et
    <code>sys\time.h</code>) de façon à ignorer ces nouvelles
    dépendances. Inclure les chemins d'installation locale dans un
    fichier <code>.mak</code> distribué fera échouer la
    compilation.</p>

    <p>Si vous soumettez un patch qui modifie les fichiers projet, nous
    devons valider la modification de ces fichiers projet au format
    Visual Studio 6.0. Les modifications doivent êtres simples, avec un
    minimum de drapeaux de compilation et d'édition de liens qui
    pourront être reconnus par tous les environnements Visual
    Studio.</p>

  </section>

  <section id="installation">


    <title>Installation</title>

    <p>Une fois compilé, Apache doit être installé dans le répertoire
    racine du serveur. La valeur par défaut est le répertoire
    <code>\Apache2</code>, sur le même disque.</p>

    <p>Pour compiler et installer automatiquement tous les fichiers dans
    le répertoire <em>rep</em> désiré, utilisez une des commandes
    <code>nmake</code> suivantes :</p>

    <example>
      nmake /f Makefile.win installr INSTDIR=<em>dir</em><br />
      nmake /f Makefile.win installd INSTDIR=<em>dir</em>
    </example>

    <p>L'argument <em>rep</em> de <code>INSTDIR</code> permet de
    spécifier le répertoire d'installation ; il peut être omis si Apache
    doit être installé dans <code>\Apache22</code> (du lecteur de disque
    courant.</p>

</section>

<section id="projectcomponents-warn">

<title>Avertissement à propos de la compilation d'Apache à partir de
l'arborescence de développement</title>

	<note>Notez que seuls les fichiers <code>.dsp</code> sont
	maintenus d'une distribution <code>release</code> à l'autre. Les
	fichiers <code>.mak</code> ne sont PAS régénérés, suite à
	l'énorme perte de temps des relecteurs <!-- ??? -->. Vous ne
	pouvez donc pas utiliser les commandes <code>NMAKE</code>
	ci-dessus pour compiler des fichiers de projet <code>.dsp</code>
	révisés si vous n'exporter pas ensuite vous-même tous les
	fichiers <code>.mak</code> du projet. Ceci n'est pas nécessaire
	si vous effectuez la compilation depuis l'environnement
	Microsoft Developer Studio.</note>

</section>

  <section id="cmake">
  <title>Compilation de httpd avec cmake</title>

  <p>La documentation principale pour ce mécanisme de compilation se trouve
  dans le fichier <code>README.cmake</code> situé dans l'arborescence
  des sources. Consultez ce fichier pour des instructions détaillées.</p>

  <p>Pour compiler httpd avec cmake, vous devez compiler APR et APR-util
  séparément. Consultez les fichiers <code>README.cmake</code> de ces
  projets pour obtenir des instructions.</p>

  <p>Les principales limitations de la compilation basée sur cmake sont
  héritées du projet APR-util et sont énumérées ci-dessous à cause de
  leur impact sur httpd :</p>

  <ul>
    <li>Il n'est pas possible de compiler le projet APR-iconv avec
    cmake, et la compilation de APR-util ne peut pas utiliser de projet
    APR-iconv précompilé. A cause de cela, il n'est pas possible
    d'utiliser <module>mod_charset_lite</module> et probablement
    d'autres modules tiers.</li>
    <li>La compilation du sous-projet APR-util avec cmake ne supporte
    pas la plupart des bibliothèques optionnelles DBM et DBD utilisées
    par les fichiers projet Visual Studio inclus. Cela limite les
    serveurs de bases de données d'arrière-plan supportés par de
    nombreux modules tiers ou inclus.</li>
  </ul>

  </section>

</manualpage>

