<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1745884 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_auth_form.xml.meta">

<name>mod_auth_form</name>
<description>Authentification à l'aide d'un formulaire</description>
<status>Base</status>
<sourcefile>mod_auth_form.c</sourcefile>
<identifier>auth_form_module</identifier>
<compatibility>Disponible à partir d'Apache 2.3</compatibility>

<summary>
    <note type="warning"><title>Avertissement</title>
      <p>L'authentification à base de formulaire dépend des modules
      <module>mod_session</module> qui utilisent les cookies HTTP, et en
      tant que tels s'exposent à des attaques de type Cross Site
      Scripting, ou risquent de divulguer des informations à caractère
      privé aux clients. Assurez-vous que ces risques ont bien été pris
      en compte avant d'activer les sessions sur votre serveur.</p>
    </note>

    <p>Ce module permet de restreindre l'accès en recherchant les
    utilisateurs dans les fournisseurs spécifiés à l'aide d'un
    formulaire de connexion HTML. Les formulaires HTML requièrent
    davantage de configuration que les méthodes d'authentification
    alternatives, mais ils peuvent s'avérer beaucoup plus conviviaux
    pour les utilisateurs.
    </p>

    <p>L'authentification HTTP de base est fournie par le module
    <module>mod_auth_basic</module>, et l'authentification HTTP à base
    de condensé par le module <module>mod_auth_digest</module>. Le
    module <module>mod_auth_form</module> doit être utilisé avec au
    moins un module d'authentification du style
    <module>mod_authn_file</module> et un module d'autorisation comme
    <module>mod_authz_user</module>.</p>

    <p>Lorsque l'utilisateur a été authentifié avec succès, ses
    informations de connexion sont stockés dans une session fournie par
    le module <module>mod_session</module>.
    </p>

</summary>
<seealso><module>mod_session</module></seealso>
<seealso><directive module="mod_authn_core">AuthName</directive></seealso>
<seealso><directive module="mod_authn_core">AuthType</directive></seealso>
<seealso><directive module="mod_authz_core">Require</directive></seealso>
<seealso><a href="../howto/auth.html">Mise en oeuvre de
l'authentification</a></seealso>

    <section id="basicconfig"><title>Configuration de base</title>

      <p>Pour protéger une URL particulière avec le module
      <module>mod_auth_form</module>, vous devez déterminer l'endroit où
      vous allez stocker votre <var>session</var>, ainsi que la méthode
      d'authentification. Dans cet exemple simple, les informations de
      connexion sont stockées dans une session à l'aide du module
      <module>mod_session_cookie</module>, et l'authentification utilise
      un fichier en s'appuyant sur le module
      <module>mod_authn_file</module>. Si l'authentification échoue,
      l'utilisateur dera redirigé vers la page du formulaire de
      connexion.</p>

      <example><title>Exemple simple</title>
        <highlight language="config">
&lt;Location "/admin"&gt;
    AuthFormProvider file
    AuthUserFile "conf/passwd"
    AuthType form
    AuthName "/admin"
    AuthFormLoginRequiredLocation "http://example.com/login.html"

    Session On
    SessionCookieName session path=/

    Require valid-user
&lt;/Location&gt;
        </highlight>
      </example>

      <p>L'authentification <module>mod_auth_form</module> est activée
      en affectant la valeur <var>form</var> à la directive <directive
      module="mod_authn_core">AuthType</directive>. Les directives
      <directive module="mod_auth_form">AuthFormProvider</directive> et
      <directive module="mod_authn_file">AuthUserFile</directive>
      spécifient que les noms d'utilisateurs et mots de passe seront
      vérifiés en utilisant le fichier choisi.</p>

      <p>Les directives <directive
      module="mod_session">Session</directive> et <directive
      module="mod_session_cookie">SessionCookieName</directive> créent une
      session chiffrée stockée dans un cookie HTTP au niveau
      du navigateur. Pour plus d'informations à propos des différentes
      options de configuration des sessions, reportez-vous à la
      documentation du module <module>mod_session</module>.</p>

      <p>Vous pouvez éventuellement ajouter une directive <directive
      module="mod_session_crypto">SessionCryptoPassphrase</directive> pour créer
      un cookie de session chiffré. Pour utiliser cette directive, le module
      <module>mod_session_crypto</module> doit avoir été préalablement chargé.</p>

      <p>Dans l'exemple simple ci-dessus, une URL a été protégée par
      <module>mod_auth_form</module>, mais on doit maintenant fournir
      à l'utilisateur un moyen d'entrer un nom et un mot de passe. À cet
      effet, on peut soit écrire une page de connexion indépendante
      dédiée, soit inclure le formulaire de connexion dans la page
      courante.</p>
    </section>

    <section id="standalone"><title>Page de connexion dédiée</title>

      <p>Le formulaire de connexion peut être contenu dans une page
      indépendante, ou être inclus dans la page courante. </p>

      <p>Lorsque la connexion s'effectue à partir d'une page
      indépendante et si la tentative d'authentification échoue,
      l'utilisateur doit être redirigé vers un formulaire de connexion,
      créé à cet effet sur le site web, en utilisant la directive
      <directive
      module="mod_auth_form">AuthFormLoginRequiredLocation</directive>.
      En général, la page de connexion contiendra un formulaire HTML
      demandant à l'utilisateur de fournir un nom et un mot de passe.</p>

      <example><title>Exemple de formulaire de connexion</title>
        <highlight language="html">
&lt;form method="POST" action="/dologin.html"&gt;
  Username: &lt;input type="text" name="httpd_username" value="" /&gt;
  Password: &lt;input type="password" name="httpd_password" value="" /&gt;
  &lt;input type="submit" name="login" value="Login" /&gt;
&lt;/form&gt;
        </highlight>
      </example>

      <p>La partie où s'effectue la connexion proprement dite est
      traitée par le gestionnaire <var>form-login-handler</var>.
      L'action de ce formulaire doit pointer vers ce gestionnaire, ce
      que l'on configure dans Apache httpd comme suit :</p>

      <example><title>Exemple de configuration du gestionnaire de
      formulaire de connexion</title>
        <highlight language="config">
&lt;Location "/dologin.html"&gt;
    SetHandler form-login-handler
    AuthFormLoginRequiredLocation "http://example.com/login.html"
    AuthFormLoginSuccessLocation "http://example.com/admin/index.html"
    AuthFormProvider file
    AuthUserFile "conf/passwd"
    AuthType form
    AuthName /admin
    Session On
    SessionCookieName session path=/
    SessionCryptoPassphrase secret
&lt;/Location&gt;
        </highlight>
      </example>

      <p>L'URL spécifiée par la directive
      <directive module="mod_auth_form">AuthFormLoginRequiredLocation</directive>
      référencera en général une page expliquant à l'utilisateur que sa
      tentative de connexion a échoué, et qu'il doit la renouveler. La
      directive <directive
      module="mod_auth_form">AuthFormLoginSuccessLocation</directive>
      spécifie l'URL vers laquelle l'utilisateur doit être redirigé s'il
      s'est authentifié avec succès.</p>

      <p>Alternativement, l'URL vers laquelle doit être redirigé
      l'utilisateur s'il s'est authentifié avec succès peut être
      intégrée dans le formulaire de connexion, comme dans l'exemple
      ci-dessous. Il en découle que le même gestionnaire
      <var>form-login-handler</var> pourra être utilisé pour différentes
      zones du site web.</p>

      <example><title>Exemple de formulaire d'authentification multizone</title>
        <highlight language="html">
&lt;form method="POST" action="/dologin.html"&gt;
  Username: &lt;input type="text" name="httpd_username" value="" /&gt;
  Password: &lt;input type="password" name="httpd_password" value="" /&gt;
  &lt;input type="submit" name="login" value="Login" /&gt;
  &lt;input type="hidden" name="httpd_location" value="http://example.com/success.html" /&gt;
&lt;/form&gt;
        </highlight>
      </example>

    </section>

    <section id="inline"><title>Connexion à la volée</title>

      <note type="warning"><title>Avertissement</title>
        <p>Il existe un risque, dans certaines circonstances, que le
	formulaire de connexion configuré pour une connexion à la volée
	soit soumis plusieurs fois, révélant de ce fait les paramètres
	de connexion à l'application sous-jacente. L'administrateur doit
	s'assurer que cette dernière est correctement sécurisée afin
	d'éviter les éventuels abus. En cas de doute, utilisez une page
	de connexion indépendante dédiée.</p>
      </note>

      <p>Comme alternative à la page de connexion dédiée pour un site
      web, il est possible de configurer <module>mod_auth_form</module>
      pour authentifier les utilisateurs à la volée, sans les rediriger
      vers une autre page, ce qui permet de conserver l'état de la page
      courante au cours de la tentative de connexion. Ceci peut s'avérer
      utile dans le cas d'une session limitée dans le temps, si le délai
      de la session a expiré pendant la requête de l'utilisateur. Ce
      dernier peut alors se réauthentifier à la même place, et
      poursuivre son activité à partir du point où il en était resté.</p>

      <p>Si un utilisateur non authentifié tente d'accéder à une page
      protégée par <module>mod_auth_form</module>, et si ce dernier
      n'est pas configuré avec une directive <directive
      module="mod_auth_form">AuthFormLoginRequiredLocation</directive>,
      un code de statut <var>HTTP_UNAUTHORIZED</var> est renvoyé vers le
      navigateur, indiquant à l'utilisateur qu'il n'est pas autorisé à
      accéder à cette page.</p>

      <p>Pour configurer l'authentification à la volée, l'administrateur
      remplace le message d'erreur renvoyé par le code de statut
      <var>HTTP_UNAUTHORIZED</var> par un message d'erreur personnalisé
      contenant le formulaire de connexion comme suit :</p>

      <example><title>Exemple simple d'authentification à la volée</title>
        <highlight language="config">
AuthFormProvider file
ErrorDocument 401 "/login.shtml"
AuthUserFile "conf/passwd"
AuthType form
AuthName realm
AuthFormLoginRequiredLocation "http://example.com/login.html"
Session On
SessionCookieName session path=/
        </highlight>
      </example>

      <p>La page du message d'erreur doit contenir un formulaire de
      connexion dont la propriété action est vide, comme dans l'exemple
      ci-dessous. Ceci a pour effet de soumettre le formulaire à l'URL
      protégée originale, cette dernière n'ayant pas besoin d'être
      connue de la page en cours.</p>

      <example><title>Exemple de formulaire de connexion à la volée</title>
        <highlight language="html">
&lt;form method="POST" <strong>action=""</strong>&gt;
  Username: &lt;input type="text" name="httpd_username" value="" /&gt;
  Password: &lt;input type="password" name="httpd_password" value="" /&gt;
  &lt;input type="submit" name="login" value="Login" /&gt;
&lt;/form&gt;
</highlight>
      </example>

      <p>Lorsque l'utilisateur final a entré ses informations de
      connexion, le formulaire effectue une requête HTTP POST pour l'URL
      originale protégée par mot de passe.
      <module>mod_auth_form</module> va alors intercepter cette requête
      POST, et dans le cas où des champs HTML Utilisateur et Mot de
      passe corrects sont présents, l'utilisateur sera connecté, et
      l'URL originale protégée par mot de passe lui sera retournée en
      tant que requête GET.</p>

    </section>

    <section id="inlinepreservebody"><title>Connexion à la volée avec
    conservation du contenu</title>

      <p>Il existe une limite à la technique de connexion à la volée
      décrite ci-dessus ; si un formulaire HTML POST entraîne une
      demande d'authentification ou de réauthentification, le contenu du
      formulaire original envoyé par le navigateur sera perdu. Cela peut
      s'avérer plus ou moins gênant pour l'utilisateur final selon la
      fonction du site web.</p>

      <p>Comme solution à ce problème, <module>mod_auth_form</module>
      permet d'intégrer la méthode et le contenu de la requête originale
      dans le formulaire de connexion. Si l'authentification réussit,
      Apache httpd pourra refaire une tentative avec la méthode et le contenu
      originaux, tout en conservant l'état de la requête originale.</p>

      <p>Pour mettre en oeuvre la conservation du contenu, vous devez
      ajouter trois champs supplémentaires au formulaire de connexion
      comme dans l'exemple suivant :</p>

      <example><title>Exemple de formulaire avec conservation du
      contenu</title>
        <highlight language="html">
&lt;form method="POST" action=""&gt;
  Username: &lt;input type="text" name="httpd_username" value="" /&gt;
  Password: &lt;input type="password" name="httpd_password" value="" /&gt;
  &lt;input type="submit" name="login" value="Login" /&gt;
  <br/>  <strong>&lt;input type="hidden" name="httpd_method" value="POST" /&gt;
  &lt;input type="hidden" name="httpd_mimetype" value="application/x-www-form-urlencoded" /&gt;
  &lt;input type="hidden" name="httpd_body" value="name1=value1&amp;name2=value2" /&gt;</strong><br/>
&lt;/form&gt;
        </highlight>
      </example>

      <p>La manière dont la méthode, le type MIME et le contenu de la
      requête originale seront intégrés dans le formulaire de connexion
      vont dépendre de la plate-forme et de la technologie utilisées au
      sein du site web.
      </p>

      <p>Une option consiste à utiliser le module
      <module>mod_include</module> en association avec la directive
      <directive module="mod_request">KeptBodySize</directive>, ainsi
      qu'un script CGI adapté pour intégrer les variables dans le
      formulaire.</p>

      <p>Une autre option consiste à présenter le formulaire de
      connexion en utilisant un script CGI ou une autre technologie
      dynamique.</p>

      <example><title>Exemple avec script CGI</title>
        <highlight language="config">
        AuthFormProvider file
        ErrorDocument 401 "/cgi-bin/login.cgi"
        ...
        </highlight>
      </example>

    </section>

    <section id="loggingout"><title>Déconnexion</title>

      <p>Pour permettre à un utilisateur de se déconnecter d'une session
      particulière, vous devez configurer une page pour qu'elle soit
      traitée par le gestionnaire <var>form-logout-handler</var>. Tout
      accès à cette URL va entraîner la suppression de l'Utilisateur et
      du Mot de passe de la session courante, ce qui aura pour effet de
      déconnecter l'utilisateur.</p>

      <p>Vous pouvez spécifier une URL vers laquelle le navigateur sera
      redirigé en cas de déconnection réussie, en définissant la
      directive <directive
      module="mod_auth_form">AuthFormLogoutLocation</directive>. Cette
      URL devra expliquer à l'utilisateur qu'il a été déconnecté, et lui
      donner la possibilité de se connecter à nouveau.</p>

      <example><title>Exemple simple de configuration de la
      déconnexion</title>
        <highlight language="config">
SetHandler form-logout-handler
AuthName realm
AuthFormLogoutLocation "http://example.com/loggedout.html"
Session On
SessionCookieName session path=/
        </highlight>
      </example>

      <p>Notez que la déconnexion d'un utilisateur ne supprime pas la
      session ; elle supprime seulement l'utilisateur et le mot de passe
      de la session. Si la session qui en résulte est vide, elle sera
      probablement supprimée, mais ce n'est pas garanti. Si vous voulez
      être sûr que la session sera supprimée, affectez une valeur faible
      à la directive <directive
      module="mod_session">SessionMaxAge</directive>, par exemple 1
      (affecter à cette directive la valeur zéro signifie une session
      sans limite d'âge).
      </p>

      <example><title>Exemple simple avec durée de validité de session
      limitée</title>
        <highlight language="config">
SetHandler form-logout-handler
AuthFormLogoutLocation "http://example.com/loggedout.html"
Session On
SessionMaxAge 1
SessionCookieName session path=/
        </highlight>
      </example>

    </section>

    <section id="urlencoding"><title>Noms d'utilisateurs et mots de
    passe</title>
    <p>Notez que la soumission d'un formulaire implique l'encodage URL
    (URLEncoding) des données du formulaire, ici le nom d'utilisateur et
    le mot de passe. Vous devez donc choisir des noms d'utilisateurs et
    mots de passe qui ne contiennent pas de caractères susceptibles
    d'être encodés URL lors de la soumission du formulaire, sous peine
    d'obtenir des résultats inattendus.</p>
    </section>

<directivesynopsis>
<name>AuthFormProvider</name>
<description>Définit le(s) fournisseur(s) d'authentification pour la
zone concernée</description>
<syntax>AuthFormProvider <var>nom fournisseur</var>
[<var>nom fournisseur</var>] ...</syntax>
<default>AuthFormProvider file</default>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>

<usage>
    <p>La directive <directive>AuthFormProvider</directive> permet de
    définir quel fournisseur sera utilisé pour authentifier les
    utilisateurs pour la zone concernée. Le fournisseur par défaut
    <code>file</code> est implémenté par le module
    <module>mod_authn_file</module>. Assurez-vous que le fournisseur
    choisi soit bien présent dans le serveur.</p>

    <example><title>Exemple</title>
      <highlight language="config">
&lt;Location "/secure"&gt;
    AuthType form
    AuthName "private area"
    AuthFormProvider  dbm
    AuthDBMType        SDBM
    AuthDBMUserFile    "/www/etc/dbmpasswd"
    Require            valid-user
    #...
&lt;/Location&gt;
      </highlight>
    </example>

    <p>Les différents fournisseurs sont implémentés par les modules
    <module>mod_authn_dbm</module>, <module>mod_authn_file</module>,
    <module>mod_authn_dbd</module> et
    <module>mod_authnz_ldap</module>.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthFormAuthoritative</name>
<description>Détermine si l'autorisation et l'authentification sont confiés à
des modules de plus bas niveau</description>
<syntax>AuthFormAuthoritative On|Off</syntax>
<default>AuthFormAuthoritative On</default>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>

<usage>
    <p>Normalement, chacun des modules d'autorisation spécifiés par la
    directive <directive
    module="mod_auth_form">AuthFormProvider</directive> va tenter de
    vérifier l'identité de l'utilisateur, et si ce dernier n'est trouvé
    dans aucun fournisseur, l'accès sera refusé. En définissant
    explicitement la directive
    <directive>AuthFormAuthoritative</directive> à <code>Off</code> on
    confie les processus d'authentification et d'autorisation à des
    modules ne s'appuyant pas sur des fournisseurs, si <strong>aucun
    identifiant utilisateur</strong> ou aucune <strong>règle</strong> ne
    correspond à l'identifiant utilisateur fourni. Ceci ne peut s'avérer
    nécessaire que si l'on combine <module>mod_auth_form</module> avec
    des modules tiers qui ne se configurent pas avec la directive
    <directive module="mod_auth_form">AuthFormProvider</directive>.
    Lorsqu'on utilise de tels modules, la chronologie du processus est
    déterminée dans leur code source, et n'est pas configurable.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthFormUsername</name>
<description>Le nom du champ de formulaire qui contient le nom de
connexion</description>
<syntax>AuthFormUsername <var>nom du champ</var></syntax>
<default>httpd_username</default>
<contextlist><context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.3 du serveur HTTP Apache</compatibility>

<usage>
    <p>La directive <directive
    module="mod_auth_form">AuthFormUsername</directive> permet de
    spécifier le nom du champ HTML qui, s'il existe, contiendra le nom
    d'utilisateur qui sera utilisé pour la connexion.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthFormPassword</name>
<description>Le nom du champ de formulaire qui contient le mot de passe
de connexion</description>
<syntax>AuthFormPassword <var>nom du champ</var></syntax>
<default>httpd_password</default>
<contextlist><context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.0 du serveur HTTP Apache</compatibility>

<usage>
    <p>La directive <directive
    module="mod_auth_form">AuthFormPassword</directive> permet de
    spécifier le nom du champ HTML qui, s'il existe, contiendra le mot
    de passe qui sera utilisé pour la connexion.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthFormLocation</name>
<description>Le nom du champ de formulaire qui contiendra l'URL vers
laquelle l'utilisateur sera redirigé en cas de connexion
réussie</description>
<syntax>AuthFormLocation <var>nom du champ</var></syntax>
<default>httpd_location</default>
<contextlist><context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.0 du serveur HTTP Apache</compatibility>

<usage>
    <p>La directive <directive
    module="mod_auth_form">AuthFormLocation</directive>
    spécifie le nom du champ HTML qui, s'il existe, contiendra l'URL
    vers laquelle rediriger le navigateur en cas de connexion
    réussie.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthFormMethod</name>
<description>Le nom du champ de formulaire contenant la méthode de la
requête à effectuer en cas de connexion réussie</description>
<syntax>AuthFormMethod <var>nom du champ</var></syntax>
<default>httpd_method</default>
<contextlist><context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.0 du serveur HTTP Apache</compatibility>

<usage>
    <p>La directive <directive
    module="mod_auth_form">AuthFormMethod</directive>
    spécifie le nom du champ HTML qui, s'il existe, contiendra le type
    MIME de la requête à effectuer en cas de connexion réussie.</p>

    <p>En ajoutant au formulaire les champs décrits dans <directive
    module="mod_auth_form">AuthFormMethod</directive>, <directive
    module="mod_auth_form">AuthFormMimetype</directive> et <directive
    module="mod_auth_form">AuthFormBody</directive>, un site web sera en
    mesure de relancer une requête qui a été éventuellement interrompue
    par l'écran de connexion, ou par l'expiration d'un délai de
    session.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthFormMimetype</name>
<description>Le nom du champ de formulaire contenant le type MIME du
corps de la requête à effectuer en cas de connexion
réussie</description>
<syntax>AuthFormMimetype <var>nom du champ</var></syntax>
<default>httpd_mimetype</default>
<contextlist><context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.0 du serveur HTTP Apache</compatibility>

<usage>
    <p>La directive <directive
    module="mod_auth_form">AuthFormMimetype</directive>
    spécifie le nom du champ HTML qui, s'il existe, contiendra le type
    MIME de la requête à effectuer en cas de connexion réussie.</p>

    <p>En ajoutant au formulaire les champs décrits dans <directive
    module="mod_auth_form">AuthFormMethod</directive>, <directive
    module="mod_auth_form">AuthFormMimetype</directive> et <directive
    module="mod_auth_form">AuthFormBody</directive>, un site web sera en
    mesure de relancer une requête qui a été éventuellement interrompue
    par l'écran de connexion, ou par l'expiration d'un délai de
    session.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthFormBody</name>
<description>Le nom du champ de formulaire contenant le corps de la
requête à effectuer en cas de connexion réussie</description>
<syntax>AuthFormBody <var>nom du champ</var></syntax>
<default>httpd_body</default>
<contextlist><context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.0 du serveur HTTP Apache</compatibility>

<usage>
    <p>La directive <directive
    module="mod_auth_form">AuthFormBody</directive>
    spécifie le nom du champ HTML qui, s'il existe, contiendra le corps
    de la requête à effectuer en cas de connexion réussie.</p>

    <p>En ajoutant au formulaire les champs décrits dans <directive
    module="mod_auth_form">AuthFormMethod</directive>, <directive
    module="mod_auth_form">AuthFormMimetype</directive> et <directive
    module="mod_auth_form">AuthFormBody</directive>, un site web sera en
    mesure de relancer une requête qui a été éventuellement interrompue
    par l'écran de connexion, ou par l'expiration d'un délai de
    session.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthFormSize</name>
<description>La taille maximale en octets du formulaire dont seront
extraites les informations de connexion</description>
<syntax>AuthFormSize <var>taille</var></syntax>
<default>8192</default>
<contextlist><context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.0 du serveur HTTP Apache</compatibility>

<usage>
    <p>La directive <directive
    module="mod_auth_form">AuthFormSize</directive> spécifie
    la taille maximale du corps de la requête qui sera utilisée pour
    trouver le formulaire de connexion.</p>

    <p>Si une requête de connexion entrante possède une taille
    supérieure à cette valeur, elle sera rejetée avec le code de réponse
    HTTP <code>HTTP_REQUEST_TOO_LARGE</code>.</p>

    <p>Si vous avez ajouté au formulaire des champs décrits dans <directive
    module="mod_auth_form">AuthFormMethod</directive>, <directive
    module="mod_auth_form">AuthFormMimetype</directive> et <directive
    module="mod_auth_form">AuthFormBody</directive>, il est recommandé
    de définir cette directive à une valeur similaire à celle de la
    directive <directive module="mod_request">KeptBodySize</directive>.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthFormLoginRequiredLocation</name>
<description>L'URL de la page vers laquelle on doit être redirigé si une
authentification est requise</description>
<syntax>AuthFormLoginRequiredLocation <var>url</var></syntax>
<default>none</default>
<contextlist><context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.0 du serveur HTTP
Apache. L'interprétation des expressions rationnelles est supportée
depuis la version 2.4.4.</compatibility>

<usage>
    <p>La directive <directive
    module="mod_auth_form">AuthFormLoginRequiredLocation</directive>
    spécifie l'URL vers laquelle l'utilisateur devra être
    redirigé s'il n'est pas autorisé à accéder à une page. Sa valeur est
    interprétée via l'interpréteur <a href="../expr.html">ap_expr</a>
    avant d'être envoyée au client. Par défaut,
    si un utilisateur n'est pas autorisé à accéder à une page, le code
    de réponse HTTP <code>HTTP_UNAUTHORIZED</code> est renvoyé avec la
    page spécifiée par la directive <directive
    module="core">ErrorDocument</directive>. La directive <directive
    module="mod_auth_form">AuthFormLoginRequiredLocation</directive>
    permet de remplacer cette valeur par défaut.</p>

    <p>Vous pouvez utiliser cette directive si vous voulez présenter une
    page de connexion personnalisée à vos utilisateurs.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthFormLoginSuccessLocation</name>
<description>L'URL de la page vers laquelle on doit être redirigé en cas
de connexion réussie</description>
<syntax>AuthFormLoginSuccessLocation <var>url</var></syntax>
<default>none</default>
<contextlist><context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.0 du serveur HTTP
Apache. L'interprétation des expressions rationnelles est supportée
depuis la version 2.4.4.</compatibility>

<usage>
    <p>La directive <directive
    module="mod_auth_form">AuthFormLoginSuccessLocation</directive>
    spécifie l'URL vers laquelle l'utilisateur doit être
    redirigé en cas de connexion réussie. Sa valeur est
    interprétée via l'interpréteur <a href="../expr.html">ap_expr</a>
    avant d'être envoyée au client. L'effet de cette directive
    peut être annulé si l'on a défini un champ de formulaire contenant
    une autre URL à l'aide de la directive <directive
    module="mod_auth_form">AuthFormLocation</directive>.</p>

    <p>Vous pouvez utiliser cette directive si vous possédez une URL de
    connexion personnalisée, et si vous n'avez pas intégré la page de
    destination dans le formulaire de connexion.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthFormFakeBasicAuth</name>
<description>Simule une en-tête d'authentification de base</description>
<syntax>AuthFormFakeBasicAuth <var>On|Off</var></syntax>
<default>AuthFormFakeBasicAuth Off</default>
<contextlist><context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.0 du serveur HTTP Apache</compatibility>

<usage>
    <p>Le drapeau <directive
    module="mod_auth_form">AuthFormFakeBasicAuth</directive>
    détermine si une en-tête d'<code>Authentification de base</code>
    sera ajoutée aux en-têtes de la requête. On peut utiliser cette
    méthode pour présenter le nom d'utilisateur et le mot de passe à
    l'application sous-jacente, sans que cette dernière ait besoin de
    connaître la manière dont le processus de connexion a été mené à
    bien.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthFormLogoutLocation</name>
<description>L'URL vers laquelle un utilisateur devra être redirigé
après s'être déconnecté</description>
<syntax>AuthFormLogoutLocation <var>uri</var></syntax>
<default>none</default>
<contextlist><context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.0 du serveur HTTP
Apache. L'interprétation des expressions rationnelles est supportée
depuis la version 2.4.4.</compatibility>

<usage>
    <p>La directive <directive
    module="mod_auth_form">AuthFormLogoutLocation</directive>
    spécifie l'URL de la page du serveur vers laquelle l'utilisateur
    devra être redirigé s'il se déconnecte. Sa valeur est
    interprétée via l'interpréteur <a href="../expr.html">ap_expr</a>
    avant d'être envoyée au client.</p>

    <p>Lorsqu'un accès est tenté sur un URI traité par le gestionnaire
    <code>form-logout-handler</code>, la page spécifiée par cette
    directive sera présentée à l'utilisateur final. Par exemple :</p>

    <example><title>Exemple</title>
      <highlight language="config">
&lt;Location "/logout"&gt;
    SetHandler form-logout-handler
    AuthFormLogoutLocation "http://example.com/loggedout.html"
    Session on
    #...
&lt;/Location&gt;
      </highlight>
    </example>

    <p>Si un utilisateur tente d'accéder à l'URI <var>/logout/</var>, il
    sera déconnecté, et la page <var>/loggedout.html</var> lui sera
    présentée. Assurez-vous que la page <var>loggedout.html</var> n'est
    pas protégée par mot de passe, car dans le cas contraire, elle ne
    serait pas affichée.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthFormDisableNoStore</name>
<description>Désactive l'en-tête CacheControl no-store sur la page de
connexion</description>
<syntax>AuthFormDisableNoStore <var>On|Off</var></syntax>
<default>AuthFormDisableNoStore Off</default>
<contextlist><context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.0 du serveur HTTP Apache</compatibility>

<usage>
    <p>Le drapeau <directive
    module="mod_auth_form">AuthFormDisableNoStore</directive> supprime
    l'envoi d'un en-tête <code>Cache-Control no-store</code> lorsqu'une
    page avec code d'erreur 401 est renvoyée, si l'utilisateur n'est pas
    encore connecté. Avec cette en-tête, il est plus difficile pour une
    application <code>ecmascript</code> de resoumettre un formulaire de connexion, et
    ainsi révéler le nom d'utilisateur et le mot de passe à
    l'application sous-jacente. Vous devez être conscient des risques
    encourus si vous le désactivez.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthFormSitePassphrase</name>
<description>Court-circuite l'authentification pour les sites à fort
trafic</description>
<syntax>AuthFormSitePassphrase <var>secret</var></syntax>
<default>none</default>
<contextlist><context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.0 du serveur HTTP Apache</compatibility>

<usage>
    <p>La directive <directive
    module="mod_auth_form">AuthFormSitePassphrase</directive>
    spécifie un mot de passe qui, s'il est présent dans la session
    utilisateur, indique à Apache httpd de court-circuiter l'authentification
    pour l'URL considérée. On peut l'utiliser dans le cas de sites web à
    fort trafic afin de réduire la charge induite sur l'infrastructure
    d'authentification.</p>

    <p>On peut insérer le mot de passe dans une session utilisateur en
    ajoutant cette directive à la configuration concernant le
    gestionnaire <var>form-login-handler</var>. Le gestionnaire
    <var>form-login-handler</var>, quant à lui, effectuera toujours les
    vérifications d'authentification, qu'un mot de passe soit spécifié
    ou non.</p>

    <note type="warning"><title>Avertissement</title>
      <p>Si la session est présentée à l'utilisateur à l'aide du module
      <module>mod_session_cookie</module>, et si la session n'est pas
      protégée par le module <module>mod_session_crypto</module>, le mot
      de passe peut faire l'objet d'une attaque de type dictionnaire.
      Quelle que soit la configuration de la session, assurez-vous que
      cette directive n'est pas utilisée dans un espace d'URLs contenant
      des données privées, ou à partir desquelles des transactions
      sensibles pourraient être menées. En tout état de cause, vous
      devez être conscient des risques encourus avant de l'utiliser.</p>
    </note>

</usage>
</directivesynopsis>

</modulesynopsis>
