<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.en.xsl"?>
<!-- English Revision : 1673563 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_reflector.xml.meta">

<name>mod_reflector</name>
<description>Renvoie un corps de requête comme réponse via la pile de
filtres en sortie.</description>
<status>Base</status>
<sourcefile>mod_reflector.c</sourcefile>
<identifier>reflector_module</identifier>
<compatibility>Versions 2.3 et ultérieures</compatibility>

<summary>
    <p>Ce module permet de renvoyer un corps de requête au client, après
    l'avoir fait passer par la pile de filtres en sortie. Une chaîne de
    filtres configurée de manière appropriée peut être utilisée pour
    transformer la requête en réponse. Ce module peut ainsi être utilisé
    pour transformer un filtre en sortie en service HTTP.</p>
</summary>

<section id="examples"><title>Exemples</title>
    <dl>
    <dt>Service de compression</dt>
    <dd>Fait passer le corps de la requête par le filtre DEFLATE pour le
    compresser. Cette requête nécessite un en-tête Content-Encoding
    contenant la valeur "gzip" pour que le filtre renvoie les données
    compressées.
    <highlight language="config">
&lt;Location "/compress"&gt;
    SetHandler reflector
    SetOutputFilter DEFLATE
&lt;/Location&gt;
    </highlight>
    </dd>

    <dt>Service d'abaissement de l'échantillonnage d'image</dt>
    <dd>Fait passer le corps de la requête par un filtre d'abaissement
    de l'échantillonnage d'image, et renvoie le résultat au client.
    <highlight language="config">
&lt;Location "/downsample"&gt;
    SetHandler reflector
    SetOutputFilter DOWNSAMPLE
&lt;/Location&gt;
    </highlight>
    </dd>
    </dl>
</section>

<directivesynopsis>
<name>ReflectorHeader</name>
<description>Renvoie un en-tête d'entrée dans les en-têtes de sortie</description>
<syntax>ReflectorHeader <var>en-tête-entrée</var> <var>[en-tête-sortie]</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>Options</override>

<usage>
    <p>Cette directive permet de contrôler la répercution des en-têtes
    de la requête dans la réponse. Le premier argument correspond au nom
    de l'en-tête à copier. Si le second argument (optionnel) est
    spécifié, il définit le nom sous lequel l'en-tête sera répercuté
    dans la réponse ; dans le cas contraire, c'est le nom de l'en-tête
    original qui sera utilisé.</p>
</usage>
</directivesynopsis>

</modulesynopsis>
