<?xml version='1.0' ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1746871 -->
<!-- French translation by Vincent Deffontaines, Alain B.  -->
<!-- reviewed by Lucien Gentis -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="examples.xml.meta">
<parentdocument href="./">Serveurs virtuels</parentdocument>
    <title>Exemples d'utilisations de VirtualHost</title>

<summary>

    <p>Le but de ce document est d'essayer de répondre aux questions 
    les plus répandues sur la configuration des <a href="index.html">serveurs virtuels</a>. 
    Les scénarios présentés ici se rencontrent quand plusieurs 
    serveurs Webs doivent tourner sur une seule et même machine au 
    moyen de serveurs virtuels <a href="name-based.html">par nom</a> 
    ou <a href="ip-based.html">par IP</a>.</p>

</summary>

  <section id="purename"><title>Fonctionnement de plusieurs serveurs 
  virtuels par nom sur une seule adresse IP.</title>

    <p>Votre serveur possède plusieurs noms d'hôte qui correspondent à une seule
    adresse IP, et vous souhaitez des réponses différentes si on demande
    <code>www.example.com</code> ou <code>www.example.org</code>.</p>

    <note><title>Note&nbsp;:</title><p>La configuration de serveurs virtuels 
    sous Apache ne provoque pas leur apparition magique dans la 
    configuration du DNS. Il <em>faut</em> que leurs noms soient 
    définis dans le DNS, et qu'ils y soient résolus sur l'adresse IP 
    du serveur, faute de quoi personne ne pourra visiter votre site Web. 
    Il est possible d'ajouter des entrées dans le fichier 
    <code>hosts</code> pour tests locaux, mais qui ne fonctionneront 
    que sur la machine possédant ces entrées.</p>
    </note>

    <highlight language="config">
# Apache doit écouter sur le port 80
Listen 80
&lt;VirtualHost *:80&gt;
    DocumentRoot "/www/example1"
    ServerName www.example.com
  
    # Autres directives ici
&lt;/VirtualHost&gt;

&lt;VirtualHost *:80&gt;
    DocumentRoot "/www/example2"
    ServerName www.example.org

    # Autres directives ici
&lt;/VirtualHost&gt;
    </highlight>
   

    <p>Les astérisques correspondent à toutes les adresses, si bien que 
    le serveur principal ne répondra jamais à aucune requête. Comme le
    serveur virtuel
    <code>ServerName www.example.com</code> se trouve en premier dans le fichier 
    de configuration, il a la plus grande priorité et peut être vu 
    comme serveur <cite>par défaut</cite> ou <cite>primaire</cite>&nbsp;; 
    ce qui signifie que toute requête reçue ne correspondant à aucune 
    des directives <directive module="core">ServerName</directive> sera servie par ce premier 
    <directive type="section" module="core">VirtualHost</directive>.</p>

    <p>La configuration ci-dessus correspond à ce que l'on souhaite pour
    la plupart des serveurs virtuels à base de nom. Il faudra cependant
    utiliser une configuration différente si vous souhaitez servir un
    contenu différent en fonction de l'adresse IP ou du port.</p>

    <note>
            <title>Note&nbsp;:</title>

            <p>Vous pouvez remplacer <code>*</code> 
            par une adresse IP du système. Le serveur virtuel concerné
	    ne sera alors sélectionné que pour les requêtes HTTP vers
	    cette adresse IP.</p>

           <p>En général, il est commode d'utiliser <code>*</code> sur 
           les systèmes dont l'adresse IP n'est pas constante - par 
           exemple, pour des serveurs dont l'adresse IP est attribuée 
           dynamiquement par le FAI, et où le DNS est géré au moyen 
           d'un DNS dynamique quelconque. Comme <code>*</code> signifie 
           <cite>n'importe quelle adresse</cite>, cette configuration 
           fonctionne sans devoir être modifiée quand l'adresse IP du 
           système est modifiée.</p>
    </note>

    </section>

    <section id="twoips"><title>Serveurs virtuels par nom sur plus 
    d'une seule adresse IP.</title>

  	<note>
          <title>Note&nbsp;:</title><p>Toutes les techniques présentées ici 
          peuvent être étendues à un plus grand nombre d'adresses IP.</p>
    </note>

    <p>Le serveur a deux adresses IP. Sur l'une 
    (<code>172.20.30.40</code>), le serveur "principal" 
    <code>server.example.com</code> doit répondre, et sur l'autre 
    (<code>172.20.30.50</code>), deux serveurs virtuels (ou plus) 
    répondront.</p>

    <highlight language="config">
Listen 80

# Serveur "principal" sur 172.20.30.40
ServerName server.example.com
DocumentRoot "/www/mainserver"

&lt;VirtualHost 172.20.30.50&gt;
    DocumentRoot "/www/example1"
    ServerName www.example.com
    
    # D'autres directives ici ...
&lt;/VirtualHost&gt;

&lt;VirtualHost 172.20.30.50&gt;
    DocumentRoot "/www/example2"
    ServerName www.example.org
    
    # D'autres directives ici ...
&lt;/VirtualHost&gt;
    </highlight>

    <p>Toute requête arrivant sur une autre adresse que 
    <code>172.20.30.50</code> sera servie par le serveur principal. 
    Les requêtes vers <code>172.20.30.50</code> avec un nom de serveur 
    inconnu, ou sans en-tête <code>Host:</code>, seront servies par 
    <code>www.example.com</code>.</p>

    </section>

    <section id="intraextra"><title>Servir le même contenu sur des 
    adresses IP différentes (telle qu'une adresse interne et une 
    externe).</title>

    <p>La machine serveur dispose de deux adresses IP 
    (<code>192.168.1.1</code> et <code>172.20.30.40</code>). Cette 
    machine est placée à la fois sur le réseau interne (l'Intranet) 
    et le réseau externe (Internet). Sur Internet, le nom 
    <code>server.example.com</code> pointe vers l'adresse externe 
    (<code>172.20.30.40</code>), mais sur le réseau interne, ce même 
    nom pointe vers l'adresse interne (<code>192.168.1.1</code>).</p>

    <p>Le serveur peut être configuré pour répondre de la même manière 
    aux requêtes internes et externes, au moyen d'une seule section 
    <directive type="section" module="core">VirtualHost</directive>.</p>

    <highlight language="config">
&lt;VirtualHost 192.168.1.1 172.20.30.40&gt;
    DocumentRoot "/www/server1"
    ServerName server.example.com
    ServerAlias server
&lt;/VirtualHost&gt;
    </highlight>

    <p>Ainsi, les requêtes en provenance de chacun des deux réseaux 
    seront servies par le même <directive type="section"
    module="core">VirtualHost</directive>.</p>

    <note>
          <title>Note&nbsp;:</title><p>Sur le réseau interne, il est possible 
          d'utiliser le nom raccourci <code>server</code> au lieu du nom 
          complet <code>server.example.com</code>.</p>

          <p>Notez également que dans l'exemple précédent, vous pouvez 
          remplacer la liste des adresses IP par des <code>*</code> afin 
          que le serveur réponde de la même manière sur toutes ses 
          adresses.</p>
    </note>

    </section>

    <section id="port"><title>Servir différents sites sur différents 
    ports.</title>

    <p>Vous disposez de plusieurs domaines pointant sur la même adresse 
    IP et vous voulez également servir de multiples ports. L'exemple
    suivant montre que la sélection en fonction du nom intervient après
    la sélection de la meilleure correspondance du point de vue adresse
    IP/port.</p>

    <highlight language="config">
Listen 80
Listen 8080

&lt;VirtualHost 172.20.30.40:80&gt;
    ServerName www.example.com
    DocumentRoot "/www/domain-80"
&lt;/VirtualHost&gt;

&lt;VirtualHost 172.20.30.40:8080&gt;
    ServerName www.example.com
    DocumentRoot "/www/domain-8080"
&lt;/VirtualHost&gt;

&lt;VirtualHost 172.20.30.40:80&gt;
    ServerName www.example.org
    DocumentRoot "/www/otherdomain-80"
&lt;/VirtualHost&gt;

&lt;VirtualHost 172.20.30.40:8080&gt;
    ServerName www.example.org
    DocumentRoot "/www/otherdomain-8080"
&lt;/VirtualHost&gt;
    </highlight>

	</section>

    <section id="ip"><title>Hébergement virtuel basé sur IP</title>

    <p>Le serveur dispose de deux adresses IP (<code>172.20.30.40</code> 
    et <code>172.20.30.50</code>) correspondant respectivement aux noms 
    <code>www.example.com</code> et <code>www.example.org</code>.</p>

    <highlight language="config">
Listen 80

&lt;VirtualHost 172.20.30.40&gt;
    DocumentRoot "/www/example1"
    ServerName www.example.com
&lt;/VirtualHost&gt;

&lt;VirtualHost 172.20.30.50&gt;
    DocumentRoot "/www/example2"
    ServerName www.example.org
&lt;/VirtualHost&gt;
    </highlight>

    <p>Les requêtes provenant d'adresses non spécifiées dans l'une des 
    directives <code>&lt;VirtualHost&gt;</code> (comme pour 
    <code>localhost</code> par exemple) seront dirigées vers le serveur 
    principal, s'il en existe un.</p>

	</section>

    <section id="ipport"><title>Hébergements virtuels mixtes basés sur 
    les ports et sur les IP</title>

    <p>Le serveur dispose de deux adresses IP (<code>172.20.30.40</code> 
    et <code>172.20.30.50</code>) correspondant respectivement aux noms 
    <code>www.example.com</code> et <code>www.example.org</code>. 
    Pour chacun d'eux, nous voulons un hébergement sur les ports 80 
    et 8080.</p>

    <highlight language="config">
Listen 172.20.30.40:80
Listen 172.20.30.40:8080
Listen 172.20.30.50:80
Listen 172.20.30.50:8080

&lt;VirtualHost 172.20.30.40:80&gt;
    DocumentRoot "/www/example1-80"
    ServerName www.example.com
&lt;/VirtualHost&gt;

&lt;VirtualHost 172.20.30.40:8080&gt;
    DocumentRoot "/www/example1-8080"
    ServerName www.example.com
&lt;/VirtualHost&gt;

&lt;VirtualHost 172.20.30.50:80&gt;
    DocumentRoot "/www/example2-80"
    ServerName www.example.org
&lt;/VirtualHost&gt;

&lt;VirtualHost 172.20.30.50:8080&gt;
    DocumentRoot "/www/example2-8080"
    ServerName www.example.org
&lt;/VirtualHost&gt;
    </highlight>

	</section>

    <section id="mixed"><title>Hébergements virtuels mixtes basé sur 
    les noms et sur IP</title>

    <p>Toute adresse indiquée comme argument d'une section VirtualHost
    et n'apparaissant dans aucun autre serveur virtuel, fait de cette
    section un serveur virtuel sélectionnable uniquement en fonction de
    son adresse IP.</p>

    <highlight language="config">
Listen 80
&lt;VirtualHost 172.20.30.40&gt;
    DocumentRoot "/www/example1"
    ServerName www.example.com
&lt;/VirtualHost&gt;

&lt;VirtualHost 172.20.30.40&gt;
    DocumentRoot "/www/example2"
    ServerName www.example.org
&lt;/VirtualHost&gt;

&lt;VirtualHost 172.20.30.40&gt;
    DocumentRoot "/www/example3"
    ServerName www.example.net
&lt;/VirtualHost&gt;

# IP-based
&lt;VirtualHost 172.20.30.50&gt;
    DocumentRoot "/www/example4"
    ServerName www.example.edu
&lt;/VirtualHost&gt;

&lt;VirtualHost 172.20.30.60&gt;
    DocumentRoot "/www/example5"
    ServerName www.example.gov
&lt;/VirtualHost&gt;
    </highlight>

	</section>

    <section id="proxy"><title>Utilisation simultanée de 
    <code>Virtual_host</code> et de mod_proxy</title>

    <p>L'exemple suivant montre comment une machine peut mandater 
    un serveur virtuel fonctionnant sur le serveur d'une autre machine. 
    Dans cet exemple, un serveur virtuel de même nom est configuré sur 
    une machine à l'adresse <code>192.168.111.2</code>. La directive 
    <directive module="mod_proxy"
    name="ProxyPreserveHost">ProxyPreserveHost On</directive> est
    employée pour permette au nom de domaine d'être préservé lors du 
    transfert, au cas où plusieurs noms de domaines cohabitent sur 
    une même machine.</p>

    <highlight language="config">
&lt;VirtualHost *:*&gt;
    ProxyPreserveHost On
    ProxyPass        "/" "http://192.168.111.2/"
    ProxyPassReverse "/" "http://192.168.111.2/"
    ServerName hostname.example.com
&lt;/VirtualHost&gt;
    </highlight>

    </section>

    <section id="default"><title>Utilisation de serveurs virtuels 
    <code>_default_</code></title>

    <section id="defaultallports"><title>Serveurs virtuels 
    <code>_default_</code> pour tous les ports</title>

    <p>Exemple de capture de <em>toutes</em> les requêtes émanant 
    d'adresses IP ou de ports non connus, <em>c'est-à-dire</em>, d'un 
    couple adresse/port non traité par aucun autre serveur virtuel.</p>

    <highlight language="config">
&lt;VirtualHost _default_:*&gt;
    DocumentRoot "/www/default"
&lt;/VirtualHost&gt;
    </highlight>

    <p>L'utilisation d'un tel serveur virtuel avec un joker pour le 
    port empêche de manière efficace qu'une requête n'atteigne le 
    serveur principal.</p>

    <p>Un serveur virtuel par défaut ne servira jamais une requête 
    qui est envoyée vers un couple adresse/port utilisée par un 
    serveur virtuel par nom. Si la requête contient un en-tête 
    <code>Host:</code> inconnu, ou si celui-ci est absent, elle 
    sera toujours servie par le serveur virtuel primaire par nom 
    (celui correspondant à ce couple adresse/port trouvé en premier 
    dans le fichier de configuration).</p>

    <p>Vous pouvez utiliser une directive 
    <directive module="mod_alias">AliasMatch</directive> ou 
    <directive module="mod_rewrite">RewriteRule</directive> afin de 
    réécrire une requête pour une unique page d'information (ou pour 
    un script).</p>
    </section>

    <section id="defaultdifferentports"><title>Serveurs virtuels 
    <code>_default_</code> pour des ports différents</title>

    <p>La configuration est similaire à l'exemple précédent, mais 
    le serveur écoute sur plusieurs ports et un second serveur virtuel 
    <code>_default_</code> pour le port 80 est ajouté.</p>

    <highlight language="config">
&lt;VirtualHost _default_:80&gt;
    DocumentRoot "/www/default80"
    # ...
&lt;/VirtualHost&gt;

&lt;VirtualHost _default_:*&gt;
    DocumentRoot "/www/default"
    # ...
&lt;/VirtualHost&gt;
    </highlight>

    <p>Le serveur virtuel par défaut défini pour le port 80 (il doit 
    impérativement être placé avant un autre serveur virtuel par 
    défaut traitant tous les ports grâce au joker *) capture toutes 
    les requêtes envoyées sur une adresse IP non spécifiée. Le 
    serveur principal n'est jamais utilisé pour servir une requête.</p>
    </section>

    <section id="defaultoneport"><title>Serveurs virtuels 
    <code>_default_</code> pour un seul port</title>

    <p>Nous voulons créer un serveur virtuel par défaut seulement 
    pour le port 80.</p>

    <highlight language="config">
&lt;VirtualHost _default_:80&gt;
    DocumentRoot "/www/default"
...
&lt;/VirtualHost&gt;
    </highlight>

    <p>Une requête vers une adresse non spécifiée sur le port 80 
    sera servie par le serveur virtuel par défaut, et toute autre 
    requête vers une adresse et un port non spécifiés sera servie 
    par le serveur principal.</p>

    <p>L'utilisation du caractère générique <code>*</code> dans la
    déclaration d'un serveur virtuel l'emporte sur
    <code>_default_</code>.</p>
    </section>

	</section>

	<section id="migrate"><title>Migration d'un serveur virtuel 
	par nom en un serveur virtuel par IP</title>

    <p>Le serveur virtuel par nom avec le nom de domaine 
    <code>www.example.org</code> (de notre <a href="#name">exemple 
    par nom</a>) devrait obtenir sa propre adresse IP. Pendant la 
    phase de migration, il est possible d'éviter les problèmes avec 
    les noms de serveurs et autres serveurs mandataires qui mémorisent 
    les vielles adresses IP pour les serveurs virtuels par nom.<br />
    La solution est simple, car il suffit d'ajouter la nouvelle 
    adresse IP (<code>172.20.30.50</code>) dans la directive 
    <code>VirtualHost</code>.</p>

    <highlight language="config">
Listen 80
ServerName www.example.com
DocumentRoot "/www/example1"

&lt;VirtualHost 172.20.30.40 172.20.30.50&gt;
    DocumentRoot "/www/example2"
    ServerName www.example.org
    # ...
&lt;/VirtualHost&gt;

&lt;VirtualHost 172.20.30.40&gt;
    DocumentRoot "/www/example3"
    ServerName www.example.net
    ServerAlias *.example.net
    # ...
&lt;/VirtualHost&gt;
    </highlight>

    <p>Le serveur virtuel peut maintenant être joint par la nouvelle 
    adresse (comme un serveur virtuel par IP) et par l'ancienne 
    adresse (comme un serveur virtuel par nom).</p>

	</section>

    <section id="serverpath"><title>Utilisation de la directive 
    <code>ServerPath</code></title>

    <p>Dans le cas où vous disposez de deux serveurs virtuels par nom, 
    le client doit transmettre un en-tête <code>Host:</code> correct 
    pour déterminer le serveur concerné. Les vieux clients HTTP/1.0 
    n'envoient pas un tel en-tête et Apache n'a aucun indice pour 
    connaître le serveur virtuel devant être joint (il sert la 
    requête à partir d'un serveur virtuel primaire). Dans un soucis 
    de préserver la compatibilité descendante, il suffit de créer 
    un serveur virtuel primaire chargé de retourner une page contenant 
    des liens dont les URLs auront un préfixe identifiant les serveurs 
    virtuels par nom.</p>

    <highlight language="config">
&lt;VirtualHost 172.20.30.40&gt;
    # serveur virtuel primaire
    DocumentRoot "/www/subdomain"
    RewriteEngine On
    RewriteRule "." "/www/subdomain/index.html"
    # ...
&lt;/VirtualHost&gt;

&lt;VirtualHost 172.20.30.40&gt;
    DocumentRoot "/www/subdomain/sub1"
    ServerName www.sub1.domain.tld
    ServerPath "/sub1/"
    RewriteEngine On
    RewriteRule "^(/sub1/.*)" "/www/subdomain$1
    # ...
&lt;/VirtualHost&gt;

&lt;VirtualHost 172.20.30.40&gt;
    DocumentRoot "/www/subdomain/sub2"
    ServerName www.sub2.domain.tld
    ServerPath "/sub2/"
    RewriteEngine On
    RewriteRule "^(/sub2/.*)" "/www/subdomain$1"
    # ...
&lt;/VirtualHost&gt;
    </highlight>

    <p>À cause de la directive 
    <directive module="core">ServerPath</directive>, une requête sur 
    une URL <code>http://www.sub1.domain.tld/sub1/</code> est 
    <em>toujours</em> servie par le serveur sub1-vhost.<br />
    Une requête sur une URL <code>http://www.sub1.domain.tld/</code> n'est 
    servie par le serveur sub1-vhost que si le client envoie un en-tête 
    <code>Host:</code> correct. Si aucun en-tête <code>Host:</code> 
    n'est transmis, le serveur primaire sera utilisé.</p>
    <p>Notez qu'il y a une singularité&nbsp;: une requête sur 
    <code>http://www.sub2.domain.tld/sub1/</code> est également servie 
    par le serveur sub1-vhost si le client n'envoie pas d'en-tête 
    <code>Host:</code>.</p>
    <p>Les directives <directive module="mod_rewrite">RewriteRule</directive> 
    sont employées pour s'assurer que le client qui envoie un en-tête 
    <code>Host:</code> correct puisse utiliser d'autres variantes d'URLs, 
    <em>c'est-à-dire</em> avec ou sans préfixe d'URL.</p>

	</section>

</manualpage>
