# Copyright 2001-2019 The Apache Software Foundation or its licensors, as
# applicable.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# ====================================================================
#
# NMAKEbuild.inc  Master HTTPD definitions.
#
# Common params:
#                 CPU       Compile for specified CPU. Supported CPU's are:
#                           X86 (Common x86 architecture)
#                           X64 (AMD64/EMT64 architecture)
#                           I64 (Intel IA64 architecture)
#                           If not specified it will default to the
#                           PROCESSOR_ARCHITECTURE environment variable
#                           or to the X86 if not specified.
#                 WINVER    Compile for specified Windows version
#                           WINNT   for Windows 2000 and up(default)
#                           WINXP   for Windows XP and up
#                           WIN2003 for Windows 2003 and up
#                           WVISTA  for Windows Vista and up
#                           WIN7    for Windows 7 and up
#                 BUILD     Build version
#                           RETAIL or RELEASE (default)
#                           DEBUG
#                 TARGET    Build application target
#                           EXE Console executable (default)
#                           GUI Windows GUI executable
#                           DLL Dynamic Link Library
#                           LIB Static library
# Environment variables  used wint EXTRA_ prefix:
#                 CFLAGS    Added to the common CFLAGS
#                 CPPFLAGS  Added to the common CPPFLAGS
#                 LIBS      Added to the common LIBS
#                 INCLUDES  Added to the common INCLUDES
#                 LFLAGS    Added to the common LFLAGS
#                 RCFLAGS   Added to the common RCFLAGS
#
# Compiler tools environment variables:
#                 CC        C compiler  (defaults to cl.exe)
#                 LINK      Linker (defaults to link.exe)
#                 RC        Resource compiler (defaults to rc.exe)
#                 MT        Manifest toolkit (defaults to mt.exe)
#                 ML        Assembler (defaults to ml.exe or ml64.exe)
#
# ====================================================================
#

CC =cl.exe
LINK = link.exe
RC = rc.exe
MT = mt.exe

BUILD=RELEASE
CPU=X64
MACHINE=X64
!IF !DEFINED(TARGET) || "$(TARGET)" == ""
TARGET=EXE
!ENDIF

!IF "$(TARGET)" != "EXE"
!IF "$(TARGET)" != "GUI"
!IF "$(TARGET)" != "DLL"
!IF "$(TARGET)" != "LIB"
!ERROR Must specify TARGET environment variable (EXE, GUI, DLL, LIB)
!ENDIF
!ENDIF
!ENDIF
!ENDIF

NMAKE_WINVER = 0x0A00
NMAKE_WINNT = -D_WINNT -DWINNT -D_WIN32_WINNT=$(NMAKE_WINVER) -DWINVER=$(NMAKE_WINVER)

# Common flags for all platforms
CMN_CFLAGS = -c -nologo -DWIN32 -D_WIN32 -DWIN64 -D_WIN64 -D_WINDOWS $(NMAKE_WINNT)
!IF "$(TARGET)" == "EXE"
CMN_CFLAGS = $(CMN_CFLAGS) -D_CONSOLE
!ENDIF

OPT_CFLAGS = -Gs0 -GF -Gy -O2 -Ob2 -Zi -DNDEBUG -W3
CRT_CFLAGS = -MT

CFLAGS = $(CMN_CFLAGS) $(OPT_CFLAGS) $(CRT_CFLAGS) $(CFLAGS)
!IF DEFINED(EXTRA_CFLAGS)
CFLAGS = $(CFLAGS) $(EXTRA_CFLAGS)
!ENDIF

CPPFLAGS = -TP -EHsc
!IF DEFINED(EXTRA_CPPFLAGS)
CPPFLAGS = $(CPPFLAGS) $(EXTRA_CPPFLAGS)
!ENDIF

# Linker section
LIBS = kernel32.lib advapi32.lib ws2_32.lib mswsock.lib ole32.lib shell32.lib rpcrt4.lib iphlpapi.lib

!IF DEFINED(EXTRA_LIBS)
LIBS = $(LIBS) $(EXTRA_LIBS)
!ENDIF

COMMON_LFLAGS = /NOLOGO

# Always add debugging to the linker
OPT_LFLAGS = /INCREMENTAL:NO /OPT:REF /DEBUG

!IF "$(TARGET)" == "EXE"
LFLAGS = $(COMMON_LFLAGS) /SUBSYSTEM:CONSOLE /MACHINE:$(MACHINE)
!ELSEIF "$(TARGET)" == "GUI"
LFLAGS = $(COMMON_LFLAGS) /SUBSYSTEM:WINDOWS /MACHINE:$(MACHINE)
!ELSEIF "$(TARGET)" == "DLL"
LFLAGS = $(COMMON_LFLAGS) /DLL /SUBSYSTEM:WINDOWS /MACHINE:$(MACHINE)
!ELSEIF "$(TARGET)" == "LIB"
LFLAGS = -lib $(COMMON_LFLAGS)
!ENDIF

!IF DEFINED(EXTRA_LFLAGS)
LFLAGS = $(LFLAGS) $(EXTRA_LFLAGS)
!ENDIF

!IF "$(TARGET)" != "LIB"
LFLAGS = $(LFLAGS) /NODEFAULTLIB:libucrt.lib /DEFAULTLIB:ucrt.lib $(OPT_LFLAGS)
!ENDIF

# Resource compiler flags
RCFLAGS = /nologo /l 0x409 /n /d WIN32 /d _WIN32 /d _WIN32_WINNT=$(NMAKE_WINVER) /d WINVER=$(NMAKE_WINVER) /d WIN32_LEAN_AND_MEAN /d NDEBUG
!IF DEFINED(EXTRA_RCFLAGS)
RCFLAGS = $(RCFLAGS) $(EXTRA_RCFLAGS)
!ENDIF
!IF "$(TARGET)" == "EXE"
RCFLAGS = $(RCFLAGS) /d HTTPD_EMBED_MANIFEST
!ENDIF

# Build Target dir e.g. X86_RELEASE_DLL
!IF !DEFINED(WORKDIR) || "$(WORKDIR)" == ""
!IF !DEFINED(BUILDIR_EXT) || "$(BUILDIR_EXT)" == ""
WORKDIR = $(CPU)_$(BUILD)_$(TARGET)
WORKDIR_DLL = $(CPU)_$(BUILD)_DLL
WORKDIR_LIB = $(CPU)_$(BUILD)_LIB
WORKDIR_EXE = $(CPU)_$(BUILD)_EXE
WORKDIR_GUI = $(CPU)_$(BUILD)_GUI
!ELSE
WORKDIR = $(CPU)_$(BUILD)_$(BUILDIR_EXT)
!ENDIF
!ENDIF

CLEANTARGET=if exist "$(WORKDIR)\$(NULL)" rd /s /q $(WORKDIR)
MAKEWORKDIR=if not exist "$(WORKDIR)\$(NULL)" mkdir $(WORKDIR)
MAKEINSTALL=if not exist "$(INSTALLLOC)" mkdir $(INSTALLLOC)

!IF DEFINED(JAVA_HOME) && "$(JAVA_HOME)" != ""
JAVA_INCLUDES=-I "$(JAVA_HOME)\include" -I "$(JAVA_HOME)\include\win32"
!ENDIF

