# Copyright(c) 2024 Red Hat, Inc.
#
# This is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This software is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library in the file COPYING.LIB;
# if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#
# ====================================================================
#
# xbuild.inc Master makefile definitions.
#            This file defines CPU architecture and basic compiler
#            and linker parameters.
# Common params:
#                 WINVER    Compile for specified Windows version
#                           Default is 0x0A00 (Windows 7 and up)
#                 TARGET    Build application target
#                           EXE Console executable (default)
#                           GUI Windows GUI executable
#                           DLL Dynamic Link Library# Always add debugging to the linker
#                           LIB Static library
#
# Environment variables  used wint EXTRA_ prefix:
#                 CFLAGS    Added to the common CFLAGS
#                 CPPFLAGS  Added to the common CPPFLAGS
#                 LIBS      Added to the common LIBS
#                 INCLUDES  Added to the common INCLUDES
#                 LFLAGS    Added to the common LFLAGS
#                 RCFLAGS   Added to the common RCFLAGS
#
#
# ====================================================================
#

CC = cl.exe
LINK = link.exe
RC = rc.exe
MT = mt.exe
CPU = X64
MACHINE=x64
_LIB=lib64


!IF !DEFINED(TARGET) || "$(TARGET)" == ""
TARGET=EXE
!ENDIF

!IF "$(TARGET)" != "EXE"
!IF "$(TARGET)" != "GUI"
!IF "$(TARGET)" != "DLL"
!IF "$(TARGET)" != "LIB"
!ERROR Must specify TARGET environment variable (EXE, GUI, DLL, LIB)
!ENDIF
!ENDIF
!ENDIF
!ENDIF

!IF !DEFINED(WINVER) || "$(WINVER)" == ""
WINVER=0x0A00
!ENDIF

NMAKE_WINVER = $(WINVER)
NMAKE_WINNT = -D_WIN32_WINNT=$(NMAKE_WINVER) -DWINVER=$(NMAKE_WINVER) -DWIN32_LEAN_AND_MEAN

# Common flags for all platforms
CMN_CFLAGS = $(NMAKE_WINNT) -D_CRT_SECURE_NO_WARNINGS  -D_CRT_SECURE_NO_DEPRECATE
!IF "$(TARGET)" == "EXE"
CMN_CFLAGS = $(CMN_CFLAGS) -D_CONSOLE
!ENDIF

CFLAGS = -c -nologo -W3 -O2 -Ob2 -GF -Gs0 -MT $(CMN_CFLAGS)
!IF DEFINED(EXTRA_CFLAGS)
CFLAGS = $(CFLAGS) $(EXTRA_CFLAGS)
!ENDIF

# Appending extra CFLAGS from parsed RPM specfile
!IF DEFINED(EXTRA_SPECFILE_CFLAGS)
CFLAGS = $(CFLAGS) $(EXTRA_SPECFILE_CFLAGS)
!ENDIF

CPPFLAGS = -TP -EHsc
!IF DEFINED(EXTRA_CPPFLAGS)
CPPFLAGS = $(CPPFLAGS) $(EXTRA_CPPFLAGS)
!ENDIF

# Linker section
LIBS = kernel32.lib advapi32.lib

CMN_LFLAGS = /nologo

OPT_LFLAGS = /INCREMENTAL:NO /OPT:REF
OPT_LFLAGS = $(OPT_LFLAGS) /NODEFAULTLIB:libucrt.lib /DEFAULTLIB:ucrt.lib
MACHINE=x64

!IF "$(TARGET)" == "EXE"
LFLAGS = $(CMN_LFLAGS) $(OPT_LFLAGS) /SUBSYSTEM:CONSOLE /MACHINE:$(MACHINE)
!ELSEIF "$(TARGET)" == "GUI"
LFLAGS = $(CMN_LFLAGS) $(OPT_LFLAGS) /SUBSYSTEM:WINDOWS /MACHINE:$(MACHINE)
!ELSEIF "$(TARGET)" == "DLL"
LFLAGS = $(CMN_LFLAGS) $(OPT_LFLAGS) /DLL /MACHINE:$(MACHINE)
!ELSEIF "$(TARGET)" == "LIB"
LFLAGS = -lib $(CMN_LFLAGS)
!ENDIF

!IF DEFINED(EXTRA_LFLAGS)
LFLAGS = $(LFLAGS) $(EXTRA_LFLAGS)
!ENDIF

# Resource compiler flags

BASE_RCFLAGS= -nologo -l 0x409 -n -d NDEBUG
RCFLAGS = $(BASE_RCFLAGS) -d WINVER=$(NMAKE_WINVER) -d _WIN32_WINNT=$(NMAKE_WINVER) -d WIN32_LEAN_AND_MEAN
!IF DEFINED(EXTRA_RCFLAGS)
RCFLAGS = $(RCFLAGS) $(EXTRA_RCFLAGS)
!ENDIF

# Build Target dir e.g. X64_RELEASE_DLL
!IF !DEFINED(WORKDIR) || "$(WORKDIR)" == ""
!IF !DEFINED(BUILDIR_EXT) || "$(BUILDIR_EXT)" == ""
WORKDIR = $(CPU)_RELEASE_$(TARGET)
WORKDIR_DLL = $(CPU)_RELEASE_DLL
WORKDIR_LIB = $(CPU)_RELEASE_LIB
WORKDIR_EXE = $(CPU)_RELEASE_EXE
WORKDIR_GUI = $(CPU)_RELEASE_GUI
!ELSE
WORKDIR = $(CPU)_RELEASE_$(BUILDIR_EXT)
!ENDIF
!ENDIF

CLEANTARGET=-rd /S /Q $(WORKDIR) 2>NUL
MAKEWORKDIR=-md $(WORKDIR) 2>NUL
MAKEINSTALL=-md $(INSTALLLOC) 2>NUL

!IF DEFINED(JAVA_HOME) && "$(JAVA_HOME)" != ""
JAVA_INCLUDES=-I "$(JAVA_HOME)\include" -I "$(JAVA_HOME)\include\win32"
!ENDIF

!IF !DEFINED(ML) || "$(ML)" == ""
ML = ml64.exe
AFLAGS = /Zi /c
!ENDIF

