/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.converter;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerDrivenTimePatternConverterTest extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(TimerDrivenTimePatternConverterTest.class);
    
    public void testTimerInvocation() throws Exception {
        MockEndpoint mock = getMockEndpoint("mock:result"); 
        mock.expectedMinimumMessageCount(2);

        assertMockEndpointsSatisfied();
    }

    public void testTimerUsingStopWatch() throws Exception {
        MockEndpoint mock = getMockEndpoint("mock:result"); 
        mock.expectedMinimumMessageCount(2);

        StopWatch watch = new StopWatch();
        assertMockEndpointsSatisfied();
        long interval = watch.stop();
        
        LOG.trace("Should take approx 2000 milliseconds, was: {}", interval);
        assertTrue("Should take approx 2000 milliseconds, was: " + interval, interval >= 1700);
    }
    
    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder() {
            public void configure() {
                from("timer://foo?fixedRate=true&delay=0&period=2s").to("mock:result");
            }
        };
    } 
}
