package org.infinispan.server.test.util;

import org.apache.log4j.Logger;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;

/**
 * Logs test methods.
 * 
 * @author <a href="mailto:mlinhard@redhat.com">Michal Linhard</a>
 * @author <a href="mailto:vchepeli@redhat.com">Vitalii Chepeliuk</a>
 *
 */
public class TestsuiteListener extends RunListener {
    
    private static final Logger log = Logger.getLogger(TestsuiteListener.class);

    @Override
    public void testStarted(Description description) throws Exception {
        super.testStarted(description);
        log.info("Running " + description.getClassName() + "#" + description.getMethodName());
    }

    @Override
    public void testRunStarted(Description description) throws Exception {
        super.testRunStarted(description);
        printEnvInformation();

    }

    public void printEnvInformation() {
        log.info("~~~~~~~~~~~~~~~~~~~~~~~~~ ENVIRONMENT INFO ~~~~~~~~~~~~~~~~~~~~~~~~~~");
        log.info("java.runtime.version = " + System.getProperty("java.runtime.version"));
        log.info("java.runtime.name =" + System.getProperty("java.runtime.name"));
        log.info("java.vm.version = " + System.getProperty("java.vm.version"));
        log.info("java.vm.vendor = " + System.getProperty("java.vm.vendor"));
        log.info("os.name = " + System.getProperty("os.name"));
        log.info("os.version = " + System.getProperty("os.version"));
        log.info("sun.arch.data.model = " + System.getProperty("sun.arch.data.model"));
        log.info("sun.cpu.endian = " + System.getProperty("sun.cpu.endian"));
        log.info("java.net.preferIPv4Stack = " + System.getProperty("java.net.preferIPv4Stack"));
        log.info("java.net.preferIPv6Stack = " + System.getProperty("java.net.preferIPv6Stack"));
        log.info("log4.configuration = " + System.getProperty("log4j.configuration"));
        log.info("MAVEN_OPTS = " + System.getProperty("MAVEN_OPTS"));
        log.info("~~~~~~~~~~~~~~~~~~~~~~~~~ ENVIRONMENT INFO ~~~~~~~~~~~~~~~~~~~~~~~~~~");
    }
}
